/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.vector;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.util.TemporaryListener;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.player.PlayerMetadata;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.VectorSkillResult;
import io.lumine.mythic.lib.version.Sounds;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Corrupted_Fangs
extends SkillHandler<VectorSkillResult> {
    public Corrupted_Fangs() {
        this.registerModifiers("damage", "fangs");
    }

    @Override
    public VectorSkillResult getResult(SkillMetadata meta) {
        return new VectorSkillResult(meta);
    }

    @Override
    public void whenCast(final VectorSkillResult result, final SkillMetadata skillMeta) {
        final Player caster = skillMeta.getCaster().getPlayer();
        caster.getWorld().playSound(caster.getLocation(), Sounds.ENTITY_WITHER_SHOOT, 2.0f, 2.0f);
        new BukkitRunnable(){
            final Vector vec;
            final Location loc;
            final FangsHandler handler;
            final double fangAmount;
            double ti;
            {
                this.vec = result.getTarget().setY(0).multiply(2);
                this.loc = caster.getLocation();
                this.handler = new FangsHandler(skillMeta.getCaster(), skillMeta.getParameter("damage"));
                this.fangAmount = skillMeta.getParameter("fangs");
                this.ti = 0.0;
            }

            public void run() {
                double d = this.ti;
                this.ti = d + 1.0;
                if (d >= this.fangAmount) {
                    this.handler.close(60L);
                    this.cancel();
                    return;
                }
                this.loc.add(this.vec);
                EvokerFangs evokerFangs = (EvokerFangs)caster.getWorld().spawnEntity(this.loc, EntityType.EVOKER_FANGS);
                this.handler.entities.add(evokerFangs.getEntityId());
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
    }

    public static class FangsHandler
    extends TemporaryListener {
        private final Set<Integer> entities = new HashSet<Integer>();
        private final PlayerMetadata caster;
        private final double skillDamage;

        public FangsHandler(PlayerMetadata caster, double skillDamage) {
            super(new HandlerList[0]);
            this.caster = caster;
            this.skillDamage = skillDamage;
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void a(EntityDamageByEntityEvent event) {
            if (event.getDamager() instanceof EvokerFangs && this.entities.contains(event.getDamager().getEntityId())) {
                event.setCancelled(true);
                if (UtilityMethods.canTarget(this.caster.getPlayer(), event.getEntity())) {
                    this.caster.attack((LivingEntity)event.getEntity(), this.skillDamage, DamageType.MAGIC, DamageType.SKILL);
                }
            }
        }
    }
}

