/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.target;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.event.AttackEvent;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.TargetSkillResult;
import io.lumine.mythic.lib.version.Sounds;
import io.lumine.mythic.lib.version.VParticle;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Weaken_Target
extends SkillHandler<TargetSkillResult>
implements Listener {
    private static final Map<UUID, Double> MARKED_ENTITIES = new HashMap<UUID, Double>();

    public Weaken_Target() {
        this.registerModifiers("duration", "extra-damage");
    }

    @Override
    public TargetSkillResult getResult(SkillMetadata meta) {
        return new TargetSkillResult(meta);
    }

    @Override
    public void whenCast(TargetSkillResult result, final SkillMetadata skillMeta) {
        final LivingEntity target = result.getTarget();
        MARKED_ENTITIES.put(target.getUniqueId(), 1.0 + skillMeta.getParameter("extra-damage") / 100.0);
        this.playWeakenEffect(target.getLocation());
        target.getWorld().playSound(target.getLocation(), Sounds.ENTITY_ENDERMAN_HURT, 2.0f, 1.5f);
        new BukkitRunnable(){
            final long expire;
            {
                this.expire = System.currentTimeMillis() + (long)(skillMeta.getParameter("duration") * 1000.0);
            }

            public void run() {
                if (!MARKED_ENTITIES.containsKey(target.getUniqueId()) || this.expire < System.currentTimeMillis()) {
                    this.cancel();
                    return;
                }
                for (double j = 0.0; j < Math.PI * 2; j += 0.17453292519943295) {
                    target.getWorld().spawnParticle(VParticle.SMOKE.get(), target.getLocation().clone().add(Math.cos(j) * 0.7, 0.1, Math.sin(j) * 0.7), 0);
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 20L);
    }

    @EventHandler
    public void a(AttackEvent event) {
        if (event.toBukkit().getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK && event.toBukkit().getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION && event.toBukkit().getCause() != EntityDamageEvent.DamageCause.PROJECTILE) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Double found = MARKED_ENTITIES.get(entity.getUniqueId());
        if (found != null) {
            event.getDamage().multiplicativeModifier(found);
            this.playWeakenEffect(entity.getLocation());
            MARKED_ENTITIES.remove(entity.getUniqueId());
            entity.getWorld().playSound(entity.getLocation(), Sounds.ENTITY_ENDERMAN_DEATH, 2.0f, 2.0f);
        }
    }

    @EventHandler
    public void removeMark(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item.getType() == Material.MILK_BUCKET && MARKED_ENTITIES.containsKey(player.getUniqueId())) {
            MARKED_ENTITIES.remove(player.getUniqueId());
            player.getWorld().playSound(player.getLocation(), Sounds.ENTITY_ENDERMAN_DEATH, 2.0f, 2.0f);
        }
    }

    private void playWeakenEffect(final Location loc) {
        new BukkitRunnable(){
            double y = 0.0;

            public void run() {
                for (int j = 0; j < 3; ++j) {
                    this.y += 0.07;
                    for (int k = 0; k < 3; ++k) {
                        loc.getWorld().spawnParticle(VParticle.REDSTONE.get(), loc.clone().add(Math.cos(this.y * Math.PI + (double)k * Math.PI * 2.0 / 3.0) * (3.0 - this.y) / 2.5, this.y, Math.sin(this.y * Math.PI + (double)k * Math.PI * 2.0 / 3.0) * (3.0 - this.y) / 2.5), 1, (Object)new Particle.DustOptions(Color.BLACK, 1.0f));
                    }
                }
                if (this.y > 3.0) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
    }
}

