/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.skill.handler.def.simple;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.skill.handler.SkillHandler;
import io.lumine.mythic.lib.skill.result.def.SimpleSkillResult;
import io.lumine.mythic.lib.version.Sounds;
import io.lumine.mythic.lib.version.VParticle;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Magical_Path
extends SkillHandler<SimpleSkillResult> {
    public Magical_Path() {
        this.registerModifiers("duration");
    }

    @Override
    public SimpleSkillResult getResult(SkillMetadata meta) {
        return new SimpleSkillResult();
    }

    @Override
    public void whenCast(SimpleSkillResult result, SkillMetadata skillMeta) {
        new MagicalPathEffect(skillMeta.getCaster().getPlayer(), skillMeta.getParameter("duration"));
    }

    public class MagicalPathEffect
    extends BukkitRunnable
    implements Listener {
        private final Player player;
        private final long duration;
        private boolean safe = true;
        private int j = 0;

        public MagicalPathEffect(Player player, double duration) {
            this.player = player;
            this.duration = (long)(duration * 10.0);
            player.setAllowFlight(true);
            player.setFlying(true);
            player.setVelocity(player.getVelocity().setY(0.5));
            player.getWorld().playSound(player.getLocation(), Sounds.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            this.runTaskTimer((Plugin)MythicLib.plugin, 0L, 2L);
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)MythicLib.plugin);
        }

        public void close() {
            this.player.setAllowFlight(false);
            HandlerList.unregisterAll((Listener)this);
            this.cancel();
        }

        @EventHandler(priority=EventPriority.LOW)
        public void a(EntityDamageEvent event) {
            if (this.safe && event.getEntity().equals((Object)this.player) && event.getCause() == EntityDamageEvent.DamageCause.FALL) {
                event.setCancelled(true);
                this.safe = false;
                this.player.getWorld().spawnParticle(VParticle.EFFECT.get(), this.player.getLocation(), 8, 0.35, 0.0, 0.35, 0.08);
                this.player.getWorld().spawnParticle(VParticle.INSTANT_EFFECT.get(), this.player.getLocation(), 16, 0.35, 0.0, 0.35, 0.08);
                this.player.getWorld().playSound(this.player.getLocation(), Sounds.ENTITY_ENDERMAN_HURT, 1.0f, 2.0f);
            }
        }

        @EventHandler
        public void b(PlayerQuitEvent event) {
            if (event.getPlayer().equals((Object)this.player)) {
                this.close();
            }
        }

        public void run() {
            if ((long)this.j++ > this.duration) {
                this.player.getWorld().playSound(this.player.getLocation(), Sounds.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                this.player.setAllowFlight(false);
                this.cancel();
                return;
            }
            this.player.getWorld().spawnParticle(VParticle.EFFECT.get(), this.player.getLocation(), 8, 0.5, 0.0, 0.5, 0.1);
            this.player.getWorld().spawnParticle(VParticle.INSTANT_EFFECT.get(), this.player.getLocation(), 16, 0.5, 0.0, 0.5, 0.1);
        }
    }
}

