/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.variable;

import io.lumine.mythic.lib.script.variable.VariableContainer;
import io.lumine.mythic.lib.script.variable.VariableMetadata;
import io.lumine.mythic.lib.script.variable.VariableRegistry;
import io.lumine.mythic.lib.util.lang3.Validate;
import javax.annotation.Nullable;

public abstract class Variable<D>
implements VariableContainer {
    private final String name;
    private D stored;

    public Variable(String name, D stored) {
        this.name = name;
        this.stored = stored;
        Validate.isTrue(this.getClass().isAnnotationPresent(VariableMetadata.class), "Variable type with no VariableMetadata annotation", new Object[0]);
    }

    public String getName() {
        return this.name;
    }

    public D getStored() {
        return this.stored;
    }

    public void setStored(D d) {
        this.stored = d;
    }

    public abstract VariableRegistry<Variable<D>> getVariableRegistry();

    @Override
    @Nullable
    public Variable<?> getVariable(String name) {
        return this.getVariableRegistry().accessVariable(this, name);
    }

    public String toString() {
        return this.stored == null ? "None" : this.stored.toString();
    }
}

