/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.mechanic.visual;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.script.mechanic.MechanicMetadata;
import io.lumine.mythic.lib.script.mechanic.type.LocationMechanic;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.util.DoubleFormula;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import io.lumine.mythic.lib.version.Sounds;
import org.bukkit.Location;
import org.bukkit.Sound;

@MechanicMetadata
public class SoundMechanic
extends LocationMechanic {
    private final Sound bukkitSound;
    private final String soundString;
    private final DoubleFormula vol;
    private final DoubleFormula pitch;

    public SoundMechanic(ConfigObject config) {
        super(config);
        Sound bukkitSound;
        config.validateKeys("sound");
        this.soundString = config.getString("sound");
        try {
            bukkitSound = Sounds.fromName(UtilityMethods.enumName(this.soundString));
        }
        catch (Exception exception) {
            bukkitSound = null;
        }
        this.bukkitSound = bukkitSound;
        this.vol = config.getDoubleFormula("volume", DoubleFormula.constant(1.0));
        this.pitch = config.getDoubleFormula("pitch", DoubleFormula.constant(1.0));
    }

    @Override
    public void cast(SkillMetadata meta, Location loc) {
        float vol = (float)this.vol.evaluate(meta);
        float pitch = (float)this.pitch.evaluate(meta);
        if (this.bukkitSound == null) {
            loc.getWorld().playSound(loc, this.soundString, vol, pitch);
        } else {
            loc.getWorld().playSound(loc, this.bukkitSound, vol, pitch);
        }
    }
}

