/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.script.mechanic.visual;

import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.script.mechanic.MechanicMetadata;
import io.lumine.mythic.lib.script.mechanic.type.TargetMechanic;
import io.lumine.mythic.lib.skill.SkillMetadata;
import io.lumine.mythic.lib.util.DoubleFormula;
import io.lumine.mythic.lib.util.configobject.ConfigObject;
import io.lumine.mythic.lib.util.lang3.Validate;
import io.lumine.mythic.lib.version.Sounds;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@MechanicMetadata
public class PlayerSoundMechanic
extends TargetMechanic {
    private final Sound bukkitSound;
    private final String soundString;
    private final DoubleFormula vol;
    private final DoubleFormula pitch;

    public PlayerSoundMechanic(ConfigObject config) {
        super(config);
        Sound bukkitSound;
        config.validateKeys("sound");
        this.soundString = config.getString("sound");
        try {
            bukkitSound = Sounds.fromName(UtilityMethods.enumName(this.soundString));
        }
        catch (Exception exception) {
            bukkitSound = null;
        }
        this.bukkitSound = bukkitSound;
        this.vol = config.getDoubleFormula("volume", DoubleFormula.constant(1.0));
        this.pitch = config.getDoubleFormula("pitch", DoubleFormula.constant(1.0));
    }

    @Override
    public void cast(SkillMetadata meta, Entity target) {
        Validate.isTrue(target instanceof Player, "Target is not player", new Object[0]);
        Player player = (Player)target;
        float vol = (float)this.vol.evaluate(meta);
        float pitch = (float)this.pitch.evaluate(meta);
        if (this.bukkitSound == null) {
            player.playSound(target.getLocation(), this.soundString, vol, pitch);
        } else {
            player.playSound(target.getLocation(), this.bukkitSound, vol, pitch);
        }
    }
}

