/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.module;

import io.lumine.mythic.lib.module.Module;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleWrapper<T extends Module> {
    private final Supplier<T> supplier;
    @Nullable
    private T current;

    private ModuleWrapper(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public void initialize() {
        Validate.isTrue(this.current == null, "Module is already open", new Object[0]);
        this.current = (Module)this.supplier.get();
    }

    public void close() {
        Validate.notNull(this.current, "Module is closed", new Object[0]);
    }

    @NotNull
    public static <T extends Module> ModuleWrapper<T> from(@NotNull Supplier<T> supplier) {
        return new ModuleWrapper<T>(supplier);
    }
}

