/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.manager;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.api.stat.StatInstance;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.api.stat.handler.AttributeStatHandler;
import io.lumine.mythic.lib.api.stat.handler.DelegateStatHandler;
import io.lumine.mythic.lib.api.stat.handler.MovementSpeedStatHandler;
import io.lumine.mythic.lib.api.stat.handler.StatHandler;
import io.lumine.mythic.lib.util.ConfigFile;
import io.lumine.mythic.lib.util.lang3.Validate;
import io.lumine.mythic.lib.version.VMaterial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatManager {
    private final Map<String, StatHandler> handlers = new HashMap<String, StatHandler>();
    private final Map<Attribute, Double> playerDefaultBaseValues = new HashMap<Attribute, Double>();

    public void initialize(boolean clearBefore) {
        if (clearBefore) {
            this.handlers.clear();
        } else {
            UtilityMethods.loadDefaultFile("", "stats.yml");
        }
        FileConfiguration statsConfig = new ConfigFile("stats").getConfig();
        try {
            this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "ARMOR", 0.0, Material.IRON_CHESTPLATE, "Armor bonus of an Entity."), new String[0]);
            this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "ARMOR_TOUGHNESS", 0.0, Material.GOLDEN_CHESTPLATE, "Armor toughness bonus of an Entity."), new String[0]);
            this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "ATTACK_DAMAGE", 1.0, Material.IRON_SWORD, "Attack damage of an Entity."), new String[0]);
            this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "ATTACK_SPEED", 4.0, Material.LIGHT_GRAY_DYE, "Attack speed of an Entity."), new String[0]);
            this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "KNOCKBACK_RESISTANCE", 0.0, Material.TNT_MINECART, "Resistance of an Entity to knockback."), new String[0]);
            this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "LUCK", 0.0, VMaterial.GRASS_BLOCK.get(), "Luck bonus of an Entity."), new String[0]);
            this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "MAX_HEALTH", 20.0, Material.APPLE, "Maximum health of an Entity."), new String[0]);
            MovementSpeedStatHandler msStatHandler = new MovementSpeedStatHandler((ConfigurationSection)statsConfig);
            this.registerStat(msStatHandler, new String[0]);
            this.registerStat(new DelegateStatHandler((ConfigurationSection)statsConfig, "SPEED_MALUS_REDUCTION", msStatHandler), new String[0]);
            if (MythicLib.plugin.getVersion().isAbove(1, 20, 2)) {
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "MAX_ABSORPTION", 0.0, Material.GOLDEN_APPLE, "Max amount of absorption hearts."), new String[0]);
            }
            if (MythicLib.plugin.getVersion().isAbove(1, 20, 5)) {
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "BLOCK_BREAK_SPEED", 1.0, Material.IRON_PICKAXE, "Speed of breaking blocks."), new String[0]);
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "BLOCK_INTERACTION_RANGE", 4.5, Material.SPYGLASS, "How far players may break or interact with blocks."), new String[0]);
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "ENTITY_INTERACTION_RANGE", 3.0, Material.SPYGLASS, "How far players may hit or interact with entities."), new String[0]);
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "FALL_DAMAGE_MULTIPLIER", 1.0, Material.GOLDEN_APPLE, "Max amount of absorption hearts."), new String[0]);
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "GRAVITY", 0.08, Material.STONE, "How strong gravity is."), new String[0]);
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "JUMP_STRENGTH", 0.42, Material.FEATHER, "How high you can jump."), new String[0]);
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "SAFE_FALL_DISTANCE", 3.0, Material.RED_BED, "How high you can drop from without fall damage."), new String[0]);
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "SCALE", 1.0, Material.GUARDIAN_SPAWN_EGG, "Size of an entity."), new String[0]);
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "STEP_HEIGHT", 0.6, Material.OAK_SLAB, "How high you can climb blocks when walking."), new String[0]);
            }
            if (MythicLib.plugin.getVersion().isAbove(1, 21)) {
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "BURNING_TIME", 1.0, Material.COOKED_BEEF, "A factor for increasing/reducing mining speed"), new String[0]);
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "EXPLOSION_KNOCKBACK_RESISTANCE", 0.0, Material.OBSIDIAN, "Resistance to knockback due to explosions."), new String[0]);
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "MINING_EFFICIENCY", 0.0, Material.IRON_PICKAXE, "A factor for increasing/reducing mining speed"), new String[0]);
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "MOVEMENT_EFFICIENCY", 0.0, Material.SOUL_SAND, "Movement speed factor when walking on blocks that slow down movement."), new String[0]);
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "OXYGEN_BONUS", 0.0, Material.GLASS_BOTTLE, "Determines the chance not to use up air when underwater."), new String[0]);
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "SNEAKING_SPEED", 0.3, Material.LEATHER_BOOTS, "Movement speed when sneaking."), new String[0]);
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "SUBMERGED_MINING_SPEED", 0.2, Material.IRON_PICKAXE, "Mining speed factor when submerged."), new String[0]);
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "SWEEPING_DAMAGE_RATIO", 0.0, Material.IRON_SWORD, "Damage ratio when performing sweep melee attacks."), new String[0]);
                this.registerStat(new AttributeStatHandler((ConfigurationSection)statsConfig, "WATER_MOVEMENT_EFFICIENCY", 0.0, Material.WATER_BUCKET, "Movement speed factor when submerged."), new String[0]);
            }
        }
        catch (Exception exception) {
            MythicLib.plugin.getLogger().log(Level.WARNING, "Could not load default stat handlers:");
            exception.printStackTrace();
        }
        for (String key : this.collectReferencedStats((ConfigurationSection)statsConfig)) {
            try {
                String stat = UtilityMethods.enumName(key);
                this.handlers.putIfAbsent(stat, new StatHandler((ConfigurationSection)statsConfig, stat));
            }
            catch (RuntimeException exception) {
                MythicLib.plugin.getLogger().log(Level.WARNING, "Could not load stat handler '" + key + "': " + exception.getMessage());
            }
        }
    }

    @NotNull
    private Iterable<String> collectReferencedStats(ConfigurationSection config) {
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : config.getKeys(false)) {
            keys.addAll(config.getConfigurationSection(key).getKeys(false));
        }
        return keys;
    }

    @NotNull
    public static String format(String stat, MMOPlayerData player) {
        return player.getStatMap().getInstance(stat).formatFinal();
    }

    @NotNull
    public static String format(String stat, double value) {
        @Nullable StatHandler handler = MythicLib.plugin.getStats().handlers.get(stat);
        return (handler == null ? MythicLib.plugin.getMMOConfig().decimal : handler.getDecimalFormat()).format(value);
    }

    public void registerStat(@NotNull StatHandler handler, String ... aliases) {
        Validate.notNull(handler, "StatHandler cannot be null", new Object[0]);
        this.handlers.put(handler.getStat(), handler);
        for (String alias : aliases) {
            this.handlers.put(alias, handler);
        }
        if (handler instanceof AttributeStatHandler) {
            this.playerDefaultBaseValues.put(((AttributeStatHandler)handler).getAttribute(), ((AttributeStatHandler)handler).getPlayerDefaultBase());
        }
    }

    @Nullable
    public Double getPlayerDefaultBaseValue(@NotNull Attribute attribute) {
        return this.playerDefaultBaseValues.get(attribute);
    }

    @NotNull
    public Optional<StatHandler> getHandler(String stat) {
        return Optional.ofNullable(this.handlers.get(stat));
    }

    public boolean isRegistered(String stat) {
        return this.handlers.containsKey(stat);
    }

    @NotNull
    public Set<String> getRegisteredStats() {
        return this.handlers.keySet();
    }

    @NotNull
    public Collection<StatHandler> getHandlers() {
        return this.handlers.values();
    }

    public void clearRegisteredStats(Predicate<StatHandler> filter) {
        Iterator<StatHandler> ite = this.handlers.values().iterator();
        while (ite.hasNext()) {
            if (!filter.test(ite.next())) continue;
            ite.remove();
        }
    }

    @Deprecated
    public void runUpdate(StatMap map, String stat) {
        map.getInstance(stat).update();
    }

    @Deprecated
    public void runUpdates(@NotNull StatMap map) {
        for (StatInstance ins : map.getInstances()) {
            ins.update();
        }
    }

    @Deprecated
    public void runUpdate(@NotNull StatInstance instance) {
        instance.update();
    }

    @Deprecated
    public double getBaseValue(String stat, StatMap map) {
        @Nullable StatHandler handler = this.handlers.get(stat);
        return handler == null ? 0.0 : handler.getBaseValue(map.getInstance(stat));
    }

    @Deprecated
    public double getBaseValue(StatInstance instance) {
        return instance.getBase();
    }

    @Deprecated
    public double getTotalValue(String stat, StatMap map) {
        return map.getStat(stat);
    }

    @Deprecated
    public double getTotalValue(StatInstance instance) {
        return instance.getTotal();
    }

    @Deprecated
    public void registerStat(String stat, StatHandler handler) {
        Validate.notNull(stat, "Stat cannot be null", new Object[0]);
        Validate.notNull(handler, "StatHandler cannot be null", new Object[0]);
        this.handlers.put(stat, handler);
    }
}

