/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.listener.option;

import fr.phoenixdevt.profiles.event.PlayerIdDispatchEvent;
import fr.phoenixdevt.profiles.event.ProfileSelectedEvent;
import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.gson.JsonObject;
import io.lumine.mythic.lib.gson.JsonParser;
import io.lumine.mythic.lib.util.lang3.Validate;
import io.lumine.mythic.lib.version.Attributes;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class FixAttributeModifiers
implements Listener {
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private final int targetRevId;
    private static final String PROFILELESS_KEY = "Profileless";
    private static final NamespacedKey TAG_PATH = NamespacedKey.fromString((String)"attr_mods_reset", (Plugin)MythicLib.plugin);

    public FixAttributeModifiers(ConfigurationSection config) {
        this.targetRevId = config.getInt("rev_id");
        Validate.isTrue(this.targetRevId >= 0, "Revision ID must be positive", new Object[0]);
        List _attributes = config.getStringList("attributes");
        if (_attributes.isEmpty()) {
            this.attributes.addAll(Attributes.getAll());
        } else {
            for (String str : _attributes) {
                this.attributes.add(Attributes.fromName(UtilityMethods.enumName(str)));
            }
        }
        try {
            Class.forName("fr.phoenixdevt.profiles.event.ProfileSelectedEvent");
            Bukkit.getPluginManager().registerEvents((Listener)new LegacyProfiles(), (Plugin)MythicLib.plugin);
        }
        catch (Exception exception) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)MythicLib.plugin);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void a(PlayerJoinEvent event) {
        this.checkForRevid(event.getPlayer(), PROFILELESS_KEY);
    }

    private void checkForRevid(@NotNull Player player, @NotNull String key) {
        int revid;
        if (!player.hasPlayedBefore()) {
            JsonObject json = new JsonObject();
            json.addProperty(key, this.targetRevId);
            player.getPersistentDataContainer().set(TAG_PATH, PersistentDataType.STRING, (Object)json.toString());
            return;
        }
        String jsonFormat = (String)player.getPersistentDataContainer().get(TAG_PATH, PersistentDataType.STRING);
        JsonObject json = jsonFormat == null ? new JsonObject() : JsonParser.parseString(jsonFormat).getAsJsonObject();
        int n = revid = json.has(key) ? json.get(key).getAsInt() : 0;
        if (revid < this.targetRevId) {
            json.addProperty(key, this.targetRevId);
            player.getPersistentDataContainer().set(TAG_PATH, PersistentDataType.STRING, (Object)json.toString());
            this.resetAttributeModifiers(player);
        }
    }

    private void resetAttributeModifiers(@NotNull Player player) {
        for (Attribute attribute : this.attributes) {
            AttributeInstance instance = player.getAttribute(attribute);
            if (instance == null) continue;
            for (AttributeModifier modifier : new ArrayList(instance.getModifiers())) {
                instance.removeModifier(modifier);
            }
        }
    }

    class LegacyProfiles
    implements Listener {
        LegacyProfiles() {
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onProfileSelect(ProfileSelectedEvent event) {
            FixAttributeModifiers.this.checkForRevid(event.getPlayer(), event.getProfile().getUniqueId().toString());
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onIdDispatch(PlayerIdDispatchEvent event) {
            FixAttributeModifiers.this.checkForRevid(event.getPlayer(), event.getFakeId() == null ? FixAttributeModifiers.PROFILELESS_KEY : event.getFakeId().toString());
        }
    }
}

