/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.damage;

import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.element.Element;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DamagePacket
implements Cloneable {
    @NotNull
    private DamageType[] types;
    private double value;
    private double additiveModifiers;
    private double multiplicativeModifiers = 1.0;
    @Nullable
    private Element element;

    public DamagePacket(double value, DamageType ... types) {
        this(value, (Element)null, types);
    }

    public DamagePacket(double value, @Nullable Element element, DamageType ... types) {
        this.value = value;
        this.types = types;
        this.element = element;
    }

    public double getValue() {
        return this.value;
    }

    @NotNull
    public DamageType[] getTypes() {
        return this.types;
    }

    @Nullable
    public Element getElement() {
        return this.element;
    }

    public void setTypes(@NotNull DamageType[] types) {
        this.types = Objects.requireNonNull(types, "Damage type array cannot be null");
    }

    public void setValue(double value) {
        Validate.isTrue(value >= 0.0, "Value cannot be negative", new Object[0]);
        this.value = value;
    }

    public void setElement(@Nullable Element element) {
        this.element = element;
    }

    public void multiplicativeModifier(double coefficient) {
        Validate.isTrue(coefficient >= 0.0, "Coefficient cannot be negative", new Object[0]);
        this.multiplicativeModifiers *= coefficient;
    }

    public void additiveModifier(double multiplier) {
        this.additiveModifiers += multiplier;
    }

    public double getFinalValue() {
        return this.value * Math.max(0.0, 1.0 + this.additiveModifiers) * this.multiplicativeModifiers;
    }

    public boolean hasType(DamageType type) {
        for (DamageType checked : this.types) {
            if (checked != type) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder damageTypes = new StringBuilder();
        damageTypes.append("\u00a7e").append("(").append(this.value).append("*").append(this.additiveModifiers).append("*").append(this.multiplicativeModifiers).append(")").append("x");
        boolean damageAppended = false;
        for (DamageType type : this.types) {
            if (damageAppended) {
                damageTypes.append("\u00a73/");
            }
            damageAppended = true;
            switch (type) {
                case WEAPON: {
                    damageTypes.append("\u00a77");
                    break;
                }
                case PHYSICAL: {
                    damageTypes.append("\u00a78");
                    break;
                }
                case PROJECTILE: {
                    damageTypes.append("\u00a7a");
                    break;
                }
                case MAGIC: {
                    damageTypes.append("\u00a79");
                    break;
                }
                case SKILL: {
                    damageTypes.append("\u00a7f");
                    break;
                }
                default: {
                    damageTypes.append("\u00a7c");
                }
            }
            damageTypes.append((Object)type);
            if (this.element == null) continue;
            damageTypes.append(",El=").append(this.element.getId());
        }
        return damageTypes.toString();
    }

    public DamagePacket clone() {
        DamagePacket clone = new DamagePacket(this.value, this.types);
        clone.additiveModifiers = this.additiveModifiers;
        clone.multiplicativeModifiers = this.multiplicativeModifiers;
        clone.element = this.element;
        return clone;
    }
}

