/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.comp.profile;

import fr.phoenixdevt.profiles.ProfileDataModule;
import fr.phoenixdevt.profiles.ProfileProvider;
import fr.phoenixdevt.profiles.event.ProfileSelectEvent;
import fr.phoenixdevt.profiles.event.ProfileUnloadEvent;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.event.SynchronizedDataLoadEvent;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.data.SynchronizedDataHolder;
import io.lumine.mythic.lib.data.SynchronizedDataManager;
import io.lumine.mythic.lib.skill.trigger.TriggerMetadata;
import io.lumine.mythic.lib.skill.trigger.TriggerType;
import io.lumine.mythic.lib.util.Tasks;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class LegacyProfiles
implements Listener {
    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onProfileChooseSkillTrigger(ProfileSelectEvent event) {
        MMOPlayerData playerData = MMOPlayerData.get((OfflinePlayer)event.getPlayer());
        playerData.triggerSkills(new TriggerMetadata(playerData, TriggerType.LOGIN));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void updateProfileId(ProfileSelectEvent event) {
        MMOPlayerData.get((OfflinePlayer)event.getPlayer()).setProfileId(event.getProfile().getUniqueId());
    }

    public static <H extends SynchronizedDataHolder> void hook(@NotNull ProfileProvider profilePlugin, @NotNull ProfileDataModule module, @NotNull SynchronizedDataManager<H, ?> manager, @NotNull Listener fictiveListener, @NotNull EventPriority joinEventPriority, @NotNull EventPriority quitEventPriority) {
        profilePlugin.registerModule(module);
        UtilityMethods.registerEvent(ProfileSelectEvent.class, fictiveListener, joinEventPriority, event -> {
            @NotNull H data = manager.get((OfflinePlayer)event.getPlayer());
            if (((SynchronizedDataHolder)data).isSynchronized()) {
                event.validate(module);
            } else {
                manager.loadData(data).thenAccept((Consumer)Tasks.sync((Plugin)manager.getOwningPlugin(), v -> {
                    event.validate(module);
                    data.markAsSynchronized();
                    Bukkit.getPluginManager().callEvent((Event)new SynchronizedDataLoadEvent(manager, (SynchronizedDataHolder)data, (Event)event));
                }));
            }
        }, (Plugin)manager.getOwningPlugin(), false);
        UtilityMethods.registerEvent(ProfileUnloadEvent.class, fictiveListener, quitEventPriority, event -> manager.unregister(event.getPlayer()).thenAccept((Consumer)Tasks.sync((Plugin)manager.getOwningPlugin(), v -> event.validate(module))), (Plugin)manager.getOwningPlugin(), false);
    }
}

