/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.comp.mythicmobs;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.skills.ISkillMechanic;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.conditions.ISkillCondition;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.compatibility.MythicLibSupport;
import io.lumine.mythic.bukkit.events.MythicConditionLoadEvent;
import io.lumine.mythic.bukkit.events.MythicMechanicLoadEvent;
import io.lumine.mythic.bukkit.events.MythicReloadedEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.skills.placeholders.Placeholder;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.comp.mythicmobs.condition.CanTargetCondition;
import io.lumine.mythic.lib.comp.mythicmobs.mechanic.MMODamageMechanic;
import io.lumine.mythic.lib.comp.mythicmobs.mechanic.MultiplyDamageMechanic;
import io.lumine.mythic.lib.damage.AttackMetadata;
import io.lumine.mythic.lib.damage.DamageType;
import io.lumine.mythic.lib.manager.StatManager;
import io.lumine.mythic.lib.player.PlayerMetadata;
import io.lumine.mythic.lib.player.cooldown.CooldownInfo;
import io.lumine.mythic.lib.player.cooldown.CooldownMap;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityDamageEvent;

public class MythicLibSupportImpl
extends ReloadableModule<MythicBukkit>
implements MythicLibSupport {
    public MythicLibSupportImpl() {
        super((LuminePlugin)MythicBukkit.inst());
    }

    public void load(MythicBukkit plugin) {
        Events.subscribe(MythicMechanicLoadEvent.class).handler(event -> {
            if (event.getMechanicName().equalsIgnoreCase("mmodamage") || event.getMechanicName().equalsIgnoreCase("mmod")) {
                event.register((ISkillMechanic)new MMODamageMechanic(event.getContainer().getManager(), event.getContainer().getFile(), event.getMechanicName(), event.getConfig()));
            }
            if (event.getMechanicName().equalsIgnoreCase("multiplydamage")) {
                event.register((ISkillMechanic)new MultiplyDamageMechanic(event.getConfig()));
            }
        });
        Events.subscribe(MythicConditionLoadEvent.class).handler(event -> {
            if (event.getConditionName().equalsIgnoreCase("canTarget")) {
                event.register((ISkillCondition)new CanTargetCondition(event.getConditionName(), event.getConfig()));
            }
        });
        Events.subscribe(MythicReloadedEvent.class).handler(event -> this.registerPlaceholders());
        this.registerPlaceholders();
    }

    public void unload() {
    }

    private void registerPlaceholders() {
        MythicBukkit.inst().getPlaceholderManager().register("modifier", (Placeholder)Placeholder.meta((metadata, arg) -> {
            if (!(metadata instanceof SkillMetadata)) {
                throw new RuntimeException("Cannot use this placeholder outside of skill");
            }
            Variable var = ((SkillMetadata)metadata).getVariables().get("MMOSkillMetadata");
            Validate.notNull(var, "Could not find MythicLib skill variable", new Object[0]);
            io.lumine.mythic.lib.skill.SkillMetadata mmoMetadata = (io.lumine.mythic.lib.skill.SkillMetadata)var.get();
            return String.valueOf(mmoMetadata.getParameter((String)arg));
        }));
        MythicBukkit.inst().getPlaceholderManager().register("modifier.int", (Placeholder)Placeholder.meta((metadata, arg) -> {
            if (!(metadata instanceof SkillMetadata)) {
                throw new RuntimeException("Cannot use this placeholder outside of skill");
            }
            Variable var = ((SkillMetadata)metadata).getVariables().get("MMOSkillMetadata");
            Validate.notNull(var, "Could not find MythicLib skill variable", new Object[0]);
            io.lumine.mythic.lib.skill.SkillMetadata mmoMetadata = (io.lumine.mythic.lib.skill.SkillMetadata)var.get();
            return String.valueOf((int)mmoMetadata.getParameter((String)arg));
        }));
        MythicBukkit.inst().getPlaceholderManager().register("mmodamage", (Placeholder)Placeholder.meta((metadata, arg) -> {
            if (!(metadata instanceof SkillMetadata)) {
                throw new RuntimeException("Cannot use this placeholder outside of skill");
            }
            SkillMetadata skillMeta = (SkillMetadata)metadata;
            Optional damagedOpt = skillMeta.getEntityTargets().stream().findFirst();
            Validate.isTrue(damagedOpt.isPresent(), "Could not find target entity", new Object[0]);
            Entity damaged = ((AbstractEntity)damagedOpt.get()).getBukkitEntity();
            AttackMetadata attackMeta = MythicLib.plugin.getDamage().findAttack(new EntityDamageEvent(damaged, EntityDamageEvent.DamageCause.CUSTOM, 0.0));
            Validate.notNull(attackMeta, "Entity not being attacked", new Object[0]);
            if (arg != null && !arg.isEmpty()) {
                DamageType type = DamageType.valueOf(UtilityMethods.enumName(arg));
                return String.valueOf(attackMeta.getDamage().getDamage(type));
            }
            return String.valueOf(attackMeta.getDamage().getDamage());
        }));
        MythicBukkit.inst().getPlaceholderManager().register("mmostat", (Placeholder)Placeholder.meta((metadata, arg) -> {
            if (metadata instanceof SkillMetadata && ((SkillMetadata)metadata).getVariables().has("MMOSkillMetadata")) {
                Variable var = ((SkillMetadata)metadata).getVariables().get("MMOSkillMetadata");
                io.lumine.mythic.lib.skill.SkillMetadata mmoMetadata = (io.lumine.mythic.lib.skill.SkillMetadata)var.get();
                PlayerMetadata caster = mmoMetadata.getCaster();
                String statName = arg.toUpperCase();
                return StatManager.format(statName, caster.getStat(statName));
            }
            SkillCaster caster = metadata.getCaster();
            if (!caster.getEntity().isPlayer()) {
                return "0";
            }
            MMOPlayerData playerData = MMOPlayerData.get(caster.getEntity().getUniqueId());
            return MythicLib.inst().getMMOConfig().decimals.format(playerData.getStatMap().getStat(arg.toUpperCase()));
        }));
        MythicBukkit.inst().getPlaceholderManager().register("target.stat", (Placeholder)Placeholder.entity((entity, arg) -> {
            if (!entity.isPlayer()) {
                return "0";
            }
            StatMap statMap = MMOPlayerData.get(entity.getUniqueId()).getStatMap();
            String statName = arg.toUpperCase();
            return StatManager.format(statName, statMap.getStat(statName));
        }));
        MythicBukkit.inst().getPlaceholderManager().register("cooldown", (Placeholder)Placeholder.meta((metadata, arg) -> {
            CooldownMap cooldownMap = MMOPlayerData.get(metadata.getCaster().getEntity().getUniqueId()).getCooldownMap();
            CooldownInfo info = cooldownMap.getInfo((String)arg);
            return String.valueOf(info == null ? 0.0 : (double)info.getRemaining() / 1000.0);
        }));
    }
}

