/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.util.ui;

import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickNumberRange
implements Cloneable {
    @Nullable
    Double minimumInclusive;
    @Nullable
    Double maximumInclusive;

    @Nullable
    public Double getMinimumInclusive() {
        return this.minimumInclusive;
    }

    @Nullable
    public Double getMaximumInclusive() {
        return this.maximumInclusive;
    }

    public boolean hasMin() {
        return this.minimumInclusive != null;
    }

    public boolean hasMax() {
        return this.maximumInclusive != null;
    }

    public boolean isSimple() {
        if (!this.hasMax() || !this.hasMin()) {
            return false;
        }
        return this.getMaximumInclusive().equals(this.getMinimumInclusive());
    }

    public double getAsDouble(double def) {
        if (this.hasMin()) {
            return this.getMinimumInclusive();
        }
        if (this.hasMax()) {
            return this.getMaximumInclusive();
        }
        return def;
    }

    @Contract(value="null -> null")
    @Nullable
    public static QuickNumberRange getFromString(@Nullable String qnr) {
        return QuickNumberRange.getFromString(qnr, null);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static QuickNumberRange getFromString(@Nullable String qnr, @Nullable FriendlyFeedbackProvider ffp) {
        String[] blit;
        if (qnr == null) {
            FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.ERROR, "No value provided to parse QuickNumberRange. ", new String[0]);
            return null;
        }
        if (qnr.equals("..")) {
            return new QuickNumberRange(null, null);
        }
        Double asItself = SilentNumbers.DoubleParse(qnr);
        if (asItself != null) {
            return new QuickNumberRange(asItself, asItself);
        }
        if (qnr.contains("..") && ((blit = qnr.split("\\.\\.")).length == 2 || blit.length == 1)) {
            boolean failure = false;
            String m = "";
            String M = "";
            if (blit.length == 2) {
                m = blit[0];
                M = blit[1];
            } else if (qnr.startsWith("..")) {
                M = blit[0];
            } else {
                m = blit[0];
            }
            Double min = SilentNumbers.DoubleParse(m);
            Double max = SilentNumbers.DoubleParse(M);
            if (m.length() > 0 && min == null) {
                failure = true;
                FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.ERROR, "Expected numeric value (negative and decimals supported) instead of $u{0}. ", m);
            }
            if (M.length() > 0 && max == null) {
                failure = true;
                FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.ERROR, "Expected numeric value (negative and decimals supported) instead of $u{0}. ", M);
            }
            if (!failure) {
                return new QuickNumberRange(min, max);
            }
        }
        FriendlyFeedbackProvider.log(ffp, FriendlyFeedbackCategory.ERROR, "Invalid syntax in '$u{0}$b': Expected a $enumber$b, or a range in the format $e[m]..[M]$b where m is the minimum number, and M is the maximum number (both optional). ", qnr);
        return null;
    }

    public QuickNumberRange(@Nullable Double min, @Nullable Double max) {
        this.minimumInclusive = min;
        this.maximumInclusive = max;
    }

    public boolean inRange(double test) {
        if (this.hasMin() && test < this.getMinimumInclusive()) {
            return false;
        }
        return !this.hasMax() || !(test > this.getMaximumInclusive());
    }

    public String toString() {
        if (this.isSimple()) {
            return String.valueOf(this.getMaximumInclusive());
        }
        String minn = "";
        String maxn = "";
        if (this.hasMin()) {
            minn = String.valueOf(this.getMinimumInclusive());
        }
        if (this.hasMax()) {
            maxn = String.valueOf(this.getMaximumInclusive());
        }
        return minn + ".." + maxn;
    }

    @NotNull
    public String toStringColored() {
        if (this.isSimple()) {
            return "$r" + this.getMaximumInclusive();
        }
        String minn = "-\u221e";
        String maxn = "\u221e";
        if (this.hasMin()) {
            minn = String.valueOf(this.getMinimumInclusive());
        }
        if (this.hasMax()) {
            maxn = String.valueOf(this.getMaximumInclusive());
        }
        return "$r" + minn + " $bto$r " + maxn;
    }

    public QuickNumberRange clone() {
        return new QuickNumberRange(this.getMinimumInclusive(), this.getMaximumInclusive());
    }
}

