/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.crafting.recipes;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.crafting.ingredients.MythicIngredient;
import io.lumine.mythic.lib.api.crafting.ingredients.MythicRecipeIngredient;
import io.lumine.mythic.lib.api.crafting.ingredients.MythicRecipeInventory;
import io.lumine.mythic.lib.api.crafting.ingredients.ShapedIngredient;
import io.lumine.mythic.lib.api.crafting.recipes.MythicRecipe;
import io.lumine.mythic.lib.api.crafting.recipes.MythicRecipeStation;
import io.lumine.mythic.lib.api.crafting.recipes.VanillaBookableRecipe;
import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import io.lumine.mythic.lib.api.util.Ref;
import io.lumine.mythic.lib.api.util.ui.FFPMythicLib;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShapedRecipe
extends MythicRecipe
implements VanillaBookableRecipe {
    int width = 0;
    int height = 0;

    public ShapedRecipe(@NotNull String name, @NotNull ArrayList<ShapedIngredient> ingredients) {
        super(name, new ArrayList<MythicRecipeIngredient>(ingredients));
        this.recalculateSize();
    }

    public static ShapedRecipe single(@NotNull String name, ProvidedUIFilter ... poofs) {
        ShapedIngredient result = new ShapedIngredient(new MythicIngredient(name, poofs), 0, 0);
        return new ShapedRecipe(name, result);
    }

    public static ShapedRecipe unsharpen(@NotNull ShapedRecipe sharpedRecipe) {
        int trueMinWidth = sharpedRecipe.getWidth();
        int trueMinHeight = sharpedRecipe.getHeight();
        int trueMaxWidth = 0;
        int trueMaxHeight = 0;
        for (MythicRecipeIngredient ingredient : sharpedRecipe.getIngredients()) {
            ProvidedUIFilter poof;
            if (ingredient == null || (poof = ingredient.getIngredient().getRandomSubstitute(false)) == null || poof.isAir()) continue;
            ShapedIngredient ing = (ShapedIngredient)ingredient;
            int cH = -ing.getVerticalOffset();
            int cW = ing.getHorizontalOffset();
            if (trueMinWidth > cW) {
                trueMinWidth = cW;
            }
            if (trueMinHeight > cH) {
                trueMinHeight = cH;
            }
            if (trueMaxWidth < cW) {
                trueMaxWidth = cW;
            }
            if (trueMaxHeight >= cH) continue;
            trueMaxHeight = cH;
        }
        ArrayList<ShapedIngredient> accepted = new ArrayList<ShapedIngredient>();
        for (int w = trueMinWidth; w <= trueMaxWidth; ++w) {
            for (int h = trueMinHeight; h <= trueMaxHeight; ++h) {
                ShapedIngredient found = sharpedRecipe.getIngredientAt(w, -h);
                if (found == null) continue;
                ShapedIngredient edited = found.clone();
                edited.setHorizontalOffset(edited.getHorizontalOffset() - trueMinWidth);
                edited.setVerticalOffset(edited.getVerticalOffset() + trueMinHeight);
                accepted.add(edited);
            }
        }
        return new ShapedRecipe(sharpedRecipe.getName(), accepted);
    }

    public ShapedRecipe(@NotNull String name, ShapedIngredient ... ingredients) {
        super(name, ingredients);
    }

    @Override
    @NotNull
    public MythicRecipeStation getType() {
        return MythicRecipeStation.WORKBENCH;
    }

    @Override
    public void clearIngredients() {
        super.clearIngredients();
        this.width = 0;
        this.height = 0;
    }

    @Override
    public void addIngredient(@NotNull MythicRecipeIngredient ingredient) {
        Validate.isTrue(ingredient instanceof ShapedIngredient, "Shaped Mythic Recipes can only work with Shaped Ingredients.", new Object[0]);
        ShapedIngredient replaced = this.getIngredientAt(((ShapedIngredient)ingredient).getHorizontalOffset(), ((ShapedIngredient)ingredient).getVerticalOffset());
        this.mythicIngredients.remove(replaced);
        this.mythicIngredients.add(ingredient);
        ((ShapedIngredient)ingredient).linkToRecipe(this);
        int cH = -((ShapedIngredient)ingredient).getVerticalOffset();
        int cW = ((ShapedIngredient)ingredient).getHorizontalOffset();
        if (this.getWidth() <= cW) {
            this.width = cW + 1;
        }
        if (this.getHeight() <= cH) {
            this.height = cH + 1;
        }
    }

    public void recalculateSize() {
        int highestHeight = 0;
        int widestWidth = 0;
        for (MythicRecipeIngredient g : this.getIngredients()) {
            int cH = -((ShapedIngredient)g).getVerticalOffset();
            int cW = ((ShapedIngredient)g).getHorizontalOffset();
            if (cW > widestWidth) {
                widestWidth = cW;
            }
            if (cH <= highestHeight) continue;
            highestHeight = cH;
        }
        this.width = widestWidth + 1;
        this.height = highestHeight + 1;
    }

    @Nullable
    public ShapedIngredient getIngredientAt(int w, int h) {
        for (MythicRecipeIngredient ingredient : this.getIngredients()) {
            ShapedIngredient shaped = (ShapedIngredient)ingredient;
            if (shaped.getHorizontalOffset() != w || shaped.getVerticalOffset() != h) continue;
            return shaped;
        }
        return null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @NotNull
    public ArrayList<ArrayList<ShapedIngredient>> permute(int width, int height) {
        Integer criticalWidth = null;
        Integer criticalHeight = null;
        ArrayList<ArrayList<ShapedIngredient>> ret = new ArrayList<ArrayList<ShapedIngredient>>();
        for (int w0 = 0; w0 <= width; ++w0) {
            if (criticalWidth != null && w0 >= criticalWidth) continue;
            for (int h0 = 0; h0 <= height; ++h0) {
                if (criticalHeight != null && h0 >= criticalHeight) continue;
                ArrayList<ShapedIngredient> iterationResult = new ArrayList<ShapedIngredient>();
                boolean cancelled = false;
                for (MythicRecipeIngredient ingredient : this.getIngredients()) {
                    ShapedIngredient adapted = ((ShapedIngredient)ingredient).adapt(width, height, w0, -h0);
                    if (adapted != null) {
                        iterationResult.add(adapted);
                        continue;
                    }
                    boolean ow = ((ShapedIngredient)ingredient).overflowsWidthFromOffset(width, w0);
                    boolean oh = ((ShapedIngredient)ingredient).overflowsHeightFromOffset(height, -h0);
                    if (ow) {
                        criticalWidth = w0;
                    }
                    if (oh) {
                        criticalHeight = h0;
                    }
                    cancelled = true;
                    break;
                }
                if (cancelled) continue;
                ret.add(iterationResult);
            }
        }
        return ret;
    }

    @Override
    @Nullable
    public MythicRecipeInventory matches(@NotNull MythicRecipeInventory inventory, @Nullable Ref<Integer> timesToCompletion) {
        ArrayList<CheckedSlot> slots = new ArrayList<CheckedSlot>();
        if (inventory.getWidth() < this.getWidth() || inventory.getHeight() < this.getHeight()) {
            return null;
        }
        block0: for (ArrayList<ShapedIngredient> combination : this.permute(inventory.getWidth(), inventory.getHeight())) {
            slots.clear();
            for (int c = 0; c < combination.size(); ++c) {
                ShapedIngredient ingredient = combination.get(c);
                ItemStack found = inventory.getItemAt(ingredient.getHorizontalOffset(), ingredient.getVerticalOffset());
                if (found == null) {
                    if (ingredient.getIngredient().acceptsAir()) {
                        found = new ItemStack(Material.AIR);
                    } else {
                        return null;
                    }
                }
                if (!ingredient.matches(found)) continue block0;
                if (c + 1 == combination.size()) {
                    slots.add(new CheckedSlot(ingredient.getHorizontalOffset(), ingredient.getVerticalOffset()));
                    for (CheckedSlot oSlot : CheckedSlot.getFrom(inventory)) {
                        ShapedIngredient item;
                        boolean contained = false;
                        for (CheckedSlot sl : slots) {
                            if (oSlot.getWidth() != sl.getWidth() || oSlot.getHeight() != sl.getHeight()) continue;
                            contained = true;
                            break;
                        }
                        if (contained || SilentNumbers.isAir((ItemStack)(item = inventory.getItemAt(oSlot.getWidth(), oSlot.getHeight())))) continue;
                        return null;
                    }
                    MythicRecipeInventory result = inventory.clone();
                    int lowestTimes = Short.MAX_VALUE;
                    for (ShapedIngredient item : combination) {
                        ItemStack foundResult = result.getItemAt(item.getHorizontalOffset(), item.getVerticalOffset());
                        if (foundResult == null) {
                            MythicLib.plugin.getLogger().log(Level.SEVERE, FriendlyFeedbackProvider.quickForConsole(FFPMythicLib.get(), "$fCustom recipe could not succeed: $bExpected item at offsets $r{0}h {1}w$b in order so subtract $u{2}$b. ", String.valueOf(item.getVerticalOffset()), String.valueOf(item.getHorizontalOffset()), String.valueOf(item.getAmountOfSuccess())));
                            return null;
                        }
                        int amount = foundResult.getAmount();
                        int newAmount = amount - item.getAmountOfSuccess();
                        int times = SilentNumbers.floor((double)amount / (double)item.getAmountOfSuccess());
                        foundResult.setAmount(newAmount);
                        if (lowestTimes <= times) continue;
                        lowestTimes = times;
                    }
                    Ref.setValue(timesToCompletion, lowestTimes);
                    return result;
                }
                slots.add(new CheckedSlot(ingredient.getHorizontalOffset(), ingredient.getVerticalOffset()));
            }
        }
        return null;
    }

    @Override
    @NotNull
    public Recipe getBukkitRecipe(@NotNull NamespacedKey recipeName, @NotNull ItemStack recipeResult) throws IllegalArgumentException {
        org.bukkit.inventory.ShapedRecipe ret = new org.bukkit.inventory.ShapedRecipe(recipeName, recipeResult);
        HashMap recipeContents = new HashMap();
        HashMap<Integer, String> rowStrings = new HashMap<Integer, String>();
        int greatestH = 0;
        int greatestW = 0;
        for (int h = 0; h < this.getHeight() && h < 3; ++h) {
            Object chars;
            switch (h) {
                case 0: {
                    chars = new char[]{'A', 'B', 'C'};
                    break;
                }
                case 1: {
                    chars = new char[]{'D', 'E', 'F'};
                    break;
                }
                default: {
                    chars = new char[]{'G', 'H', 'I'};
                }
            }
            HashMap<Integer, ShapedIngredient> rowContents = new HashMap<Integer, ShapedIngredient>();
            StringBuilder rowString = new StringBuilder();
            for (int w = 0; w < this.getWidth() && w < 3; ++w) {
                ShapedIngredient get = this.getIngredientAt(w, -h);
                rowContents.put(w, get);
                greatestW = w;
                if (!(get == null || get.getIngredient().getSubstitutes().size() == 1 && get.getIngredient().getSubstitutes().get(0).isAir())) {
                    rowString.append((char)chars[w]);
                    continue;
                }
                rowString.append(" ");
            }
            String row = rowString.toString();
            boolean notBlanc = false;
            for (char c : row.toCharArray()) {
                if (c == ' ') continue;
                notBlanc = true;
                break;
            }
            if (!notBlanc) continue;
            rowStrings.put(h, rowString.toString());
            recipeContents.put(h, rowContents);
            greatestH = h;
        }
        String[] rowsBaked = new String[greatestH + 1];
        for (Integer r : rowStrings.keySet()) {
            rowsBaked[r.intValue()] = (String)rowStrings.get(r);
        }
        for (int s = 0; s < rowsBaked.length; ++s) {
            if (rowsBaked[s] != null) continue;
            switch (greatestW) {
                default: {
                    rowsBaked[s] = " ";
                }
                case 1: {
                    rowsBaked[s] = "  ";
                }
                case 2: 
            }
            rowsBaked[s] = "   ";
        }
        ret.shape(rowsBaked);
        for (int h = 0; h < this.getHeight() && h < 3; ++h) {
            char[] chars;
            switch (h) {
                case 0: {
                    chars = new char[]{'A', 'B', 'C'};
                    break;
                }
                case 1: {
                    chars = new char[]{'D', 'E', 'F'};
                    break;
                }
                default: {
                    chars = new char[]{'G', 'H', 'I'};
                }
            }
            HashMap rowContent = (HashMap)recipeContents.get(h);
            if (rowContent == null) continue;
            for (int w = 0; w < this.getWidth() && w < 3; ++w) {
                ShapedIngredient ingredient = (ShapedIngredient)rowContent.get(w);
                if (ingredient == null) continue;
                try {
                    ret.setIngredient(chars[w], ingredient.toBukkit());
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    static class CheckedSlot {
        final int width;
        final int height;

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        CheckedSlot(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public static ArrayList<CheckedSlot> getFrom(@NotNull MythicRecipeInventory inventory) {
            ArrayList<CheckedSlot> ret = new ArrayList<CheckedSlot>();
            for (int w = 0; w < inventory.getWidth(); ++w) {
                for (int h = 0; h < inventory.getHeight(); ++h) {
                    ret.add(new CheckedSlot(w, -h));
                }
            }
            return ret;
        }
    }
}

