/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.crafting.outputs;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.crafting.event.MythicCraftItemEvent;
import io.lumine.mythic.lib.api.crafting.ingredients.MythicBlueprintInventory;
import io.lumine.mythic.lib.api.crafting.ingredients.MythicIngredient;
import io.lumine.mythic.lib.api.crafting.ingredients.MythicRecipeIngredient;
import io.lumine.mythic.lib.api.crafting.ingredients.MythicRecipeInventory;
import io.lumine.mythic.lib.api.crafting.ingredients.ShapedIngredient;
import io.lumine.mythic.lib.api.crafting.outputs.MythicRecipeOutput;
import io.lumine.mythic.lib.api.crafting.recipes.MythicCachedResult;
import io.lumine.mythic.lib.api.crafting.recipes.MythicRecipe;
import io.lumine.mythic.lib.api.crafting.recipes.ShapedRecipe;
import io.lumine.mythic.lib.api.crafting.recipes.VanillaBookableOutput;
import io.lumine.mythic.lib.api.crafting.recipes.vmp.VanillaInventoryMapping;
import io.lumine.mythic.lib.api.crafting.uifilters.IngredientUIFilter;
import io.lumine.mythic.lib.api.crafting.uifilters.UIFilter;
import io.lumine.mythic.lib.api.crafting.uimanager.ProvidedUIFilter;
import io.lumine.mythic.lib.api.util.ItemFactory;
import io.lumine.mythic.lib.api.util.ui.FFPMythicLib;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackCategory;
import io.lumine.mythic.lib.api.util.ui.FriendlyFeedbackProvider;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import io.lumine.mythic.lib.util.lang3.Validate;
import io.lumine.mythic.lib.version.VersionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MRORecipe
extends MythicRecipeOutput
implements VanillaBookableOutput {
    @NotNull
    final ShapedRecipe output;
    @NotNull
    final String recipeFFPPrefix;
    @Nullable
    MythicRecipe mainInputConsumption;
    @NotNull
    final HashMap<String, MythicRecipe> sideInputConsumptions = new HashMap();
    boolean random = false;
    @Nullable
    MythicRecipeInventory determinateDisplay = null;
    @Nullable
    MythicRecipeInventory determinateResult = null;

    @NotNull
    public ShapedRecipe getOutput() {
        return this.output;
    }

    public MRORecipe(@NotNull ShapedRecipe output) {
        this.output = output;
        this.recipeFFPPrefix = "Mythic Recipe $u" + this.getOutput().getName();
        this.analyzeDetermination();
    }

    public MRORecipe(@NotNull ShapedRecipe output, @Nullable ShapedRecipe mainInput) {
        this(output);
        this.mainInputConsumption = mainInput;
    }

    @Nullable
    public MythicRecipe getMainInputConsumption() {
        return this.mainInputConsumption;
    }

    public void setMainInputConsumption(@Nullable MythicRecipe mic) {
        this.mainInputConsumption = this.ifEmptyNull(mic);
        this.analyzeDetermination();
    }

    public boolean hasInputConsumption() {
        return this.sideInputConsumptions.size() > 0 || this.mainInputConsumption != null;
    }

    @NotNull
    public ArrayList<String> getSideConsumptionNames() {
        return new ArrayList<String>(this.sideInputConsumptions.keySet());
    }

    @NotNull
    public MythicRecipe getSideConsumption(@NotNull String ofName) {
        Validate.isTrue(this.hasSideConsumption(ofName), "You may not query for a side recipe that does not exist.", new Object[0]);
        return this.sideInputConsumptions.get(ofName);
    }

    public boolean hasSideConsumption(@NotNull String ofName) {
        return this.sideInputConsumptions.containsKey(ofName);
    }

    public void setSideConsumption(@NotNull String ofName, @Nullable MythicRecipe recipe) {
        if (this.ifEmptyNull(recipe) == null) {
            this.sideInputConsumptions.remove(ofName);
            return;
        }
        this.sideInputConsumptions.put(ofName, recipe);
        this.analyzeDetermination();
    }

    @NotNull
    MythicRecipeInventory generateResultOf(@NotNull MythicRecipe mythicRecipe) {
        HashMap<Integer, ItemStack[]> rowsInformation = new HashMap<Integer, ItemStack[]>();
        for (MythicRecipeIngredient mmIngredient : mythicRecipe.getIngredients()) {
            if (mmIngredient == null) continue;
            ShapedIngredient shaped = (ShapedIngredient)mmIngredient;
            MythicIngredient ingredient = mmIngredient.getIngredient();
            if (!ingredient.isDefinesItem()) continue;
            FriendlyFeedbackProvider ffp = new FriendlyFeedbackProvider(FFPMythicLib.get());
            ffp.activatePrefix(true, this.recipeFFPPrefix);
            ItemStack gen = mmIngredient.getIngredient().getRandomSubstituteItem(ffp);
            if (gen != null) {
                ItemStack[] row = (ItemStack[])rowsInformation.get(-shaped.getVerticalOffset());
                if (row == null) {
                    row = new ItemStack[shaped.getHorizontalOffset() + 1];
                }
                if (row.length < shaped.getHorizontalOffset() + 1) {
                    ItemStack[] newRow = new ItemStack[shaped.getHorizontalOffset() + 1];
                    for (int r = 0; r < row.length; ++r) {
                        newRow[r] = row[r];
                    }
                    row = newRow;
                }
                row[shaped.getHorizontalOffset()] = gen;
                rowsInformation.put(-shaped.getVerticalOffset(), row);
                continue;
            }
            ffp.sendTo(FriendlyFeedbackCategory.ERROR, MythicLib.plugin.getServer().getConsoleSender());
        }
        MythicRecipeInventory ret = new MythicRecipeInventory();
        for (Integer h : rowsInformation.keySet()) {
            ret.setRow(h, (ItemStack[])rowsInformation.get(h));
        }
        return ret;
    }

    @Nullable
    public MythicRecipe ifEmptyNull(@Nullable MythicRecipe mic) {
        if (mic == null) {
            return null;
        }
        for (MythicRecipeIngredient mri : mic.getIngredients()) {
            if (mri == null || !mri.getIngredient().isDefinesItem()) continue;
            return mic;
        }
        return null;
    }

    public boolean isRandom() {
        return this.random;
    }

    public void analyzeDetermination() {
        ArrayList<MythicRecipeIngredient> ultimateOutput = new ArrayList<MythicRecipeIngredient>(this.getOutput().getIngredients());
        if (this.hasInputConsumption()) {
            if (this.getMainInputConsumption() != null) {
                ultimateOutput.addAll(this.getMainInputConsumption().getIngredients());
            }
            for (String sideName : this.getSideConsumptionNames()) {
                MythicRecipe sideConsumption = this.getSideConsumption(sideName);
                ultimateOutput.addAll(sideConsumption.getIngredients());
            }
        }
        for (MythicRecipeIngredient mIngredient : ultimateOutput) {
            UIFilter filter;
            MythicIngredient ingredient;
            ShapedIngredient shaped = (ShapedIngredient)mIngredient;
            if (shaped == null || !(ingredient = shaped.getIngredient()).isDefinesItem()) continue;
            if (ingredient.getSubstitutes().size() > 1) {
                this.random = true;
                this.determinateDisplay = null;
                return;
            }
            ProvidedUIFilter poof = ingredient.getRandomSubstitute(false);
            if (poof == null || (filter = poof.getParent()).determinateGeneration() || filter.partialDeterminateGeneration(poof.getArgument(), poof.getData())) continue;
            this.random = true;
            this.determinateDisplay = null;
            return;
        }
        this.random = false;
    }

    @Nullable
    MythicRecipeInventory getDeterminateDisplay() {
        if (this.isRandom()) {
            this.determinateDisplay = null;
            return null;
        }
        if (this.determinateDisplay != null) {
            return this.determinateDisplay.clone();
        }
        this.determinateDisplay = this.generateDisplay();
        return this.determinateDisplay.clone();
    }

    @NotNull
    MythicRecipeInventory generateDisplay() {
        HashMap<Integer, ItemStack[]> rowsInformation = new HashMap<Integer, ItemStack[]>();
        for (MythicRecipeIngredient mmIngredient : this.getOutput().getIngredients()) {
            ItemStack[] row;
            if (mmIngredient == null) continue;
            ShapedIngredient shaped = (ShapedIngredient)mmIngredient;
            MythicIngredient ingredient = mmIngredient.getIngredient();
            if (!ingredient.isDefinesItem()) continue;
            FriendlyFeedbackProvider ffp = new FriendlyFeedbackProvider(FFPMythicLib.get());
            ffp.activatePrefix(true, this.recipeFFPPrefix);
            ItemStack gen = mmIngredient.getIngredient().getRandomDisplayItem(ffp);
            if (ingredient.getSubstitutes().size() > 1) {
                ItemStack result = SilentNumbers.setItemName(new ItemStack(gen.getType()), SilentNumbers.findItemName(gen));
                ArrayList<String> desc = new ArrayList<String>();
                for (String str : new IngredientUIFilter().getDescription(ingredient.getName(), "")) {
                    desc.add(MythicLib.plugin.parseColors(FriendlyFeedbackProvider.quickForPlayer(FFPMythicLib.get(), str, new String[0])));
                }
                gen = ItemFactory.of(result).lore(desc).build();
            }
            if ((row = (ItemStack[])rowsInformation.get(-shaped.getVerticalOffset())) == null) {
                row = new ItemStack[shaped.getHorizontalOffset() + 1];
            }
            if (row.length < shaped.getHorizontalOffset() + 1) {
                ItemStack[] newRow = new ItemStack[shaped.getHorizontalOffset() + 1];
                for (int r = 0; r < row.length; ++r) {
                    newRow[r] = row[r];
                }
                row = newRow;
            }
            row[shaped.getHorizontalOffset()] = gen;
            rowsInformation.put(-shaped.getVerticalOffset(), row);
        }
        MythicRecipeInventory ret = new MythicRecipeInventory();
        for (Integer h : rowsInformation.keySet()) {
            ret.setRow(h, (ItemStack[])rowsInformation.get(h));
        }
        return ret;
    }

    @Nullable
    MythicRecipeInventory getDeterminateResult() {
        if (this.isRandom()) {
            this.determinateResult = null;
            return null;
        }
        if (this.determinateResult != null) {
            return this.determinateResult.clone();
        }
        this.determinateResult = this.generateResult();
        return this.determinateResult.clone();
    }

    @NotNull
    MythicRecipeInventory generateResult() {
        return this.generateResultOf(this.getOutput());
    }

    @Override
    @NotNull
    public MythicRecipeInventory applyDisplay(@NotNull MythicBlueprintInventory inventory, @NotNull InventoryClickEvent eventTrigger, @NotNull VanillaInventoryMapping mapping) {
        MythicRecipeInventory result = this.getDeterminateDisplay();
        if (result == null) {
            result = this.generateDisplay();
        }
        MythicRecipeInventory ret = inventory.getResultInventory().clone();
        for (int h = 0; h < inventory.getResultInventory().getHeight(); ++h) {
            for (int w = 0; w < inventory.getResultInventory().getWidth(); ++w) {
                ItemStack item = result.getItemAt(w, -h);
                ret.setItemAt(w, -h, item);
            }
        }
        return ret;
    }

    @Override
    public void applyResult(@NotNull MythicRecipeInventory resultInventory, @NotNull MythicBlueprintInventory otherInventories, @NotNull MythicCachedResult cache, @NotNull InventoryClickEvent eventTrigger, @NotNull VanillaInventoryMapping map, int times) {
        eventTrigger.setCancelled(true);
        if (!(eventTrigger.getWhoClicked() instanceof Player)) {
            return;
        }
        MythicCraftItemEvent preEvent = new MythicCraftItemEvent(eventTrigger, resultInventory, map, otherInventories, cache);
        Bukkit.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return;
        }
        if (times == 1 && eventTrigger.getAction() != InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            ItemStack currentInCursor = eventTrigger.getCursor();
            MythicRecipeInventory result = this.getDeterminateResult();
            if (result == null) {
                result = this.generateResult();
            }
            this.processInventory(resultInventory, result, times);
            ItemStack cursor = resultInventory.getItemAt(map.getResultWidth(eventTrigger.getSlot()), map.getResultHeight(eventTrigger.getSlot()));
            if (cursor == null) {
                cursor = new ItemStack(Material.AIR);
            }
            ItemStack actualCursor = cursor.clone();
            if (!SilentNumbers.isAir(currentInCursor)) {
                if (currentInCursor.isSimilar(actualCursor)) {
                    int maxAmount;
                    int aAmount;
                    int cAmount = currentInCursor.getAmount();
                    if (cAmount + (aAmount = actualCursor.getAmount()) > (maxAmount = actualCursor.getMaxStackSize())) {
                        return;
                    }
                    actualCursor.setAmount(cAmount + aAmount);
                } else {
                    return;
                }
            }
            cursor.setAmount(0);
            map.applyToResultInventory(eventTrigger.getInventory(), resultInventory, false);
            VersionUtils.getView((InventoryEvent)eventTrigger).setCursor(actualCursor);
            this.consumeIngredients(otherInventories, cache, eventTrigger.getInventory(), map, times);
            if (this.hasInputConsumption()) {
                ArrayList<ItemStack> inputConsumptionOverflow = new ArrayList<ItemStack>();
                if (this.getMainInputConsumption() != null) {
                    MythicRecipeInventory mainRead = map.getMainMythicInventory(eventTrigger.getInventory());
                    MythicRecipeInventory addedStuff = this.generateResultOf(this.getMainInputConsumption());
                    inputConsumptionOverflow.addAll(MRORecipe.stackWhatsPossible(mainRead, addedStuff));
                    map.applyToMainInventory(eventTrigger.getInventory(), mainRead, false);
                }
                for (String sideName : this.getSideConsumptionNames()) {
                    if (!map.getSideInventoryNames().contains(sideName)) continue;
                    MythicRecipeInventory sideRead = map.getSideMythicInventory(sideName, eventTrigger.getInventory());
                    MythicRecipeInventory addedStuff = this.generateResultOf(this.getSideConsumption(sideName));
                    inputConsumptionOverflow.addAll(MRORecipe.stackWhatsPossible(sideRead, addedStuff));
                    map.applyToSideInventory(eventTrigger.getInventory(), sideRead, sideName, false);
                }
                MRORecipe.distributeInInventoryOrDrop((Inventory)eventTrigger.getWhoClicked().getInventory(), inputConsumptionOverflow, eventTrigger.getWhoClicked().getLocation());
            }
        } else {
            HashMap<Integer, ItemStack> modifiedInventory = null;
            PlayerInventory inven = eventTrigger.getWhoClicked().getInventory();
            int trueTimes = 0;
            int t = 1;
            while (t <= times) {
                HashMap<Integer, ItemStack> localIterationResult;
                MythicRecipeInventory localResult = this.getDeterminateResult();
                if (localResult == null) {
                    localResult = this.generateResult();
                }
                ArrayList<ItemStack> localOutput = MRORecipe.toItemsList(localResult);
                if (this.hasInputConsumption()) {
                    if (this.getMainInputConsumption() != null) {
                        MythicRecipeInventory addedStuff = this.generateResultOf(this.getMainInputConsumption());
                        localOutput.addAll(MRORecipe.toItemsList(addedStuff));
                    }
                    for (String sideName : this.getSideConsumptionNames()) {
                        if (!map.getSideInventoryNames().contains(sideName)) continue;
                        MythicRecipeInventory addedStuff = this.generateResultOf(this.getSideConsumption(sideName));
                        localOutput.addAll(MRORecipe.toItemsList(addedStuff));
                    }
                }
                if ((localIterationResult = MRORecipe.distributeInInventory((Inventory)inven, localOutput, modifiedInventory)) == null) break;
                modifiedInventory = localIterationResult;
                trueTimes = t++;
            }
            if (trueTimes == 0) {
                return;
            }
            times = trueTimes;
            for (Integer s : modifiedInventory.keySet()) {
                ItemStack putt = (ItemStack)modifiedInventory.get(s);
                inven.setItem(s.intValue(), putt);
            }
            this.consumeIngredients(otherInventories, cache, eventTrigger.getInventory(), map, times);
        }
    }

    public static ArrayList<ItemStack> toItemsList(@NotNull MythicRecipeInventory inventory) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int h = 0; h < inventory.getHeight(); ++h) {
            for (int w = 0; w < inventory.getWidth(); ++w) {
                ItemStack observed = inventory.getItemAt(w, -h);
                if (observed == null || SilentNumbers.isAir(observed)) continue;
                ret.add(observed);
            }
        }
        return ret;
    }

    @Nullable
    public static HashMap<Integer, ItemStack> distributeInInventory(@NotNull Inventory inven, @NotNull ArrayList<ItemStack> contents, @Nullable HashMap<Integer, ItemStack> olderResult) {
        ArrayList<ItemStack> out = MRORecipe.notRepeated(contents);
        HashMap<Integer, ItemStack> result = new HashMap<Integer, ItemStack>();
        HashMap<Integer, ItemStack> invenItems = new HashMap<Integer, ItemStack>();
        if (olderResult == null) {
            olderResult = new HashMap();
        }
        for (int s = 0; s < 36; ++s) {
            ItemStack i = (ItemStack)olderResult.get(s);
            if (!SilentNumbers.isAir(i)) {
                result.put(s, i);
                invenItems.put(s, i);
                continue;
            }
            invenItems.put(s, inven.getItem(s));
        }
        int completelyResolved = 0;
        block1: for (int s = 0; s < 36 && completelyResolved < out.size(); ++s) {
            ItemStack i = (ItemStack)invenItems.get(s);
            if (SilentNumbers.isAir(i)) continue;
            for (ItemStack itm : out) {
                if (!itm.isSimilar(i) || itm.getType().getMaxStackSize() <= i.getAmount()) continue;
                int iCurrent = i.getAmount();
                int iAdding = itm.getAmount();
                int iMaxAdd = itm.getType().getMaxStackSize() - iCurrent;
                int iAdded = Math.min(iMaxAdd, iAdding);
                int iRem = iAdding - iAdded;
                ItemStack put = MRORecipe.asAmount(i, iCurrent + iAdded);
                itm.setAmount(iRem);
                result.put(s, put);
                if (iRem != 0) continue block1;
                ++completelyResolved;
                continue block1;
            }
        }
        out = MRORecipe.notRepeated(out);
        int o = out.size() - 1;
        for (int s = 0; s < 36 && o >= 0; ++s) {
            if (completelyResolved == out.size()) {
                o = -1;
                break;
            }
            ItemStack i = (ItemStack)invenItems.get(s);
            if (!SilentNumbers.isAir(i)) continue;
            ItemStack oStack = out.get(o);
            if (oStack.getAmount() > 0) {
                result.put(s, oStack.clone());
                ++completelyResolved;
            }
            --o;
        }
        if (o >= 0) {
            return null;
        }
        return result;
    }

    public static void distributeInInventoryOrDrop(@NotNull Inventory inven, @NotNull ArrayList<ItemStack> contents, @NotNull Location dropLocation) {
        if (inven.getSize() < 35) {
            throw new IndexOutOfBoundsException("Passing non-player inventory to this method; Expected a player's inventory");
        }
        HashMap<Integer, ItemStack> localIterationResult = MRORecipe.distributeInInventory(inven, contents, null);
        if (localIterationResult != null) {
            for (Integer s : localIterationResult.keySet()) {
                ItemStack putt = localIterationResult.get(s);
                if (SilentNumbers.isAir(putt)) continue;
                inven.setItem(s.intValue(), putt);
            }
        } else {
            for (ItemStack item : contents) {
                if (item == null || !item.getType().isItem()) continue;
                dropLocation.getWorld().dropItem(dropLocation, item);
            }
        }
    }

    @NotNull
    public static ArrayList<ItemStack> notRepeated(@NotNull ArrayList<ItemStack> contents) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (ItemStack itm : contents) {
            if (SilentNumbers.isAir(itm)) continue;
            boolean stacked = false;
            for (int c = 0; c < ret.size(); ++c) {
                int total;
                ItemStack comp = ret.get(c);
                Material mat = comp.getType();
                if (!comp.isSimilar(itm) || comp.getAmount() >= mat.getMaxStackSize()) continue;
                ret.remove(c);
                int current = comp.getAmount();
                int added = itm.getAmount();
                for (total = current + added; total > mat.getMaxStackSize(); total -= mat.getMaxStackSize()) {
                    ret.add(MRORecipe.asAmount(comp, mat.getMaxStackSize()));
                }
                if (total > 0) {
                    ret.add(MRORecipe.asAmount(comp, total));
                }
                stacked = true;
                break;
            }
            if (stacked) continue;
            ret.add(itm);
        }
        return ret;
    }

    @NotNull
    public static ItemStack asAmount(@NotNull ItemStack comp, int amount) {
        ItemStack s = comp.clone();
        s.setAmount(amount);
        return s;
    }

    @Override
    @NotNull
    public ItemStack getBukkitRecipeResult() throws IllegalArgumentException {
        ItemStack first;
        MythicRecipeInventory localResult = this.getDeterminateDisplay();
        if (localResult == null) {
            localResult = this.generateDisplay();
        }
        Validate.isTrue((first = localResult.getFirst()) != null, "MRORecipe output cannot just not generate any Item Stacks", new Object[0]);
        return first;
    }

    @NotNull
    public static ArrayList<ItemStack> stackWhatsPossible(@NotNull MythicRecipeInventory receivingInventory, @NotNull MythicRecipeInventory addedStuff) {
        ArrayList<ItemStack> inputConsumptionOverflow = new ArrayList<ItemStack>();
        for (int h = 0; h < addedStuff.getHeight(); ++h) {
            for (int w = 0; w < addedStuff.getWidth(); ++w) {
                ItemStack resultItem = addedStuff.getItemAt(w, -h);
                if (SilentNumbers.isAir(resultItem)) continue;
                ItemStack currentItem = receivingInventory.getItemAt(w, -h);
                if (!SilentNumbers.isAir(currentItem)) {
                    if (currentItem.isSimilar(resultItem)) {
                        int maxAmount;
                        int aAmount;
                        int cAmount = currentItem.getAmount();
                        if (cAmount + (aAmount = resultItem.getAmount()) > (maxAmount = resultItem.getMaxStackSize())) {
                            currentItem.setAmount(maxAmount);
                            receivingInventory.setItemAt(w, -h, currentItem);
                            int addedAmount = maxAmount - cAmount;
                            int remainder = aAmount - addedAmount;
                            if (remainder <= 0) continue;
                            resultItem.setAmount(remainder);
                            inputConsumptionOverflow.add(resultItem);
                            continue;
                        }
                        resultItem.setAmount(cAmount + aAmount);
                        receivingInventory.setItemAt(w, -h, resultItem);
                        continue;
                    }
                    inputConsumptionOverflow.add(resultItem);
                    continue;
                }
                receivingInventory.setItemAt(w, -h, resultItem);
            }
        }
        return inputConsumptionOverflow;
    }
}

