/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.api.crafting.ingredients;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.crafting.recipes.MythicCraftingManager;
import io.lumine.mythic.lib.api.util.ui.SilentNumbers;
import io.lumine.mythic.lib.util.lang3.Validate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MythicRecipeInventory
implements Cloneable {
    @NotNull
    private final HashMap<Integer, ArrayList<ItemStack>> contents = new HashMap();

    public int getHeight() {
        return this.contents.size();
    }

    public int getWidth() {
        if (this.getHeight() == 0) {
            return 0;
        }
        return this.contents.get(0).size();
    }

    @Nullable
    public ItemStack getItemAt(int width, int height) {
        if ((height *= -1) < 0 || width < 0 || height >= this.getHeight() || width >= this.getWidth()) {
            if (height < 0) {
                MythicLib.plugin.getLogger().log(Level.WARNING, "Positive height provided, which is WRONG: " + height);
            }
            return null;
        }
        ArrayList<ItemStack> targetRow = this.contents.get(height);
        return targetRow.get(width);
    }

    public boolean setItemAt(int width, int height, @Nullable ItemStack item) {
        if ((height *= -1) < 0 || width < 0 || height >= this.getHeight() || width >= this.getWidth()) {
            return false;
        }
        ArrayList<ItemStack> targetRow = this.contents.get(height);
        targetRow.remove(width);
        targetRow.add(width, item);
        return true;
    }

    public void addRow(ItemStack ... contents) {
        this.setRow(this.getHeight(), contents);
    }

    public void setRow(int row, ItemStack ... contents) {
        Validate.isTrue(row >= 0, "Mythic Recipe Inventories cannot have a negative number of rows.", new Object[0]);
        this.createRowsUntil(row);
        ArrayList<ItemStack> fill = contents == null ? this.fill(new ArrayList<ItemStack>()) : this.fill(SilentNumbers.toArrayList(contents));
        this.contents.put(row, fill);
    }

    void createRowsUntil(int row) {
        Validate.isTrue(row >= 0, "Mythic Recipe Inventories cannot have a negative number of rows.", new Object[0]);
        Integer i = 0;
        while (i <= row) {
            if (this.contents.get(i) == null) {
                this.contents.put(i, this.fill(new ArrayList<ItemStack>()));
            }
            Integer n = i;
            i = i + 1;
        }
    }

    ArrayList<ItemStack> fill(@NotNull ArrayList<ItemStack> list) {
        if (list.size() >= this.getWidth()) {
            this.updateRowSizesTo(list.size());
            return new ArrayList<ItemStack>(list);
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int j = 0; j < this.getWidth(); ++j) {
            if (list.size() > j) {
                ret.add(list.get(j));
                continue;
            }
            ret.add(null);
        }
        return ret;
    }

    void updateRowSizesTo(int size) {
        if (this.getHeight() == 0) {
            return;
        }
        if (size == this.getWidth()) {
            return;
        }
        ArrayList<ItemStack> first = this.contents.get(0);
        for (int j = 0; j < size; ++j) {
            if (first.size() != j) continue;
            first.add(null);
        }
        this.contents.put(0, first);
        for (int l = 1; l < this.getHeight(); ++l) {
            ArrayList<ItemStack> lst = this.contents.get(l);
            this.contents.put(l, this.fill(lst));
        }
    }

    public void clearContents() {
        this.contents.clear();
    }

    public void clean() {
        for (int w = 0; w < this.getWidth(); ++w) {
            for (int h = 0; h < this.getHeight(); ++h) {
                if (this.getItemAt(w, -h) == null) continue;
                this.setItemAt(w, -h, MythicCraftingManager.AIR);
            }
        }
    }

    public MythicRecipeInventory clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        MythicRecipeInventory ret = new MythicRecipeInventory();
        for (Map.Entry<Integer, ArrayList<ItemStack>> row : this.contents.entrySet()) {
            ItemStack[] newRow = new ItemStack[this.getWidth()];
            for (int w = 0; w < this.getWidth(); ++w) {
                ItemStack stacc = row.getValue().get(w);
                newRow[w] = stacc != null ? stacc.clone() : null;
            }
            ret.setRow(row.getKey(), newRow);
        }
        return ret;
    }

    @Nullable
    public ItemStack getFirst() {
        for (ArrayList<ItemStack> cont : this.contents.values()) {
            for (ItemStack itm : cont) {
                if (SilentNumbers.isAir(itm)) continue;
                return itm;
            }
        }
        return null;
    }

    @NotNull
    public ArrayList<String> toStrings(@NotNull String prefix) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int r = 0; r < this.contents.size(); ++r) {
            ArrayList<ItemStack> fill = this.contents.get(r);
            if (fill == null) continue;
            ret.add(prefix + SilentNumbers.collapseList(SilentNumbers.transcribeList(fill, o -> SilentNumbers.getItemName((ItemStack)o)), "\u00a77,\u00a7f "));
        }
        return ret;
    }
}

