/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.sound;

import java.util.Collection;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Namespaced;
import net.kyori.examination.Examinable;
import org.intellij.lang.annotations.Pattern;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.overlay.ResourceContainer;
import team.unnamed.creative.part.ResourcePackPart;
import team.unnamed.creative.sound.SoundEvent;
import team.unnamed.creative.sound.SoundRegistryImpl;

public interface SoundRegistry
extends ResourcePackPart,
Namespaced,
Examinable {
    @NotNull
    public static SoundRegistry soundRegistry(@NotNull String namespace, @NotNull Set<SoundEvent> sounds) {
        return new SoundRegistryImpl(namespace, sounds);
    }

    @NotNull
    public static SoundRegistry soundRegistry(@NotNull String namespace, @NotNull Collection<SoundEvent> sounds) {
        return new SoundRegistryImpl(namespace, sounds);
    }

    @NotNull
    public static Builder soundRegistry() {
        return new SoundRegistryImpl.BuilderImpl();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static SoundRegistry of(@NotNull String namespace, @NotNull Set<SoundEvent> sounds) {
        return SoundRegistry.soundRegistry(namespace, sounds);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static Builder builder() {
        return SoundRegistry.soundRegistry();
    }

    @Pattern(value="[a-z0-9_\\-.]+")
    @Subst(value="minecraft")
    @NotNull
    public String namespace();

    public @Unmodifiable @NotNull Collection<SoundEvent> sounds();

    @Nullable
    public SoundEvent sound(@NotNull Key var1);

    @Override
    default public void addTo(@NotNull ResourceContainer resourceContainer) {
        resourceContainer.soundRegistry(this);
    }

    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder namespace(@NotNull String var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder sound(@NotNull SoundEvent var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder sounds(@NotNull Collection<? extends SoundEvent> var1);

        @Contract(value="-> new")
        @NotNull
        public SoundRegistry build();
    }
}

