/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.sound;

import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import team.unnamed.creative.sound.SoundEntry;

final class SoundEntryImpl
implements SoundEntry {
    private final Key key;
    private final float volume;
    private final float pitch;
    private final int weight;
    private final boolean stream;
    private final int attenuationDistance;
    private final boolean preload;
    private final SoundEntry.Type type;

    SoundEntryImpl(@NotNull Key key, float volume, float pitch, int weight, boolean stream, int attenuationDistance, boolean preload, @NotNull SoundEntry.Type type) {
        this.key = Objects.requireNonNull(key, "key");
        this.volume = volume;
        this.pitch = pitch;
        this.weight = weight;
        this.stream = stream;
        this.attenuationDistance = attenuationDistance;
        this.preload = preload;
        this.type = Objects.requireNonNull(type, "type");
        this.validate();
    }

    private void validate() {
        if (this.volume <= 0.0f) {
            throw new IllegalArgumentException("Zero or negative volume");
        }
        if (this.pitch <= 0.0f) {
            throw new IllegalArgumentException("Zero or negative pitch");
        }
        if (this.weight <= 0) {
            throw new IllegalArgumentException("Zero or negative weight");
        }
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    public float volume() {
        return this.volume;
    }

    @Override
    public float pitch() {
        return this.pitch;
    }

    @Override
    public int weight() {
        return this.weight;
    }

    @Override
    public boolean stream() {
        return this.stream;
    }

    @Override
    public int attenuationDistance() {
        return this.attenuationDistance;
    }

    @Override
    public boolean preload() {
        return this.preload;
    }

    @Override
    @NotNull
    public SoundEntry.Type type() {
        return this.type;
    }

    @Override
    public boolean allDefault() {
        return this.volume == 1.0f && this.pitch == 1.0f && this.weight == 1 && !this.stream && this.attenuationDistance == 16 && !this.preload && this.type == DEFAULT_TYPE;
    }

    @Override
    @NotNull
    public SoundEntry.Builder toBuilder() {
        return SoundEntry.soundEntry().key(this.key).volume(this.volume).pitch(this.pitch).weight(this.weight).stream(this.stream).attenuationDistance(this.attenuationDistance).preload(this.preload).type(this.type);
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"key", (Object)this.key), ExaminableProperty.of((String)"volume", (float)this.volume), ExaminableProperty.of((String)"pitch", (float)this.pitch), ExaminableProperty.of((String)"weight", (int)this.weight), ExaminableProperty.of((String)"stream", (boolean)this.stream), ExaminableProperty.of((String)"attenuationDistance", (int)this.attenuationDistance), ExaminableProperty.of((String)"preload", (boolean)this.preload), ExaminableProperty.of((String)"type", (Object)((Object)this.type)));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoundEntryImpl sound = (SoundEntryImpl)o;
        return Float.compare(sound.volume, this.volume) == 0 && Float.compare(sound.pitch, this.pitch) == 0 && this.weight == sound.weight && this.stream == sound.stream && this.attenuationDistance == sound.attenuationDistance && this.preload == sound.preload && this.key.equals(sound.key) && this.type == sound.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, Float.valueOf(this.volume), Float.valueOf(this.pitch), this.weight, this.stream, this.attenuationDistance, this.preload, this.type});
    }

    static final class BuilderImpl
    implements SoundEntry.Builder {
        private Key key;
        private float volume = 1.0f;
        private float pitch = 1.0f;
        private int weight = 1;
        private boolean stream = false;
        private int attenuationDistance = 16;
        private boolean preload = false;
        private SoundEntry.Type type = SoundEntry.DEFAULT_TYPE;

        BuilderImpl() {
        }

        @Override
        @NotNull
        public SoundEntry.Builder type(@NotNull SoundEntry.Type type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @Override
        @NotNull
        public SoundEntry.Builder key(@NotNull Key key) {
            this.key = Objects.requireNonNull(key, "key");
            return this;
        }

        @Override
        @NotNull
        public SoundEntry.Builder volume(float volume) {
            this.volume = volume;
            return this;
        }

        @Override
        @NotNull
        public SoundEntry.Builder pitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        @Override
        @NotNull
        public SoundEntry.Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        @Override
        @NotNull
        public SoundEntry.Builder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        @Override
        @NotNull
        public SoundEntry.Builder attenuationDistance(int attenuationDistance) {
            this.attenuationDistance = attenuationDistance;
            return this;
        }

        @Override
        @NotNull
        public SoundEntry.Builder preload(boolean preload) {
            this.preload = preload;
            return this;
        }

        @Override
        @NotNull
        public SoundEntry build() {
            return new SoundEntryImpl(this.key, this.volume, this.pitch, this.weight, this.stream, this.attenuationDistance, this.preload, this.type);
        }
    }
}

