/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.sound;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.examination.Examinable;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import team.unnamed.creative.sound.Sound;
import team.unnamed.creative.sound.SoundEntryImpl;
import team.unnamed.creative.sound.SoundEvent;

@ApiStatus.NonExtendable
public interface SoundEntry
extends Keyed,
Examinable {
    public static final float DEFAULT_VOLUME = 1.0f;
    public static final float DEFAULT_PITCH = 1.0f;
    public static final int DEFAULT_WEIGHT = 1;
    public static final boolean DEFAULT_STREAM = false;
    public static final int DEFAULT_ATTENUATION_DISTANCE = 16;
    public static final boolean DEFAULT_PRELOAD = false;
    public static final Type DEFAULT_TYPE = Type.FILE;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static SoundEntry sound(@NotNull Key path, float volume, float pitch, int weight, boolean stream, int attenuationDistance, boolean preload) {
        return new SoundEntryImpl(path, volume, pitch, weight, stream, attenuationDistance, preload, Type.FILE);
    }

    @NotNull
    public static SoundEntry soundEntry(@NotNull Sound sound) {
        return SoundEntry.soundEntry().type(Type.FILE).key(sound.key()).build();
    }

    @NotNull
    public static SoundEntry soundEntry(@NotNull SoundEvent soundEvent) {
        return SoundEntry.soundEntry().type(Type.EVENT).key(soundEvent.key()).build();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static SoundEntry withDefaultValues(@NotNull Sound sound) {
        return SoundEntry.builder().nameSound(sound.key()).build();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static SoundEntry event(@NotNull Key name, float volume, float pitch, int weight, boolean stream, int attenuationDistance, boolean preload) {
        return new SoundEntryImpl(name, volume, pitch, weight, stream, attenuationDistance, preload, Type.EVENT);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    public static SoundEntry event(@NotNull @Subst(value="minecraft:sound") String name, float volume, float pitch, int weight, boolean stream, int attenuationDistance, boolean preload) {
        return SoundEntry.event(Key.key((String)name), volume, pitch, weight, stream, attenuationDistance, preload);
    }

    @NotNull
    public static Builder soundEntry() {
        return new SoundEntryImpl.BuilderImpl();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static Builder builder() {
        return SoundEntry.soundEntry();
    }

    @NotNull
    public Key key();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    default public String name() {
        return this.key().value();
    }

    public float volume();

    public float pitch();

    public int weight();

    public boolean stream();

    public int attenuationDistance();

    public boolean preload();

    @NotNull
    public Type type();

    public boolean allDefault();

    @Contract(value="-> new")
    @NotNull
    public Builder toBuilder();

    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder type(@NotNull Type var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder key(@NotNull Key var1);

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
        @Contract(value="_ -> this")
        @NotNull
        default public Builder nameSound(@NotNull Key key) {
            return this.type(Type.FILE).key(key);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
        @Contract(value="_ -> this")
        @NotNull
        default public Builder nameEvent(@NotNull Key key) {
            return this.type(Type.EVENT).key(key);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
        @Contract(value="_ -> this")
        @NotNull
        default public Builder nameEvent(@NotNull @Subst(value="minecraft:sound") String name) {
            return this.nameEvent(Key.key((String)name));
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder volume(float var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder pitch(float var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder weight(int var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder stream(boolean var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder attenuationDistance(int var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder preload(boolean var1);

        @NotNull
        public SoundEntry build();
    }

    public static enum Type {
        FILE,
        EVENT;

    }
}

