/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.model.ModelTexture;
import team.unnamed.creative.util.MoreCollections;

public class ModelTextures
implements Examinable {
    static final ModelTextures EMPTY = new ModelTextures(Collections.emptyList(), null, Collections.emptyMap());
    private final @Unmodifiable List<ModelTexture> layers;
    @Nullable
    private final ModelTexture particle;
    private final @Unmodifiable Map<String, ModelTexture> variables;

    private ModelTextures(List<ModelTexture> layers, @Nullable ModelTexture particle, Map<String, ModelTexture> variables) {
        Objects.requireNonNull(layers, "layers");
        Objects.requireNonNull(variables, "variables");
        this.layers = MoreCollections.immutableListOf(layers);
        this.particle = particle;
        this.variables = MoreCollections.immutableMapOf(variables);
    }

    public @Unmodifiable List<ModelTexture> layers() {
        return this.layers;
    }

    @Nullable
    public ModelTexture particle() {
        return this.particle;
    }

    public @Unmodifiable Map<String, ModelTexture> variables() {
        return this.variables;
    }

    @NotNull
    public Builder toBuilder() {
        return ModelTextures.builder().layers(this.layers).particle(this.particle).variables(this.variables);
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"layers", this.layers), ExaminableProperty.of((String)"particle", (Object)this.particle), ExaminableProperty.of((String)"variables", this.variables));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelTextures that = (ModelTextures)o;
        return this.layers.equals(that.layers) && Objects.equals(this.particle, that.particle) && this.variables.equals(that.variables);
    }

    public int hashCode() {
        return Objects.hash(this.layers, this.particle, this.variables);
    }

    public static ModelTextures of(List<ModelTexture> layers, @Nullable ModelTexture particle, Map<String, ModelTexture> variables) {
        return new ModelTextures(layers, particle, variables);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<ModelTexture> layers = null;
        private ModelTexture particle = null;
        private Map<String, ModelTexture> variables = null;

        private Builder() {
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder layers(@NotNull List<ModelTexture> layers) {
            Objects.requireNonNull(layers, "layers");
            this.layers = new ArrayList<ModelTexture>(layers);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder layers(ModelTexture ... layers) {
            Objects.requireNonNull(layers, "layers");
            this.layers = new ArrayList<ModelTexture>(Arrays.asList(layers));
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder addLayer(@NotNull ModelTexture layer) {
            Objects.requireNonNull(layer, "layer");
            if (this.layers == null) {
                this.layers = new ArrayList<ModelTexture>();
            }
            this.layers.add(layer);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder addLayers(ModelTexture ... layers) {
            Objects.requireNonNull(layers, "layers");
            if (this.layers == null) {
                this.layers = new ArrayList<ModelTexture>();
            }
            Collections.addAll(this.layers, layers);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder particle(@Nullable ModelTexture particle) {
            this.particle = particle;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder variables(@NotNull Map<String, ModelTexture> variables) {
            Objects.requireNonNull(variables, "variables");
            this.variables = new LinkedHashMap<String, ModelTexture>(variables);
            return this;
        }

        @Contract(value="_, _ -> this")
        @NotNull
        public Builder addVariable(@NotNull String id, @NotNull ModelTexture texture) {
            Objects.requireNonNull(id, "id");
            Objects.requireNonNull(texture, "texture");
            if (this.variables == null) {
                this.variables = new LinkedHashMap<String, ModelTexture>();
            }
            this.variables.put(id, texture);
            return this;
        }

        @Contract(value="-> new")
        @NotNull
        public ModelTextures build() {
            return new ModelTextures(this.layers == null ? Collections.emptyList() : this.layers, this.particle, this.variables == null ? Collections.emptyMap() : this.variables);
        }
    }
}

