/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.model;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.examination.Examinable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.model.Element;
import team.unnamed.creative.model.ItemOverride;
import team.unnamed.creative.model.ItemTransform;
import team.unnamed.creative.model.ModelImpl;
import team.unnamed.creative.model.ModelTextures;
import team.unnamed.creative.overlay.ResourceContainer;
import team.unnamed.creative.part.ResourcePackPart;

@ApiStatus.NonExtendable
public interface Model
extends ResourcePackPart,
Keyed,
Examinable {
    public static final Key ITEM_GENERATED = Key.key((String)"item/generated");
    public static final Key ITEM_HANDHELD = Key.key((String)"item/handheld");
    public static final Key BUILT_IN_ENTITY = Key.key((String)"builtin/entity");
    public static final Key BUILT_IN_GENERATED = Key.key((String)"builtin/generated");
    public static final boolean DEFAULT_AMBIENT_OCCLUSION = true;

    @Contract(value="-> new")
    @NotNull
    public static Builder model() {
        return new ModelImpl.BuilderImpl();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @Contract(value="-> new")
    @NotNull
    public static Builder builder() {
        return Model.model();
    }

    @NotNull
    public Key key();

    @Nullable
    public Key parent();

    public boolean ambientOcclusion();

    @NotNull
    public @Unmodifiable Map<ItemTransform.Type, ItemTransform> display();

    @NotNull
    public ModelTextures textures();

    @Nullable
    public GuiLight guiLight();

    @NotNull
    public @Unmodifiable List<Element> elements();

    @NotNull
    public List<ItemOverride> overrides();

    @Contract(value="-> new")
    @NotNull
    default public Builder toBuilder() {
        return Model.model().key(this.key()).parent(this.parent()).ambientOcclusion(this.ambientOcclusion()).display(this.display()).textures(this.textures()).guiLight(this.guiLight()).elements(this.elements()).overrides(this.overrides());
    }

    @Override
    default public void addTo(@NotNull ResourceContainer resourceContainer) {
        resourceContainer.model(this);
    }

    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder key(@NotNull Key var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder parent(@Nullable Key var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder ambientOcclusion(boolean var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder display(@NotNull Map<ItemTransform.Type, ItemTransform> var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder textures(@NotNull ModelTextures var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder guiLight(@Nullable GuiLight var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder elements(@NotNull List<Element> var1);

        @Contract(value="_ -> this")
        @NotNull
        default public Builder elements(Element ... elements) {
            Objects.requireNonNull(elements, "elements");
            return this.elements(Arrays.asList(elements));
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder addElement(@NotNull Element var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder overrides(@NotNull List<ItemOverride> var1);

        @Contract(value="_ -> this")
        @NotNull
        default public Builder overrides(ItemOverride ... overrides) {
            Objects.requireNonNull(overrides, "overrides");
            return this.overrides(Arrays.asList(overrides));
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder addOverride(@NotNull ItemOverride var1);

        @Contract(value="-> new")
        @NotNull
        public Model build();
    }

    public static enum GuiLight {
        FRONT,
        SIDE;

    }
}

