/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.model;

import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import team.unnamed.creative.base.Vector3Float;
import team.unnamed.creative.model.ItemTransform;

final class ItemTransformImpl
implements ItemTransform {
    private final Vector3Float rotation;
    private final Vector3Float translation;
    private final Vector3Float scale;

    ItemTransformImpl(@NotNull Vector3Float rotation, @NotNull Vector3Float translation, @NotNull Vector3Float scale) {
        this.rotation = Objects.requireNonNull(rotation, "rotation");
        this.translation = Objects.requireNonNull(translation, "translation");
        this.scale = Objects.requireNonNull(scale, "scale");
        this.validate();
    }

    private void validate() {
        if (this.translation.x() < -80.0f || this.translation.x() > 80.0f || this.translation.y() < -80.0f || this.translation.y() > 80.0f || this.translation.z() < -80.0f || this.translation.z() > 80.0f) {
            throw new IllegalArgumentException("Invalid translation (" + this.translation + "), out of bounds (" + -80.0f + " to " + 80.0f + ")");
        }
        if (this.scale.x() < -4.0f || this.scale.x() > 4.0f || this.scale.y() < -4.0f || this.scale.y() > 4.0f || this.scale.z() < -4.0f || this.scale.z() > 4.0f) {
            throw new IllegalArgumentException("Invalid scale (" + this.scale + "), out of bounds (" + -4.0f + " to " + 4.0f + ")");
        }
    }

    @Override
    @NotNull
    public Vector3Float rotation() {
        return this.rotation;
    }

    @Override
    @NotNull
    public Vector3Float translation() {
        return this.translation;
    }

    @Override
    @NotNull
    public Vector3Float scale() {
        return this.scale;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"rotation", (Object)this.rotation), ExaminableProperty.of((String)"translation", (Object)this.translation), ExaminableProperty.of((String)"scale", (Object)this.scale));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemTransformImpl that = (ItemTransformImpl)o;
        return this.rotation.equals(that.rotation) && this.translation.equals(that.translation) && this.scale.equals(that.scale);
    }

    public int hashCode() {
        return Objects.hash(this.rotation, this.translation, this.scale);
    }

    static final class BuilderImpl
    implements ItemTransform.Builder {
        private Vector3Float rotation = ItemTransform.DEFAULT_ROTATION;
        private Vector3Float translation = ItemTransform.DEFAULT_TRANSLATION;
        private Vector3Float scale = ItemTransform.DEFAULT_SCALE;

        BuilderImpl() {
        }

        @Override
        @NotNull
        public ItemTransform.Builder rotation(@NotNull Vector3Float rotation) {
            this.rotation = Objects.requireNonNull(rotation, "rotation");
            return this;
        }

        @Override
        @NotNull
        public ItemTransform.Builder translation(@NotNull Vector3Float translation) {
            this.translation = Objects.requireNonNull(translation, "translation");
            return this;
        }

        @Override
        @NotNull
        public ItemTransform.Builder scale(@NotNull Vector3Float scale) {
            this.scale = Objects.requireNonNull(scale, "scale");
            return this;
        }

        @Override
        @NotNull
        public ItemTransform build() {
            return new ItemTransformImpl(this.rotation, this.translation, this.scale);
        }
    }
}

