/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.model;

import java.util.Map;
import net.kyori.examination.Examinable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.base.CubeFace;
import team.unnamed.creative.base.Vector3Float;
import team.unnamed.creative.model.ElementFace;
import team.unnamed.creative.model.ElementImpl;
import team.unnamed.creative.model.ElementRotation;

public interface Element
extends Examinable {
    public static final boolean DEFAULT_SHADE = true;
    public static final float MIN_EXTENT = -16.0f;
    public static final float MAX_EXTENT = 32.0f;

    @Contract(value="-> new")
    @NotNull
    public static Builder element() {
        return new ElementImpl.BuilderImpl();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @Contract(value="-> new")
    @NotNull
    public static Builder builder() {
        return Element.element();
    }

    @NotNull
    public Vector3Float from();

    @NotNull
    public Vector3Float to();

    @NotNull
    public ElementRotation rotation();

    public boolean shade();

    public @Unmodifiable @NotNull Map<CubeFace, ElementFace> faces();

    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder from(@NotNull Vector3Float var1);

        @Contract(value="_, _, _ -> this")
        @NotNull
        default public Builder from(float x, float y, float z) {
            return this.from(new Vector3Float(x, y, z));
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder to(@NotNull Vector3Float var1);

        @NotNull
        default public Builder to(float x, float y, float z) {
            return this.to(new Vector3Float(x, y, z));
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder rotation(@Nullable ElementRotation var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder shade(boolean var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder faces(@NotNull Map<CubeFace, ElementFace> var1);

        @NotNull
        public Builder addFace(@NotNull CubeFace var1, @NotNull ElementFace var2);

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
        @Contract(value="_, _ -> this")
        @NotNull
        default public Builder face(@NotNull CubeFace type, @NotNull ElementFace face) {
            return this.addFace(type, face);
        }

        @Contract(value="-> new")
        @NotNull
        public Element build();
    }
}

