/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.metadata.filter;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.base.KeyPattern;
import team.unnamed.creative.metadata.MetadataPart;
import team.unnamed.creative.metadata.filter.FilterMetaImpl;

@ApiStatus.NonExtendable
public interface FilterMeta
extends MetadataPart {
    @Contract(value="_ -> new")
    @NotNull
    public static FilterMeta filter(@NotNull List<KeyPattern> patterns) {
        return new FilterMetaImpl(patterns);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static FilterMeta filter(KeyPattern ... patterns) {
        return FilterMeta.filter(Arrays.asList(patterns));
    }

    @Deprecated
    @Contract(value="-> fail")
    @NotNull
    public static FilterMeta filter() {
        throw new UnsupportedOperationException("Cannot create an empty filter meta");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @Contract(value="_ -> new")
    @NotNull
    public static FilterMeta of(@NotNull List<KeyPattern> patterns) {
        return FilterMeta.filter(patterns);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @Contract(value="_ -> new")
    @NotNull
    public static FilterMeta of(KeyPattern ... patterns) {
        return FilterMeta.filter(Arrays.asList(patterns));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @Contract(value="-> fail")
    @NotNull
    public static FilterMeta of() {
        throw new UnsupportedOperationException("Cannot create an empty filter meta");
    }

    @NotNull
    public @Unmodifiable List<KeyPattern> patterns();
}

