/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.font;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.examination.Examinable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.font.FontProvider;
import team.unnamed.creative.font.UnihexFontProviderImpl;

@ApiStatus.NonExtendable
public interface UnihexFontProvider
extends FontProvider {
    @NotNull
    public Key file();

    public @Unmodifiable @NotNull List<SizeOverride> sizes();

    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder file(@NotNull Key var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder sizes(@NotNull List<SizeOverride> var1);

        @Contract(value="_ -> this")
        @NotNull
        default public Builder sizes(SizeOverride ... sizes) {
            Objects.requireNonNull(sizes, "sizes");
            return this.sizes(Arrays.asList(sizes));
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder addSize(@NotNull SizeOverride var1);

        @Contract(value="-> new")
        @NotNull
        public UnihexFontProvider build();
    }

    public static interface SizeOverride
    extends Examinable {
        @NotNull
        public static SizeOverride override(int from, int to, int left, int right) {
            return new UnihexFontProviderImpl.SizeOverrideImpl(from, to, left, right);
        }

        @NotNull
        public static SizeOverride override(String from, String to, int left, int right) {
            return new UnihexFontProviderImpl.SizeOverrideImpl(from, to, left, right);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
        @NotNull
        public static SizeOverride of(int from, int to, int left, int right) {
            return SizeOverride.override(from, to, left, right);
        }

        public int from();

        public int to();

        public int left();

        public int right();
    }
}

