/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.font;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.font.BitMapFontProvider;
import team.unnamed.creative.util.MoreCollections;

final class BitMapFontProviderImpl
implements BitMapFontProvider {
    private final Key file;
    private final int height;
    private final int ascent;
    private final @Unmodifiable List<String> characters;

    BitMapFontProviderImpl(@NotNull Key file, int height, int ascent, @NotNull List<String> characters) {
        this.file = Objects.requireNonNull(file, "file");
        this.height = height;
        this.ascent = ascent;
        this.characters = MoreCollections.immutableListOf(Objects.requireNonNull(characters, "characters"));
        this.validate();
    }

    private void validate() {
        if (this.ascent > this.height) {
            throw new IllegalArgumentException("Ascent (" + this.ascent + ") is higher than height (" + this.height + ")");
        }
        if (this.characters.isEmpty()) {
            throw new IllegalArgumentException("Character list is empty");
        }
        String sample = this.characters.get(0);
        int codePointCount = sample.codePointCount(0, sample.length());
        for (String character : this.characters) {
            Objects.requireNonNull(character, "An element from the character list is null");
            if (character.codePointCount(0, character.length()) == codePointCount) continue;
            throw new IllegalArgumentException("Elements of character list must have the same codepoint count");
        }
    }

    @Override
    @NotNull
    public Key file() {
        return this.file;
    }

    @Override
    @NotNull
    public BitMapFontProvider file(@NotNull Key file) {
        Objects.requireNonNull(file, "file");
        return new BitMapFontProviderImpl(file, this.height, this.ascent, this.characters);
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    @NotNull
    public BitMapFontProvider height(int height) {
        return new BitMapFontProviderImpl(this.file, height, this.ascent, this.characters);
    }

    @Override
    public int ascent() {
        return this.ascent;
    }

    @Override
    @NotNull
    public BitMapFontProvider ascent(int ascent) {
        return new BitMapFontProviderImpl(this.file, this.height, ascent, this.characters);
    }

    @Override
    public @Unmodifiable @NotNull List<String> characters() {
        return this.characters;
    }

    @Override
    @NotNull
    public BitMapFontProvider characters(@NotNull List<String> characters) {
        Objects.requireNonNull(characters, "characters");
        return new BitMapFontProviderImpl(this.file, this.height, this.ascent, characters);
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"height", (int)this.height), ExaminableProperty.of((String)"ascent", (int)this.ascent), ExaminableProperty.of((String)"file", (Object)this.file), ExaminableProperty.of((String)"chars", this.characters));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitMapFontProviderImpl that = (BitMapFontProviderImpl)o;
        return this.height == that.height && this.ascent == that.ascent && this.file.equals(that.file) && this.characters.equals(that.characters);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.height, this.ascent, this.characters);
    }

    static final class BuilderImpl
    implements BitMapFontProvider.Builder {
        private Key file;
        private int height = 8;
        private int ascent;
        private List<String> characters = Collections.emptyList();

        BuilderImpl() {
        }

        @Override
        @NotNull
        public BitMapFontProvider.Builder file(@NotNull Key file) {
            this.file = Objects.requireNonNull(file, "file");
            return this;
        }

        @Override
        @NotNull
        public BitMapFontProvider.Builder height(int height) {
            this.height = height;
            return this;
        }

        @Override
        @NotNull
        public BitMapFontProvider.Builder ascent(int ascent) {
            this.ascent = ascent;
            return this;
        }

        @Override
        @NotNull
        public BitMapFontProvider.Builder characters(@NotNull List<String> characters) {
            this.characters = Objects.requireNonNull(characters, "characters");
            return this;
        }

        @Override
        @NotNull
        public BitMapFontProvider build() {
            return new BitMapFontProviderImpl(this.file, this.height, this.ascent, this.characters);
        }
    }
}

