/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.blockstate;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import team.unnamed.creative.blockstate.BlockState;
import team.unnamed.creative.blockstate.MultiVariant;
import team.unnamed.creative.blockstate.Selector;

final class BlockStateImpl
implements BlockState {
    private final Key key;
    private final Map<String, MultiVariant> variants;
    private final List<Selector> multipart;

    BlockStateImpl(@NotNull Key key, @NotNull Map<String, MultiVariant> variants, @NotNull List<Selector> multipart) {
        this.key = Objects.requireNonNull(key, "key");
        this.variants = Objects.requireNonNull(variants, "variants");
        this.multipart = Objects.requireNonNull(multipart, "multipart");
        this.validate();
    }

    private void validate() {
        if (this.variants.isEmpty() && this.multipart.isEmpty()) {
            throw new IllegalArgumentException("variants and multipart cannot be both empty!");
        }
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    public Map<String, MultiVariant> variants() {
        return this.variants;
    }

    @Override
    public List<Selector> multipart() {
        return this.multipart;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"key", (Object)this.key), ExaminableProperty.of((String)"variants", this.variants), ExaminableProperty.of((String)"multipart", this.multipart));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockStateImpl that = (BlockStateImpl)o;
        return this.key.equals(that.key) && this.variants.equals(that.variants) && this.multipart.equals(that.multipart);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.variants, this.multipart);
    }
}

