/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.base;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

@FunctionalInterface
public interface Writable {
    public static final Writable EMPTY = new Writable(){

        @Override
        public void write(@NotNull OutputStream output) {
        }

        public String toString() {
            return "Writable.EMPTY";
        }
    };
    public static final int DEFAULT_BUFFER_LENGTH = 1024;

    public void write(@NotNull OutputStream var1) throws IOException;

    default public byte @NotNull [] toByteArray() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.write(output);
        return output.toByteArray();
    }

    @NotNull
    default public String toUTF8String() throws IOException {
        return new String(this.toByteArray(), StandardCharsets.UTF_8);
    }

    @NotNull
    public static Writable resource(@NotNull ClassLoader loader, @NotNull String name) {
        Objects.requireNonNull(loader, "loader");
        Objects.requireNonNull(name, "name");
        return Writable.inputStream(() -> {
            InputStream resource = loader.getResourceAsStream(name);
            if (resource == null) {
                throw new IOException("Resource not found: " + name);
            }
            return resource;
        });
    }

    @Deprecated
    @CallerSensitive
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static Writable resource(@NotNull String name) {
        Objects.requireNonNull(name, "name");
        Class caller = Reflection.getCallerClass();
        ClassLoader classLoader = caller.getClassLoader();
        return Writable.resource(classLoader, name);
    }

    @NotNull
    public static Writable file(@NotNull File file) {
        Objects.requireNonNull(file, "file");
        return Writable.inputStream(() -> Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    @NotNull
    public static Writable path(@NotNull Path path, OpenOption ... options) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(options, "options");
        return Writable.inputStream(() -> Files.newInputStream(path, options));
    }

    @NotNull
    public static Writable inputStream(@NotNull Callable<InputStream> inputStreamSupplier) {
        Objects.requireNonNull(inputStreamSupplier, "inputStreamSupplier");
        return output -> {
            try (InputStream input = (InputStream)inputStreamSupplier.call();){
                int len;
                byte[] buf = new byte[1024];
                while ((len = input.read(buf)) != -1) {
                    output.write(buf, 0, len);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Failed to open InputStream", e);
            }
        };
    }

    @NotNull
    public static Writable copyInputStream(@NotNull InputStream inputStream) throws IOException {
        int len;
        Objects.requireNonNull(inputStream, "inputStream");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = inputStream.read(buf)) != -1) {
            output.write(buf, 0, len);
        }
        final byte[] bytes = output.toByteArray();
        return new Writable(){

            @Override
            public void write(@NotNull OutputStream output) throws IOException {
                Objects.requireNonNull(output, "output");
                output.write(bytes);
            }

            @Override
            public byte @NotNull [] toByteArray() {
                return (byte[])bytes.clone();
            }

            public String toString() {
                return "Writable.copyInputStream";
            }
        };
    }

    @NotNull
    public static Writable bytes(byte @NotNull [] bytes) {
        final byte[] b = (byte[])bytes.clone();
        return new Writable(){

            @Override
            public void write(@NotNull OutputStream output) throws IOException {
                Objects.requireNonNull(output, "output");
                output.write(b);
            }

            @Override
            public byte @NotNull [] toByteArray() {
                return (byte[])b.clone();
            }

            @Override
            @NotNull
            public String toUTF8String() {
                return new String(b, StandardCharsets.UTF_8);
            }
        };
    }

    @NotNull
    public static Writable stringUtf8(final @NotNull String string) {
        Objects.requireNonNull(string, "string");
        final byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        return new Writable(){

            @Override
            public void write(@NotNull OutputStream output) throws IOException {
                Objects.requireNonNull(output, "output");
                output.write(bytes);
            }

            @Override
            public byte @NotNull [] toByteArray() {
                return (byte[])bytes.clone();
            }

            @Override
            @NotNull
            public String toUTF8String() {
                return string;
            }

            public String toString() {
                return "Writable { type='utf8', value='" + string + "' }";
            }
        };
    }
}

