/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import team.unnamed.creative.base.Writable;

@FunctionalInterface
public interface Readable {
    @NotNull
    public InputStream open() throws IOException;

    default public void readAndWrite(@NotNull OutputStream output) {
        Objects.requireNonNull(output, "output");
        try (InputStream input = this.open();){
            int len;
            byte[] buf = new byte[1024];
            while ((len = input.read(buf)) != -1) {
                output.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read and write", e);
        }
    }

    default public byte @NotNull [] readAsByteArray() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.readAndWrite(output);
        return output.toByteArray();
    }

    @NotNull
    default public String readAsUTF8String() throws IOException {
        return new String(this.readAsByteArray(), StandardCharsets.UTF_8);
    }

    @NotNull
    default public Writable asWritable() {
        return Writable.inputStream(this::open);
    }

    @NotNull
    public static Readable resource(@NotNull ClassLoader loader, @NotNull String name) {
        Objects.requireNonNull(loader, "loader");
        Objects.requireNonNull(name, "name");
        return () -> {
            InputStream input = loader.getResourceAsStream(name);
            if (input == null) {
                throw new IOException("Resource not found: " + name);
            }
            return input;
        };
    }

    @Deprecated
    @CallerSensitive
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static Readable resource(@NotNull String name) {
        Objects.requireNonNull(name, "name");
        Class caller = Reflection.getCallerClass();
        ClassLoader classLoader = caller.getClassLoader();
        return Readable.resource(classLoader, name);
    }

    @NotNull
    public static Readable file(@NotNull File file) {
        Objects.requireNonNull(file, "file");
        return () -> Files.newInputStream(file.toPath(), new OpenOption[0]);
    }

    @NotNull
    public static Readable path(@NotNull Path path, OpenOption ... options) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(options, "options");
        return () -> Files.newInputStream(path, options);
    }

    @NotNull
    public static Readable copyInputStream(@NotNull InputStream inputStream) {
        Objects.requireNonNull(inputStream, "inputStream");
        final byte[] bytes = ((Readable)() -> inputStream).readAsByteArray();
        return new Readable(){

            @Override
            @NotNull
            public InputStream open() {
                return new ByteArrayInputStream(bytes);
            }

            @Override
            public byte @NotNull [] readAsByteArray() {
                return (byte[])bytes.clone();
            }

            @Override
            @NotNull
            public String readAsUTF8String() {
                return new String(bytes, StandardCharsets.UTF_8);
            }

            public String toString() {
                return "Readable.copyInputStream";
            }
        };
    }

    @NotNull
    public static Readable bytes(byte @NotNull [] bytes) {
        Objects.requireNonNull(bytes, "bytes");
        final byte[] b = (byte[])bytes.clone();
        return new Readable(){

            @Override
            @NotNull
            public InputStream open() {
                return new ByteArrayInputStream(b);
            }

            @Override
            public byte @NotNull [] readAsByteArray() {
                return (byte[])b.clone();
            }

            @Override
            @NotNull
            public String readAsUTF8String() {
                return new String(b, StandardCharsets.UTF_8);
            }
        };
    }

    @NotNull
    public static Readable stringUtf8(final @NotNull String string) {
        Objects.requireNonNull(string, "string");
        final byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        return new Readable(){

            @Override
            @NotNull
            public InputStream open() {
                return new ByteArrayInputStream(bytes);
            }

            @Override
            public byte @NotNull [] readAsByteArray() {
                return (byte[])bytes.clone();
            }

            @Override
            @NotNull
            public String readAsUTF8String() {
                return string;
            }

            public String toString() {
                return "Readable { type='utf8', value='" + string + "' }";
            }
        };
    }
}

