/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.creative.ResourcePackImpl;
import team.unnamed.creative.base.Writable;
import team.unnamed.creative.metadata.Metadata;
import team.unnamed.creative.metadata.filter.FilterMeta;
import team.unnamed.creative.metadata.language.LanguageMeta;
import team.unnamed.creative.metadata.overlays.OverlayEntry;
import team.unnamed.creative.metadata.overlays.OverlaysMeta;
import team.unnamed.creative.metadata.pack.PackFormat;
import team.unnamed.creative.metadata.pack.PackMeta;
import team.unnamed.creative.overlay.Overlay;
import team.unnamed.creative.overlay.ResourceContainer;

@ApiStatus.NonExtendable
public interface ResourcePack
extends ResourceContainer {
    @NotNull
    public static ResourcePack resourcePack() {
        return new ResourcePackImpl();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static ResourcePack create() {
        return ResourcePack.resourcePack();
    }

    @Nullable
    public Writable icon();

    public void icon(@Nullable Writable var1);

    @NotNull
    public Metadata metadata();

    public void metadata(@NotNull Metadata var1);

    default public void editMetadata(@NotNull Consumer<Metadata.Builder> editFunction) {
        Objects.requireNonNull(editFunction, "editFunction");
        Metadata.Builder builder = this.metadata().toBuilder();
        editFunction.accept(builder);
        this.metadata(builder.build());
    }

    @Nullable
    default public PackMeta packMeta() {
        return this.metadata().meta(PackMeta.class);
    }

    default public void packMeta(@NotNull PackMeta packMeta) {
        Objects.requireNonNull(packMeta, "packMeta");
        this.editMetadata(metadata -> metadata.add(packMeta));
    }

    default public void packMeta(int format, @NotNull String description) {
        this.packMeta(PackMeta.of(format, description));
    }

    default public void packMeta(@NotNull PackFormat format, @NotNull Component description) {
        this.packMeta(PackMeta.of(format, description));
    }

    default public void packMeta(int format, @NotNull Component description) {
        this.packMeta(PackMeta.of(format, description));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    default public int format() {
        PackMeta meta = this.packMeta();
        if (meta == null) {
            return -1;
        }
        return meta.format();
    }

    @Nullable
    default public PackFormat formats() {
        PackMeta meta = this.packMeta();
        if (meta == null) {
            return null;
        }
        return meta.formats();
    }

    @Nullable
    default public String description() {
        PackMeta meta = this.packMeta();
        if (meta == null) {
            return null;
        }
        return meta.description();
    }

    @Nullable
    default public LanguageMeta languageMeta() {
        return this.metadata().meta(LanguageMeta.class);
    }

    default public void languageMeta(@NotNull LanguageMeta languageMeta) {
        Objects.requireNonNull(languageMeta, "languageMeta");
        this.editMetadata(metadata -> metadata.add(languageMeta));
    }

    @Nullable
    default public FilterMeta filterMeta() {
        return this.metadata().meta(FilterMeta.class);
    }

    default public void filterMeta(@NotNull FilterMeta filterMeta) {
        Objects.requireNonNull(filterMeta, "filterMeta");
        this.editMetadata(metadata -> metadata.add(filterMeta));
    }

    @Nullable
    default public OverlaysMeta overlaysMeta() {
        return this.metadata().meta(OverlaysMeta.class);
    }

    default public void overlaysMeta(@NotNull OverlaysMeta overlaysMeta) {
        Objects.requireNonNull(overlaysMeta, "overlaysMeta");
        this.editMetadata(metadata -> metadata.add(overlaysMeta));
    }

    public void overlay(@NotNull Overlay var1);

    @Nullable
    public Overlay overlay(@NotNull @OverlayEntry.Directory String var1);

    @NotNull
    public Collection<Overlay> overlays();
}

