/*
 * Decompiled with CFR 0.152.
 */
package com.residence.zip;

import com.bekvon.bukkit.residence.Residence;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.World;

public class ZipLibrary {
    private Residence plugin;
    private File BackupDir = new File(Residence.getInstance().getDataLocation(), "Backup");

    public ZipLibrary(Residence residence) {
        this.plugin = residence;
    }

    private void cleanFiles() {
        Long l = (long)this.plugin.getConfigManager().BackupAutoCleanUpDays() * 60L * 1000L * 24L * 60L;
        Long l2 = System.currentTimeMillis();
        File[] fileArray = this.BackupDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            long l3 = l2 - file.lastModified();
            if (l3 > l) {
                file.delete();
            }
            ++n2;
        }
    }

    public void backup() {
        if (!this.BackupDir.isDirectory()) {
            try {
                this.BackupDir.mkdir();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        if (this.plugin.getConfigManager().BackupAutoCleanUpUse()) {
            this.cleanFiles();
        }
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
        File file = new File(this.BackupDir, String.valueOf(simpleDateFormat.format(date)) + ".zip");
        ArrayList<File> arrayList = new ArrayList<File>();
        File file2 = new File(this.plugin.getDataLocation(), "Save");
        File file3 = new File(file2, "Worlds");
        if (!file2.isDirectory()) {
            return;
        }
        if (this.plugin.getConfigManager().BackupWorldFiles()) {
            for (World world : this.plugin.getServ().getWorlds()) {
                File file4 = new File(file3, "res_" + world.getName() + ".yml");
                if (!file4.isFile()) continue;
                arrayList.add(file4);
            }
        }
        if (this.plugin.getConfigManager().BackupforsaleFile()) {
            arrayList.add(new File(file2, "forsale.yml"));
        }
        if (this.plugin.getConfigManager().BackupleasesFile()) {
            arrayList.add(new File(file2, "leases.yml"));
        }
        if (this.plugin.getConfigManager().BackuppermlistsFile()) {
            arrayList.add(new File(file2, "permlists.yml"));
        }
        if (this.plugin.getConfigManager().BackuprentFile()) {
            arrayList.add(new File(file2, "rent.yml"));
        }
        if (this.plugin.getConfigManager().BackupflagsFile()) {
            arrayList.add(new File(this.plugin.getDataLocation(), "flags.yml"));
        }
        if (this.plugin.getConfigManager().BackupgroupsFile()) {
            arrayList.add(new File(this.plugin.getDataLocation(), "groups.yml"));
        }
        if (this.plugin.getConfigManager().BackupconfigFile()) {
            arrayList.add(new File(this.plugin.getDataLocation(), "config.yml"));
        }
        if (this.plugin.getConfigManager().UseZipBackup()) {
            ZipLibrary.packZip(file, arrayList);
        }
    }

    private static void packZip(File file, List<File> list2) {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        zipOutputStream.setLevel(-1);
        for (File file2 : list2) {
            if (file2.isDirectory()) {
                ZipLibrary.zipDir(zipOutputStream, "", file2);
                continue;
            }
            ZipLibrary.zipFile(zipOutputStream, "", file2);
        }
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    private static String buildPath(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return string2;
        }
        return String.valueOf(string) + File.separator + string2;
    }

    private static void zipDir(ZipOutputStream zipOutputStream, String string, File file) {
        if (!file.canRead()) {
            return;
        }
        File[] fileArray = file.listFiles();
        string = ZipLibrary.buildPath(string, file.getName());
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray2[n2];
            if (file2.isDirectory()) {
                ZipLibrary.zipDir(zipOutputStream, string, file2);
            } else {
                ZipLibrary.zipFile(zipOutputStream, string, file2);
            }
            ++n2;
        }
    }

    private static void zipFile(ZipOutputStream zipOutputStream, String string, File file) {
        if (!file.canRead()) {
            return;
        }
        zipOutputStream.putNextEntry(new ZipEntry(ZipLibrary.buildPath(string, file.getName())));
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[4092];
        int n = 0;
        while ((n = fileInputStream.read(byArray)) != -1) {
            zipOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        zipOutputStream.closeEntry();
    }
}

