/*
 * Decompiled with CFR 0.152.
 */
package com.residence.mcstats;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.scheduler.BukkitTask;

public class Metrics {
    private static final int REVISION = 6;
    private static final String BASE_URL = "http://mcstats.org";
    private static final String REPORT_URL = "/report/%s";
    private static final String CUSTOM_DATA_SEPARATOR = "~~";
    private static final int PING_INTERVAL = 10;
    private final Plugin plugin;
    private final Set<Graph> graphs = Collections.synchronizedSet(new HashSet());
    private final Graph defaultGraph = new Graph("Default");
    private final YamlConfiguration configuration;
    private final File configurationFile;
    private final String guid;
    private final boolean debug;
    private final Object optOutLock = new Object();
    private volatile BukkitTask task = null;

    public Metrics(Plugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin cannot be null");
        }
        this.plugin = plugin;
        this.configurationFile = this.getConfigFile();
        this.configuration = YamlConfiguration.loadConfiguration((File)this.configurationFile);
        this.configuration.addDefault("opt-out", (Object)false);
        this.configuration.addDefault("guid", (Object)UUID.randomUUID().toString());
        this.configuration.addDefault("debug", (Object)false);
        if (this.configuration.get("guid", null) == null) {
            this.configuration.options().header(BASE_URL).copyDefaults(true);
            this.configuration.save(this.configurationFile);
        }
        this.guid = this.configuration.getString("guid");
        this.debug = this.configuration.getBoolean("debug", false);
    }

    public Graph createGraph(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Graph name cannot be null");
        }
        Graph graph = new Graph(string);
        this.graphs.add(graph);
        return graph;
    }

    public void addGraph(Graph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph cannot be null");
        }
        this.graphs.add(graph);
    }

    public void addCustomData(Plotter plotter) {
        if (plotter == null) {
            throw new IllegalArgumentException("Plotter cannot be null");
        }
        this.defaultGraph.addPlotter(plotter);
        this.graphs.add(this.defaultGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Object object = this.optOutLock;
        synchronized (object) {
            block6: {
                block5: {
                    if (!this.isOptOut()) break block5;
                    return false;
                }
                if (this.task == null) break block6;
                return true;
            }
            this.task = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously(this.plugin, new Runnable(){
                private boolean firstPost = true;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block7: {
                        try {
                            Object object = Metrics.this.optOutLock;
                            synchronized (object) {
                                if (Metrics.this.isOptOut() && Metrics.this.task != null) {
                                    Metrics.this.task.cancel();
                                    Metrics.this.task = null;
                                    for (Graph graph : Metrics.this.graphs) {
                                        graph.onOptOut();
                                    }
                                }
                            }
                            Metrics.this.postPlugin(!this.firstPost);
                            this.firstPost = false;
                        }
                        catch (IOException iOException) {
                            if (!Metrics.this.debug) break block7;
                            Bukkit.getLogger().log(Level.INFO, "[Metrics] " + iOException.getMessage());
                        }
                    }
                }
            }, 0L, 12000L);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isOptOut() {
        Object object = this.optOutLock;
        synchronized (object) {
            try {
                this.configuration.load(this.getConfigFile());
            }
            catch (IOException iOException) {
                if (this.debug) {
                    Bukkit.getLogger().log(Level.INFO, "[Metrics] " + iOException.getMessage());
                }
                return true;
            }
            catch (InvalidConfigurationException invalidConfigurationException) {
                if (this.debug) {
                    Bukkit.getLogger().log(Level.INFO, "[Metrics] " + invalidConfigurationException.getMessage());
                }
                return true;
            }
            return this.configuration.getBoolean("opt-out", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        Object object = this.optOutLock;
        synchronized (object) {
            if (this.isOptOut()) {
                this.configuration.set("opt-out", (Object)false);
                this.configuration.save(this.configurationFile);
            }
            if (this.task == null) {
                this.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        Object object = this.optOutLock;
        synchronized (object) {
            if (!this.isOptOut()) {
                this.configuration.set("opt-out", (Object)true);
                this.configuration.save(this.configurationFile);
            }
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }

    public File getConfigFile() {
        File file = this.plugin.getDataFolder().getParentFile();
        return new File(new File(file, "PluginMetrics"), "config.yml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postPlugin(boolean bl) {
        Object object;
        StringBuilder stringBuilder22;
        PluginDescriptionFile pluginDescriptionFile = this.plugin.getDescription();
        String string = pluginDescriptionFile.getName();
        boolean bl2 = Bukkit.getServer().getOnlineMode();
        String string2 = pluginDescriptionFile.getVersion();
        String string3 = Bukkit.getVersion();
        int n = 0;
        for (StringBuilder stringBuilder22 : Bukkit.getOnlinePlayers()) {
            ++n;
        }
        stringBuilder22 = new StringBuilder();
        stringBuilder22.append(Metrics.encode("guid")).append('=').append(Metrics.encode(this.guid));
        Metrics.encodeDataPair(stringBuilder22, "version", string2);
        Metrics.encodeDataPair(stringBuilder22, "server", string3);
        Metrics.encodeDataPair(stringBuilder22, "players", Integer.toString(n));
        Metrics.encodeDataPair(stringBuilder22, "revision", String.valueOf(6));
        String string4 = System.getProperty("os.name");
        String string5 = System.getProperty("os.arch");
        String string6 = System.getProperty("os.version");
        String string7 = System.getProperty("java.version");
        int n2 = Runtime.getRuntime().availableProcessors();
        if (string5.equals("amd64")) {
            string5 = "x86_64";
        }
        Metrics.encodeDataPair(stringBuilder22, "osname", string4);
        Metrics.encodeDataPair(stringBuilder22, "osarch", string5);
        Metrics.encodeDataPair(stringBuilder22, "osversion", string6);
        Metrics.encodeDataPair(stringBuilder22, "cores", Integer.toString(n2));
        Metrics.encodeDataPair(stringBuilder22, "online-mode", Boolean.toString(bl2));
        Metrics.encodeDataPair(stringBuilder22, "java_version", string7);
        if (bl) {
            Metrics.encodeDataPair(stringBuilder22, "ping", "true");
        }
        Object object4 = this.graphs;
        synchronized (object4) {
            for (Graph object32 : this.graphs) {
                for (Plotter plotter : object32.getPlotters()) {
                    object = String.format("C%s%s%s%s", CUSTOM_DATA_SEPARATOR, object32.getName(), CUSTOM_DATA_SEPARATOR, plotter.getColumnName());
                    String string8 = Integer.toString(plotter.getValue());
                    Metrics.encodeDataPair(stringBuilder22, (String)object, string8);
                }
            }
        }
        object4 = new URL(BASE_URL + String.format(REPORT_URL, Metrics.encode(string)));
        URLConnection uRLConnection = Metrics.isMineshafterPresent() ? ((URL)object4).openConnection(Proxy.NO_PROXY) : ((URL)object4).openConnection();
        uRLConnection.setDoOutput(true);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
        outputStreamWriter.write(stringBuilder22.toString());
        outputStreamWriter.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        String string9 = bufferedReader.readLine();
        outputStreamWriter.close();
        bufferedReader.close();
        if (string9 == null || string9.startsWith("ERR")) {
            throw new IOException(string9);
        }
        if (string9.contains("OK This is your first update this hour")) {
            object = this.graphs;
            synchronized (object) {
                for (Graph graph : this.graphs) {
                    for (Plotter plotter : graph.getPlotters()) {
                        plotter.reset();
                    }
                }
            }
        }
    }

    private static boolean isMineshafterPresent() {
        try {
            Class.forName("mineshafter.MineServer");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void encodeDataPair(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append('&').append(Metrics.encode(string)).append('=').append(Metrics.encode(string2));
    }

    private static String encode(String string) {
        return URLEncoder.encode(string, "UTF-8");
    }

    public static class Graph {
        private final String name;
        private final Set<Plotter> plotters = new LinkedHashSet<Plotter>();

        private Graph(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void addPlotter(Plotter plotter) {
            this.plotters.add(plotter);
        }

        public void removePlotter(Plotter plotter) {
            this.plotters.remove(plotter);
        }

        public Set<Plotter> getPlotters() {
            return Collections.unmodifiableSet(this.plotters);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Graph)) {
                return false;
            }
            Graph graph = (Graph)object;
            return graph.name.equals(this.name);
        }

        protected void onOptOut() {
        }
    }

    public static abstract class Plotter {
        private final String name;

        public Plotter() {
            this("Default");
        }

        public Plotter(String string) {
            this.name = string;
        }

        public abstract int getValue();

        public String getColumnName() {
            return this.name;
        }

        public void reset() {
        }

        public int hashCode() {
            return this.getColumnName().hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Plotter)) {
                return false;
            }
            Plotter plotter = (Plotter)object;
            return plotter.name.equals(this.name) && plotter.getValue() == this.getValue();
        }
    }
}

