/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.vaultinterface;

import com.bekvon.bukkit.residence.economy.EconomyInterface;
import com.bekvon.bukkit.residence.permissions.PermissionsInterface;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class ResidenceVaultAdapter
implements EconomyInterface,
PermissionsInterface {
    public static Permission permissions = null;
    public static Economy economy = null;
    public static Chat chat = null;

    public boolean permissionsOK() {
        return permissions != null && !permissions.getName().equalsIgnoreCase("SuperPerms");
    }

    public boolean economyOK() {
        return economy != null;
    }

    public boolean chatOK() {
        return chat != null;
    }

    public ResidenceVaultAdapter(Server server2) {
        ResidenceVaultAdapter.setupPermissions(server2);
        ResidenceVaultAdapter.setupEconomy(server2);
        ResidenceVaultAdapter.setupChat(server2);
    }

    private static boolean setupPermissions(Server server2) {
        RegisteredServiceProvider registeredServiceProvider = server2.getServicesManager().getRegistration(Permission.class);
        if (registeredServiceProvider != null) {
            permissions = (Permission)registeredServiceProvider.getProvider();
        }
        return permissions != null;
    }

    private static boolean setupChat(Server server2) {
        RegisteredServiceProvider registeredServiceProvider = server2.getServicesManager().getRegistration(Chat.class);
        if (registeredServiceProvider != null) {
            chat = (Chat)registeredServiceProvider.getProvider();
        }
        return chat != null;
    }

    private static boolean setupEconomy(Server server2) {
        RegisteredServiceProvider registeredServiceProvider = server2.getServicesManager().getRegistration(Economy.class);
        if (registeredServiceProvider != null) {
            economy = (Economy)registeredServiceProvider.getProvider();
        }
        return economy != null;
    }

    @Override
    public String getPlayerGroup(Player player) {
        String string = permissions.getPrimaryGroup(player).toLowerCase();
        if (string == null) {
            return string;
        }
        return string.toLowerCase();
    }

    @Override
    public String getPlayerGroup(String string, String string2) {
        String string3 = permissions.getPrimaryGroup(string2, string);
        if (string3 == null) {
            return string3;
        }
        return string3.toLowerCase();
    }

    public static boolean hasPermission(OfflinePlayer offlinePlayer, String string, String string2) {
        if (permissions == null) {
            return false;
        }
        try {
            return permissions.playerHas(string2, offlinePlayer, string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public double getBalance(Player player) {
        return economy.getBalance((OfflinePlayer)player);
    }

    @Override
    public double getBalance(String string) {
        return economy.getBalance(string);
    }

    @Override
    public boolean canAfford(String string, double d) {
        return economy.has(string, d);
    }

    @Override
    public boolean add(String string, double d) {
        return economy.depositPlayer(string, d).transactionSuccess();
    }

    @Override
    public boolean subtract(String string, double d) {
        return economy.withdrawPlayer(string, d).transactionSuccess();
    }

    @Override
    public boolean transfer(String string, String string2, double d) {
        if (economy.withdrawPlayer(string, d).transactionSuccess()) {
            if (economy.depositPlayer(string2, d).transactionSuccess()) {
                return true;
            }
            economy.depositPlayer(string, d);
            return false;
        }
        return false;
    }

    public String getEconomyName() {
        if (economy != null) {
            return economy.getName();
        }
        return "";
    }

    public String getPermissionsName() {
        if (permissions != null) {
            return permissions.getName();
        }
        return "";
    }

    public String getChatName() {
        if (chat != null) {
            return chat.getName();
        }
        return "";
    }

    @Override
    public String getName() {
        return "Vault";
    }

    @Override
    public String format(double d) {
        return economy.format(d);
    }
}

