/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.utils;

import com.bekvon.bukkit.residence.Residence;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class YmlMaker {
    Residence Plugin;
    public String fileName;
    private JavaPlugin plugin;
    public File ConfigFile;
    private FileConfiguration Configuration;

    public YmlMaker(Residence residence) {
        this.Plugin = residence;
    }

    public YmlMaker(JavaPlugin javaPlugin, String string) {
        if (javaPlugin == null) {
            throw new IllegalArgumentException("plugin cannot be null");
        }
        this.plugin = javaPlugin;
        this.fileName = string;
        File file = javaPlugin.getDataFolder();
        if (file == null) {
            throw new IllegalStateException();
        }
        this.ConfigFile = new File(String.valueOf(file.toString()) + File.separatorChar + this.fileName);
    }

    private static YamlConfiguration loadConfiguration(InputStreamReader inputStreamReader) {
        Validate.notNull((Object)inputStreamReader, (String)"File cannot be null");
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        try {
            yamlConfiguration.load((Reader)inputStreamReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            return null;
        }
        return yamlConfiguration;
    }

    private YamlConfiguration loadConfiguration(InputStream inputStream) {
        Validate.notNull((Object)inputStream, (String)"File cannot be null");
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        try {
            yamlConfiguration.load(this.ConfigFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            return null;
        }
        return yamlConfiguration;
    }

    public void reloadConfig() {
        YamlConfiguration yamlConfiguration;
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(this.ConfigFile), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        if (inputStreamReader != null) {
            this.Configuration = YmlMaker.loadConfiguration(inputStreamReader);
        }
        if (this.Configuration == null) {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return;
        }
        InputStream inputStream = this.plugin.getResource(this.fileName);
        if (inputStream != null && (yamlConfiguration = this.loadConfiguration(inputStream)) != null) {
            this.Configuration.setDefaults((Configuration)yamlConfiguration);
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (inputStreamReader != null) {
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public FileConfiguration getConfig() {
        if (this.Configuration == null) {
            this.reloadConfig();
        }
        return this.Configuration;
    }

    public void saveConfig() {
        if (this.Configuration == null || this.ConfigFile == null) {
            return;
        }
        try {
            this.getConfig().save(this.ConfigFile);
        }
        catch (IOException iOException) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + this.ConfigFile, iOException);
        }
    }

    public void saveDefaultConfig() {
        if (!this.ConfigFile.exists()) {
            this.plugin.saveResource(this.fileName, false);
        }
    }
}

