/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.utils;

import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.lm;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;

public class Utils {
    public static String to24hourShort(Long l) {
        long l2 = l / 1000L / 60L / 60L / 24L / 365L;
        l = l - l2 * 1000L * 60L * 60L * 24L * 365L;
        long l3 = l / 1000L / 60L / 60L / 24L;
        l = l - l3 * 1000L * 60L * 60L * 24L;
        long l4 = l / 1000L / 60L / 60L;
        l = l - l4 * 1000L * 60L * 60L;
        long l5 = l / 1000L / 60L;
        l = l - l5 * 1000L * 60L;
        long l6 = l / 1000L;
        l = l - l6 * 1000L;
        String string = "";
        if (l2 > 0L) {
            string = String.valueOf(string) + (l2 == 1L ? Residence.getInstance().getLM().getMessage(lm.info_oneYear, l2) : Residence.getInstance().getLM().getMessage(lm.info_years, l2));
        }
        if (l3 > 0L) {
            string = String.valueOf(string) + (l3 == 1L ? Residence.getInstance().getLM().getMessage(lm.info_oneDay, l3) : Residence.getInstance().getLM().getMessage(lm.info_day, l3));
        }
        if (l4 > 0L) {
            string = String.valueOf(string) + (l4 == 1L ? Residence.getInstance().getLM().getMessage(lm.info_oneHour, l4) : Residence.getInstance().getLM().getMessage(lm.info_hour, l4));
        }
        if (l5 > 0L) {
            string = String.valueOf(string) + Residence.getInstance().getLM().getMessage(lm.info_min, l5);
        }
        if (l6 > 0L) {
            string = String.valueOf(string) + Residence.getInstance().getLM().getMessage(lm.info_sec, l6);
        }
        if (string.isEmpty()) {
            string = String.valueOf(string) + Residence.getInstance().getLM().getMessage(lm.info_sec, 0);
        }
        return string;
    }

    public static Block getTargetBlock(Player player, int n, boolean bl) {
        return Utils.getTargetBlock(player, null, n, bl);
    }

    public static Block getTargetBlock(Player player, int n) {
        return Utils.getTargetBlock(player, null, n, false);
    }

    public static Block getTargetBlock(Player player, Material material2, int n) {
        return Utils.getTargetBlock(player, material2, n, false);
    }

    public static Block getTargetBlock(Player player, Material material2, int n, boolean bl) {
        if (n > 240) {
            n = 240;
        }
        if (n < 1) {
            n = 1;
        }
        ArrayList<Block> arrayList = new ArrayList<Block>();
        BlockIterator blockIterator = new BlockIterator((LivingEntity)player, n);
        while (blockIterator.hasNext()) {
            Block block = (Block)blockIterator.next();
            arrayList.add(block);
            if (n != 0 && arrayList.size() > n) {
                arrayList.remove(0);
            }
            Material material3 = block.getType();
            if (bl && !block.getType().isSolid()) continue;
            if (material2 == null) {
                if (CMIMaterial.AIR.equals(material3) || CMIMaterial.CAVE_AIR.equals(material3) || CMIMaterial.VOID_AIR.equals(material3)) continue;
                break;
            }
            if (!material2.equals((Object)material3)) continue;
            return block;
        }
        return !arrayList.isEmpty() ? (Block)arrayList.get(arrayList.size() - 1) : null;
    }

    public static String convertLocToStringTiny(Location location) {
        String string = "";
        if (location != null && location.getWorld() != null) {
            string = String.valueOf(string) + location.getWorld().getName();
            string = String.valueOf(string) + ";" + location.getBlockX();
            string = String.valueOf(string) + ";" + location.getBlockY();
            string = String.valueOf(string) + ";" + location.getBlockZ();
        }
        return string.replace(",", ".");
    }

    public static String convertLocToStringShort(Location location) {
        String string = "";
        if (location != null && location.getWorld() != null) {
            string = String.valueOf(string) + location.getWorld().getName();
            string = String.valueOf(string) + ";" + (double)((int)(location.getX() * 100.0)) / 100.0;
            string = String.valueOf(string) + ";" + (double)((int)(location.getY() * 100.0)) / 100.0;
            string = String.valueOf(string) + ";" + (double)((int)(location.getZ() * 100.0)) / 100.0;
        }
        return string.replace(",", ".");
    }

    public static Location convertStringToLocation(String string) {
        World world;
        Location location = null;
        if (string == null) {
            return null;
        }
        if (!string.contains(";")) {
            return null;
        }
        String[] stringArray = string.replace(",", ".").split(";");
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        float f = 0.0f;
        float f2 = 0.0f;
        if (stringArray.length > 0) {
            try {
                d = Double.parseDouble(stringArray[1]);
            }
            catch (Exception exception) {
                return location;
            }
        }
        if (stringArray.length > 1) {
            try {
                d2 = Double.parseDouble(stringArray[2]);
            }
            catch (Exception exception) {
                return location;
            }
        }
        if (stringArray.length > 2) {
            try {
                d3 = Double.parseDouble(stringArray[3]);
            }
            catch (Exception exception) {
                return location;
            }
        }
        if (stringArray.length > 3) {
            try {
                f = Float.parseFloat(stringArray[4]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (stringArray.length > 4) {
            try {
                f2 = Float.parseFloat(stringArray[5]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((world = Bukkit.getWorld((String)stringArray[0])) == null) {
            return null;
        }
        location = new Location(world, d, d2, d3);
        location.setYaw(f);
        location.setPitch(f2);
        return location;
    }
}

