/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.utils;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.shampaggon.crackshot.events.WeaponDamageEntityEvent;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class CrackShot
implements Listener {
    private Residence plugin;

    public CrackShot(Residence residence) {
        this.plugin = residence;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalKilling(WeaponDamageEntityEvent weaponDamageEntityEvent) {
        if (this.plugin.isDisabledWorldListener(weaponDamageEntityEvent.getPlayer().getWorld())) {
            return;
        }
        Entity entity = weaponDamageEntityEvent.getDamager();
        if (!(entity instanceof Arrow) && !(entity instanceof Player)) {
            return;
        }
        Player player = null;
        if (entity instanceof Arrow && !(((Arrow)entity).getShooter() instanceof Player)) {
            return;
        }
        player = entity instanceof Player ? (Player)entity : (Player)((Arrow)entity).getShooter();
        if (player == null) {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        if (!(weaponDamageEntityEvent.getVictim() instanceof LivingEntity)) {
            return;
        }
        Entity entity2 = weaponDamageEntityEvent.getVictim();
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity2.getLocation());
        if (this.plugin.getNms().isAnimal(entity2) && claimedResidence != null && claimedResidence.getPermissions().playerHas(player, Flags.animalkilling, FlagPermissions.FlagCombo.OnlyFalse)) {
            player.sendMessage(this.plugin.msg(lm.Residence_FlagDeny, new Object[]{Flags.animalkilling, claimedResidence.getName()}));
            weaponDamageEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByEntityEvent(WeaponDamageEntityEvent weaponDamageEntityEvent) {
        Player player;
        if (this.plugin.isDisabledWorldListener(weaponDamageEntityEvent.getPlayer().getWorld())) {
            return;
        }
        if (weaponDamageEntityEvent.getVictim().getType() != EntityType.ITEM_FRAME && !this.plugin.getNms().isArmorStandEntity(weaponDamageEntityEvent.getVictim().getType())) {
            return;
        }
        Entity entity = weaponDamageEntityEvent.getDamager();
        if (weaponDamageEntityEvent.getDamager() instanceof Player) {
            player = (Player)weaponDamageEntityEvent.getDamager();
        } else if (entity instanceof Projectile && ((Projectile)entity).getShooter() instanceof Player) {
            player = (Player)((Projectile)entity).getShooter();
        } else {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Location location = weaponDamageEntityEvent.getVictim().getLocation();
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(location);
        if (claimedResidence != null && claimedResidence.getPermissions().playerHas(player, Flags.container, FlagPermissions.FlagCombo.OnlyFalse)) {
            weaponDamageEntityEvent.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.container, claimedResidence.getName()});
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(WeaponDamageEntityEvent weaponDamageEntityEvent) {
        if (this.plugin.isDisabledWorldListener(weaponDamageEntityEvent.getPlayer().getWorld())) {
            return;
        }
        if (!(weaponDamageEntityEvent.getVictim() instanceof Player)) {
            return;
        }
        Player player = (Player)weaponDamageEntityEvent.getVictim();
        if (player.hasMetadata("NPC")) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(player.getLocation());
        Player player2 = weaponDamageEntityEvent.getPlayer();
        ClaimedResidence claimedResidence2 = null;
        if (player2 == null) {
            return;
        }
        claimedResidence2 = this.plugin.getResidenceManager().getByLoc(player2.getLocation());
        boolean bl = true;
        if (claimedResidence2 != null) {
            bl = claimedResidence2.getPermissions().has(Flags.pvp, true);
        }
        if (!bl) {
            player2.sendMessage(this.plugin.msg(lm.General_NoPVPZone, new Object[0]));
            weaponDamageEntityEvent.setCancelled(true);
            return;
        }
        if (claimedResidence == null) {
            if (!this.plugin.getWorldFlags().getPerms(player2.getWorld().getName()).has(Flags.pvp, true)) {
                player2.sendMessage(this.plugin.msg(lm.General_WorldPVPDisabled, new Object[0]));
                weaponDamageEntityEvent.setCancelled(true);
            }
        } else if (!claimedResidence.getPermissions().has(Flags.pvp, true)) {
            player2.sendMessage(this.plugin.msg(lm.General_NoPVPZone, new Object[0]));
            weaponDamageEntityEvent.setCancelled(true);
        }
    }
}

