/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.text.help;

public class PageInfo {
    private int totalEntries = 0;
    private int totalPages = 0;
    private int start = 0;
    private int end = 0;
    private int currentPage = 0;
    private int currentEntry = 0;
    private int perPage = 6;

    public PageInfo(int n, int n2, int n3) {
        this.perPage = n;
        this.totalEntries = n2;
        this.currentPage = n3;
        this.calculate();
    }

    public int getPositionForOutput() {
        return this.currentEntry;
    }

    public int getPositionForOutput(int n) {
        return this.start + n + 1;
    }

    private void calculate() {
        this.start = (this.currentPage - 1) * this.perPage;
        this.end = this.start + this.perPage - 1;
        if (this.end + 1 > this.totalEntries) {
            this.end = this.totalEntries - 1;
        }
        this.totalPages = (int)Math.ceil((double)this.totalEntries / (double)this.perPage);
    }

    public boolean isInRange(int n) {
        return n >= this.start && n <= this.end;
    }

    public boolean isContinue() {
        return !this.isEntryOk();
    }

    public boolean isEntryOk() {
        ++this.currentEntry;
        return this.currentEntry - 1 >= this.start && this.currentEntry - 1 <= this.end;
    }

    public boolean isBreak() {
        return this.currentEntry - 1 > this.end;
    }

    public boolean isPageOk() {
        return this.isPageOk(this.currentPage);
    }

    public boolean isPageOk(int n) {
        if (this.totalPages < n) {
            return false;
        }
        return n >= 1;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getTotalEntries() {
        return this.totalEntries;
    }
}

