/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.text.help;

import com.bekvon.bukkit.cmiLib.CMIChatColor;
import com.bekvon.bukkit.cmiLib.RawMessage;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.rent.RentableLand;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.text.help.PageInfo;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class InformationPager {
    Residence plugin;

    public InformationPager(Residence residence) {
        this.plugin = residence;
    }

    public void printInfo(CommandSender commandSender, String string, String string2, String[] stringArray, int n) {
        this.printInfo(commandSender, string, string2, Arrays.asList(stringArray), n);
    }

    public void printInfo(CommandSender commandSender, String string, String string2, List<String> list2, int n) {
        PageInfo pageInfo = new PageInfo(6, list2.size(), n);
        if (!pageInfo.isPageOk()) {
            commandSender.sendMessage(ChatColor.RED + this.plugin.msg(lm.Invalid_Page, new Object[0]));
            return;
        }
        this.plugin.msg(commandSender, lm.InformationPage_TopSingle, string2);
        this.plugin.msg(commandSender, lm.InformationPage_Page, this.plugin.msg(lm.General_GenericPages, String.format("%d", n), pageInfo.getTotalPages(), list2.size()));
        int n2 = pageInfo.getStart();
        while (n2 <= pageInfo.getEnd()) {
            if (list2.size() > n2) {
                commandSender.sendMessage(ChatColor.GREEN + list2.get(n2));
            }
            ++n2;
        }
        this.plugin.getInfoPageManager().ShowPagination(commandSender, pageInfo, string);
    }

    public void printListInfo(CommandSender commandSender, String string, TreeMap<String, ClaimedResidence> treeMap, int n, boolean bl) {
        int n2 = 20;
        if (commandSender instanceof Player) {
            n2 = 6;
        }
        if (treeMap.isEmpty()) {
            this.plugin.msg(commandSender, lm.Residence_DontOwn, string);
            return;
        }
        PageInfo pageInfo = new PageInfo(n2, treeMap.size(), n);
        if (!(commandSender instanceof Player) && n == -1) {
            this.printListWithDelay(commandSender, treeMap, 0, bl);
            return;
        }
        if (!(commandSender instanceof Player) && n == -2) {
            this.printListToFile(treeMap, bl);
            return;
        }
        if (!pageInfo.isPageOk()) {
            commandSender.sendMessage(ChatColor.RED + this.plugin.msg(lm.Invalid_Page, new Object[0]));
            return;
        }
        if (string != null) {
            this.plugin.msg(commandSender, lm.InformationPage_Top, this.plugin.msg(lm.General_Residences, new Object[0]), string);
        }
        String string2 = "res";
        if (bl) {
            string2 = "resadmin";
        }
        int n3 = -1;
        for (Map.Entry<String, ClaimedResidence> entry : treeMap.entrySet()) {
            String string3;
            String string4;
            Object object;
            Object object2;
            if (++n3 > pageInfo.getEnd()) break;
            if (!pageInfo.isInRange(n3)) continue;
            ClaimedResidence claimedResidence = entry.getValue();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.plugin.msg(lm.General_Owner, claimedResidence.getOwner()));
            if (claimedResidence.getAreaArray().length > 0 && (claimedResidence.getPermissions().has(Flags.hidden, FlagPermissions.FlagCombo.FalseOrNone) && claimedResidence.getPermissions().has(Flags.coords, FlagPermissions.FlagCombo.TrueOrNone) || bl)) {
                stringBuilder.append("\n");
                object2 = claimedResidence.getAreaArray()[0];
                object = this.plugin.msg(lm.General_CoordsTop, ((CuboidArea)object2).getHighLoc().getBlockX(), ((CuboidArea)object2).getHighLoc().getBlockY(), ((CuboidArea)object2).getHighLoc().getBlockZ());
                string4 = this.plugin.msg(lm.General_CoordsBottom, ((CuboidArea)object2).getLowLoc().getBlockX(), ((CuboidArea)object2).getLowLoc().getBlockY(), ((CuboidArea)object2).getLowLoc().getBlockZ());
                string3 = CMIChatColor.translate(this.plugin.msg(lm.General_CoordsLiner, object, string4));
                stringBuilder.append(string3);
            }
            stringBuilder.append("\n").append(this.plugin.msg(lm.General_CreatedOn, GetTime.getTime(claimedResidence.getCreateTime())));
            object2 = "";
            if (claimedResidence.isForRent()) {
                if (claimedResidence.isRented()) {
                    object2 = " " + this.plugin.msg(lm.Residence_IsRented, new Object[0]);
                    stringBuilder.append("\n").append(this.plugin.msg(lm.Residence_RentedBy, claimedResidence.getRentedLand().player));
                } else {
                    object2 = " " + this.plugin.msg(lm.Residence_IsForRent, new Object[0]);
                }
                object = claimedResidence.getRentable();
                stringBuilder.append("\n").append(this.plugin.msg(lm.General_Cost, ((RentableLand)object).cost, ((RentableLand)object).days));
                stringBuilder.append("\n").append(this.plugin.msg(lm.Rentable_AllowRenewing, ((RentableLand)object).AllowRenewing));
                stringBuilder.append("\n").append(this.plugin.msg(lm.Rentable_StayInMarket, ((RentableLand)object).StayInMarket));
                stringBuilder.append("\n").append(this.plugin.msg(lm.Rentable_AllowAutoPay, ((RentableLand)object).AllowAutoPay));
            }
            if (claimedResidence.isForSell()) {
                object2 = " " + this.plugin.msg(lm.Residence_IsForSale, new Object[0]);
                stringBuilder.append("\n " + this.plugin.msg(lm.Economy_LandForSale, new Object[0]) + " " + claimedResidence.getSellPrice());
            }
            object = "";
            string4 = "";
            if (commandSender instanceof Player && !claimedResidence.isOwner(commandSender)) {
                object = claimedResidence.getPermissions().playerHas((Player)commandSender, Flags.tp, true) ? this.plugin.msg(lm.General_AllowedTeleportIcon, new Object[0]) : this.plugin.msg(lm.General_BlockedTeleportIcon, new Object[0]);
                string4 = claimedResidence.getPermissions().playerHas(commandSender.getName(), Flags.move, true) ? this.plugin.msg(lm.General_AllowedMovementIcon, new Object[0]) : this.plugin.msg(lm.General_BlockedMovementIcon, new Object[0]);
            }
            string3 = this.plugin.msg(lm.Residence_ResList, n3 + 1, claimedResidence.getName(), claimedResidence.getWorld(), String.valueOf(object) + string4, object2);
            RawMessage rawMessage = new RawMessage();
            if (commandSender instanceof Player) {
                rawMessage.addText(string3).addHover(stringBuilder.toString()).addCommand(String.valueOf(string2) + " tp " + claimedResidence.getName());
            } else {
                rawMessage.addText(String.valueOf(string3) + " " + stringBuilder.toString().replace("\n", ""));
            }
            rawMessage.show(commandSender);
        }
        if (string != null) {
            this.ShowPagination(commandSender, pageInfo, String.valueOf(string2) + " list " + string);
        } else {
            this.ShowPagination(commandSender, pageInfo, String.valueOf(string2) + " listall");
        }
    }

    private void printListWithDelay(final CommandSender commandSender, final TreeMap<String, ClaimedResidence> treeMap, final int n, final boolean bl) {
        int n2 = n;
        int n3 = 0;
        for (Map.Entry<String, ClaimedResidence> entry : treeMap.entrySet()) {
            Object object;
            Object object2;
            if (++n3 < n2) continue;
            if (++n2 >= n + 100 || treeMap.size() < n2) break;
            ClaimedResidence claimedResidence = entry.getValue();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.plugin.msg(lm.General_Owner, claimedResidence.getOwner()));
            if (claimedResidence.getAreaArray().length > 0 && (claimedResidence.getPermissions().has(Flags.hidden, FlagPermissions.FlagCombo.FalseOrNone) && claimedResidence.getPermissions().has(Flags.coords, FlagPermissions.FlagCombo.TrueOrNone) || bl)) {
                object2 = claimedResidence.getAreaArray()[0];
                object = this.plugin.msg(lm.General_CoordsTop, ((CuboidArea)object2).getHighLoc().getBlockX(), ((CuboidArea)object2).getHighLoc().getBlockY(), ((CuboidArea)object2).getHighLoc().getBlockZ());
                String string = this.plugin.msg(lm.General_CoordsBottom, ((CuboidArea)object2).getLowLoc().getBlockX(), ((CuboidArea)object2).getLowLoc().getBlockY(), ((CuboidArea)object2).getLowLoc().getBlockZ());
                String string2 = CMIChatColor.translate(this.plugin.msg(lm.General_CoordsLiner, object, string));
                stringBuilder.append("\n" + string2);
            }
            stringBuilder.append("\n" + this.plugin.msg(lm.General_CreatedOn, GetTime.getTime(claimedResidence.getCreateTime())));
            object2 = "";
            if (claimedResidence.isForRent()) {
                if (claimedResidence.isRented()) {
                    object2 = " " + this.plugin.msg(lm.Residence_IsRented, new Object[0]);
                    stringBuilder.append("\n " + this.plugin.msg(lm.Residence_RentedBy, claimedResidence.getRentedLand().player));
                } else {
                    object2 = " " + this.plugin.msg(lm.Residence_IsForRent, new Object[0]);
                }
                object = claimedResidence.getRentable();
                stringBuilder.append("\n" + this.plugin.msg(lm.General_Cost, ((RentableLand)object).cost, ((RentableLand)object).days));
                stringBuilder.append("\n" + this.plugin.msg(lm.Rentable_AllowRenewing, ((RentableLand)object).AllowRenewing));
                stringBuilder.append("\n" + this.plugin.msg(lm.Rentable_StayInMarket, ((RentableLand)object).StayInMarket));
                stringBuilder.append("\n" + this.plugin.msg(lm.Rentable_AllowAutoPay, ((RentableLand)object).AllowAutoPay));
            }
            if (claimedResidence.isForSell()) {
                object2 = " " + this.plugin.msg(lm.Residence_IsForSale, new Object[0]);
                stringBuilder.append("\n" + this.plugin.msg(lm.Economy_LandForSale, new Object[0]) + " " + claimedResidence.getSellPrice());
            }
            object = this.plugin.msg(lm.Residence_ResList, n2, claimedResidence.getName(), claimedResidence.getWorld(), "", object2);
            object = CMIChatColor.stripColor(String.valueOf(object) + " " + stringBuilder.toString().replace("\n", ""));
            object = ((String)object).replaceAll("\\s{2}", " ");
            commandSender.sendMessage((String)object);
        }
        if (treeMap.isEmpty()) {
            return;
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                InformationPager.this.printListWithDelay(commandSender, treeMap, n + 100, bl);
            }
        }, 5L);
    }

    private void printListToFile(final TreeMap<String, ClaimedResidence> treeMap, final boolean bl) {
        Bukkit.getConsoleSender().sendMessage("Saving");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Comparable<StringBuilder> comparable;
                Object object;
                int n = 0;
                StringBuilder stringBuilder = new StringBuilder();
                for (Map.Entry object22 : treeMap.entrySet()) {
                    Object object2;
                    Object iOException;
                    if (treeMap.size() < ++n) break;
                    object = (ClaimedResidence)object22.getValue();
                    comparable = new StringBuilder();
                    ((StringBuilder)comparable).append(" " + InformationPager.this.plugin.msg(lm.General_Owner, ((ClaimedResidence)object).getOwner()));
                    if (((ClaimedResidence)object).getAreaArray().length > 0 && (((ClaimedResidence)object).getPermissions().has(Flags.hidden, FlagPermissions.FlagCombo.FalseOrNone) && ((ClaimedResidence)object).getPermissions().has(Flags.coords, FlagPermissions.FlagCombo.TrueOrNone) || bl)) {
                        iOException = ((ClaimedResidence)object).getAreaArray()[0];
                        object2 = InformationPager.this.plugin.msg(lm.General_CoordsTop, ((CuboidArea)iOException).getHighLoc().getBlockX(), ((CuboidArea)iOException).getHighLoc().getBlockY(), ((CuboidArea)iOException).getHighLoc().getBlockZ());
                        String string = InformationPager.this.plugin.msg(lm.General_CoordsBottom, ((CuboidArea)iOException).getLowLoc().getBlockX(), ((CuboidArea)iOException).getLowLoc().getBlockY(), ((CuboidArea)iOException).getLowLoc().getBlockZ());
                        String string2 = CMIChatColor.translate(InformationPager.this.plugin.msg(lm.General_CoordsLiner, object2, string));
                        ((StringBuilder)comparable).append("\n" + string2);
                    }
                    ((StringBuilder)comparable).append("\n " + InformationPager.this.plugin.msg(lm.General_CreatedOn, GetTime.getTime(((ClaimedResidence)object).getCreateTime())));
                    iOException = "";
                    if (((ClaimedResidence)object).isForRent()) {
                        if (((ClaimedResidence)object).isRented()) {
                            iOException = " " + InformationPager.this.plugin.msg(lm.Residence_IsRented, new Object[0]);
                            ((StringBuilder)comparable).append("\n " + InformationPager.this.plugin.msg(lm.Residence_RentedBy, ((ClaimedResidence)object).getRentedLand().player));
                        } else {
                            iOException = " " + InformationPager.this.plugin.msg(lm.Residence_IsForRent, new Object[0]);
                        }
                        object2 = ((ClaimedResidence)object).getRentable();
                        ((StringBuilder)comparable).append("\n " + InformationPager.this.plugin.msg(lm.General_Cost, ((RentableLand)object2).cost, ((RentableLand)object2).days));
                        ((StringBuilder)comparable).append("\n " + InformationPager.this.plugin.msg(lm.Rentable_AllowRenewing, ((RentableLand)object2).AllowRenewing));
                        ((StringBuilder)comparable).append("\n " + InformationPager.this.plugin.msg(lm.Rentable_StayInMarket, ((RentableLand)object2).StayInMarket));
                        ((StringBuilder)comparable).append("\n " + InformationPager.this.plugin.msg(lm.Rentable_AllowAutoPay, ((RentableLand)object2).AllowAutoPay));
                    }
                    if (((ClaimedResidence)object).isForSell()) {
                        iOException = " " + InformationPager.this.plugin.msg(lm.Residence_IsForSale, new Object[0]);
                        ((StringBuilder)comparable).append("\n " + InformationPager.this.plugin.msg(lm.Economy_LandForSale, new Object[0]) + " " + ((ClaimedResidence)object).getSellPrice());
                    }
                    object2 = InformationPager.this.plugin.msg(lm.Residence_ResList, n, ((ClaimedResidence)object).getName(), ((ClaimedResidence)object).getWorld(), "", iOException);
                    object2 = CMIChatColor.stripColor(String.valueOf(object2) + " " + ((StringBuilder)comparable).toString().replace("\n", ""));
                    object2 = ((String)object2).replaceAll("\\s{2}", " ");
                    stringBuilder.append((String)object2);
                    stringBuilder.append(" \n");
                }
                File file = new File(Residence.getInstance().getDataLocation(), "FullLists");
                if (!file.isDirectory()) {
                    file.mkdir();
                }
                Date date = new Date();
                object = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
                comparable = new File(file, String.valueOf(((DateFormat)object).format(date)) + ".txt");
                try {
                    FileUtils.writeStringToFile((File)comparable, (String)stringBuilder.toString(), (String)"UTF-8");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                Bukkit.getConsoleSender().sendMessage("Saved file to FullLists folder with " + ((File)comparable).getName() + " name");
            }
        });
    }

    public void ShowPagination(CommandSender commandSender, PageInfo pageInfo, String string) {
        this.ShowPagination(commandSender, pageInfo, string, null);
    }

    public void ShowPagination(CommandSender commandSender, PageInfo pageInfo, Object object, String string) {
        this.ShowPagination(commandSender, pageInfo.getTotalPages(), pageInfo.getCurrentPage(), pageInfo.getTotalEntries(), String.valueOf(this.plugin.getCommandManager().getLabel()) + " " + object.getClass().getSimpleName(), string);
    }

    public void ShowPagination(CommandSender commandSender, PageInfo pageInfo, String string, String string2) {
        this.ShowPagination(commandSender, pageInfo.getTotalPages(), pageInfo.getCurrentPage(), pageInfo.getTotalEntries(), string, string2);
    }

    public void ShowPagination(CommandSender commandSender, int n, int n2, int n3, String string, String string2) {
        if (!(commandSender instanceof Player)) {
            return;
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (n == 1) {
            return;
        }
        String string3 = string2 == null ? "" : string2;
        int n4 = n2 + 1;
        n4 = n2 < n ? n4 : n2;
        int n5 = n2 - 1;
        n5 = n2 > 1 ? n5 : n2;
        RawMessage rawMessage = new RawMessage();
        rawMessage.addText(n2 > 1 ? this.plugin.msg(lm.General_prevPage, new Object[0]) : this.plugin.msg(lm.General_prevPageOff, new Object[0])).addHover(n2 > 1 ? this.plugin.msg(lm.General_prevPageHover, new Object[0]) : this.plugin.msg(lm.General_lastPageHover, new Object[0])).addCommand(n2 > 1 ? String.valueOf(string) + " " + string3 + n5 : String.valueOf(string) + " " + string3 + n);
        rawMessage.addText(this.plugin.msg(lm.General_pageCount, n2, n)).addHover(this.plugin.msg(lm.General_pageCountHover, n3));
        rawMessage.addText(this.plugin.msg(n > n2 ? lm.General_nextPage : lm.General_nextPageOff, new Object[0])).addHover(n > n2 ? this.plugin.msg(lm.General_nextPageHover, new Object[0]) : this.plugin.msg(lm.General_firstPageHover, new Object[0])).addCommand(n > n2 ? String.valueOf(string) + " " + string3 + n4 : String.valueOf(string) + " " + string3 + 1);
        if (n != 0) {
            rawMessage.show(commandSender);
        }
    }
}

