/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.text.help;

import com.bekvon.bukkit.cmiLib.CMIChatColor;
import com.bekvon.bukkit.cmiLib.RawMessage;
import com.bekvon.bukkit.cmiLib.Version;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.ResidenceCommandListener;
import com.bekvon.bukkit.residence.commands.pset;
import com.bekvon.bukkit.residence.commands.set;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.HelpLines;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.text.help.PageInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class HelpEntry {
    protected String name;
    protected String desc;
    protected String[] lines;
    protected List<HelpEntry> subentrys;
    protected static int linesPerPage = 8;
    File langFile = new File(new File(Residence.getInstance().getDataLocation(), "Language"), "English.yml");

    public HelpEntry(String string) {
        this.name = string;
        this.subentrys = new ArrayList<HelpEntry>();
        this.lines = new String[0];
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDescription(String string) {
        this.desc = string;
    }

    public String getDescription() {
        if (this.desc == null) {
            return "";
        }
        return this.desc;
    }

    public void printHelp(CommandSender commandSender, int n, boolean bl, String string) {
        Object object;
        List<HelpLines> list2 = this.getHelpData(commandSender, bl);
        string = "/" + string.replace(".", " ") + " ";
        PageInfo pageInfo = new PageInfo(linesPerPage, list2.size(), n);
        if (!pageInfo.isPageOk()) {
            Residence.getInstance().msg(commandSender, lm.Invalid_Help, new Object[0]);
            return;
        }
        int n2 = pageInfo.getStart();
        while (n2 <= pageInfo.getEnd()) {
            if (list2.get(n2).getCommand() != null) {
                Object object2;
                object = this.getSubEntry(list2.get(n2).getCommand());
                String string2 = "&6";
                int n3 = 0;
                String[] stringArray = ((HelpEntry)object).lines;
                int n4 = ((HelpEntry)object).lines.length;
                int n5 = 0;
                while (n5 < n4) {
                    object2 = stringArray[n5];
                    string2 = String.valueOf(string2) + (String)object2;
                    if (++n3 < ((HelpEntry)object).lines.length) {
                        string2 = String.valueOf(string2) + "\n";
                    }
                    ++n5;
                }
                if (bl) {
                    string = string.replace("/res ", "/resadmin ");
                }
                object2 = new RawMessage();
                ((RawMessage)object2).add(CMIChatColor.translate("&6" + list2.get(n2).getDesc()), string2, null, String.valueOf(string) + list2.get(n2).getCommand());
                ((RawMessage)object2).show(commandSender);
            } else {
                commandSender.sendMessage(CMIChatColor.translate("&6" + list2.get(n2).getDesc()));
            }
            ++n2;
        }
        String string3 = bl ? "resadmin" : "res";
        object = !this.name.equalsIgnoreCase("res") ? "/" + string3 + " " + this.name + " ? " : "/" + string3 + " ? ";
        Residence.getInstance().getInfoPageManager().ShowPagination(commandSender, pageInfo, (String)object);
    }

    public void printHelp(CommandSender commandSender, int n, String string, boolean bl) {
        HelpEntry helpEntry = this.getSubEntry(string);
        if (helpEntry != null) {
            helpEntry.printHelp(commandSender, n, bl, string);
        } else {
            Residence.getInstance().msg(commandSender, lm.Invalid_Help, new Object[0]);
        }
    }

    private List<HelpLines> getHelpData(CommandSender commandSender, boolean bl) {
        Object object;
        ArrayList<HelpLines> arrayList = new ArrayList<HelpLines>();
        String[] stringArray = this.lines;
        int n = this.lines.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray[n2];
            arrayList.add(new HelpLines(null, (String)object));
            ++n2;
        }
        object = Residence.getInstance().getPermissionManager().getAllFlags();
        Map<String, String> map = new HashMap<String, String>();
        for (HelpEntry helpEntry : this.subentrys) {
            block17: {
                block16: {
                    if (this.name.equalsIgnoreCase("flags")) break block16;
                    if (ResidenceCommandListener.getAdminCommands().contains(helpEntry.getName().toLowerCase()) && !bl || !ResidenceCommandListener.getAdminCommands().contains(helpEntry.getName().toLowerCase()) && bl) {
                        continue;
                    }
                    break block17;
                }
                if (!((FlagPermissions)object).getFlags().containsKey(helpEntry.getName().toLowerCase())) break block17;
                Boolean bl2 = ((FlagPermissions)object).getFlags().get(helpEntry.getName().toLowerCase());
                if (!bl2.booleanValue() && !bl && !PermissionManager.ResPerm.flag_$1.hasPermission(commandSender, helpEntry.getName().toLowerCase())) continue;
                String string = helpEntry.getName();
                Flags flags2 = Flags.getFlag(helpEntry.getName());
                if (flags2 != null) {
                    string = flags2.getName();
                }
                String string2 = helpEntry.getDescription();
                switch (helpEntry.getName().toLowerCase()) {
                    case "wspeed1": {
                        string2 = string2.replace("%1", "" + Residence.getInstance().getConfigManager().getWalkSpeed1());
                        break;
                    }
                    case "wspeed2": {
                        string2 = string2.replace("%1", "" + Residence.getInstance().getConfigManager().getWalkSpeed2());
                    }
                }
                map.put(helpEntry.getName(), Residence.getInstance().msg(lm.InformationPage_FlagsList, string, string2));
                continue;
            }
            arrayList.add(new HelpLines(helpEntry.getName(), Residence.getInstance().msg(lm.InformationPage_GeneralList, helpEntry.getName(), helpEntry.getDescription())));
        }
        if (!map.isEmpty()) {
            map = Residence.getInstance().getSortingManager().sortStringByKeyASC(map);
            for (Map.Entry entry : map.entrySet()) {
                arrayList.add(new HelpLines((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        return arrayList;
    }

    public boolean containesEntry(String string) {
        return this.getSubEntry(string) != null;
    }

    public HelpEntry getSubEntry(String string) {
        String[] stringArray = string.split("\\.");
        HelpEntry helpEntry = this;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if ((helpEntry = helpEntry.findSubEntry(string2)) == null) {
                return null;
            }
            ++n2;
        }
        return helpEntry;
    }

    private HelpEntry findSubEntry(String string) {
        for (HelpEntry helpEntry : this.subentrys) {
            if (!helpEntry.getName().equalsIgnoreCase(string)) continue;
            return helpEntry;
        }
        return null;
    }

    public void addSubEntry(HelpEntry helpEntry) {
        if (!this.subentrys.contains(helpEntry)) {
            this.subentrys.add(helpEntry);
        }
    }

    public void removeSubEntry(HelpEntry helpEntry) {
        if (this.subentrys.contains(helpEntry)) {
            this.subentrys.remove(helpEntry);
        }
    }

    public int getSubEntryCount() {
        return this.subentrys.size();
    }

    public static HelpEntry parseHelp(FileConfiguration fileConfiguration, String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray[stringArray.length - 1];
        HelpEntry helpEntry = new HelpEntry(string2);
        ConfigurationSection configurationSection = fileConfiguration.getConfigurationSection(string);
        Set set2 = null;
        if (configurationSection != null) {
            set2 = configurationSection.getKeys(false);
        }
        if (set2 != null) {
            Collection<String> collection;
            if (set2.contains("Info") && (collection = fileConfiguration.getStringList(String.valueOf(string) + ".Info")) != null) {
                helpEntry.lines = new String[collection.size()];
                int n = 0;
                while (n < collection.size()) {
                    helpEntry.lines[n] = CMIChatColor.translate((String)collection.get(n));
                    ++n;
                }
            }
            if (set2.contains("Description")) {
                helpEntry.desc = fileConfiguration.getString(String.valueOf(string) + ".Description");
            }
            if (set2.contains("SubCommands")) {
                collection = fileConfiguration.getConfigurationSection(String.valueOf(string) + ".SubCommands").getKeys(false);
                if (string.equalsIgnoreCase("CommandHelp.SubCommands.res")) {
                    collection.clear();
                    for (String string3 : Residence.getInstance().getCommandFiller().getCommands()) {
                        collection.add(string3);
                    }
                }
                for (String string4 : collection) {
                    helpEntry.subentrys.add(HelpEntry.parseHelp(fileConfiguration, String.valueOf(string) + ".SubCommands." + string4));
                }
            }
        }
        return helpEntry;
    }

    public Set<String> getSubCommands(CommandSender commandSender, String[] stringArray) {
        boolean bl;
        ConfigurationSection configurationSection;
        HashSet<String> hashSet;
        block68: {
            List<String> list2;
            Map.Entry<List<String>, List<String>> entry22;
            hashSet = new HashSet<String>();
            if (!this.langFile.isFile()) {
                return hashSet;
            }
            YamlConfiguration yamlConfiguration = new YamlConfiguration();
            try {
                yamlConfiguration.load(this.langFile);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            configurationSection = yamlConfiguration.getConfigurationSection("CommandHelp.SubCommands.res.SubCommands");
            if (stringArray.length == 1) {
                if (configurationSection == null) {
                    return hashSet;
                }
                return configurationSection.getKeys(false);
            }
            boolean bl2 = true;
            int n = 0;
            while (bl2) {
                if (n >= stringArray.length) break;
                if (stringArray[n].equalsIgnoreCase("")) {
                    return configurationSection == null ? hashSet : configurationSection.getKeys(false);
                }
                if (configurationSection != null && !configurationSection.isConfigurationSection(String.valueOf(stringArray[n]) + ".SubCommands")) break;
                if (configurationSection != null) {
                    configurationSection = configurationSection.getConfigurationSection(String.valueOf(stringArray[n]) + ".SubCommands");
                }
                ++n;
            }
            int n2 = stringArray.length - 2 - n;
            bl = true;
            if (n < stringArray.length && configurationSection != null && configurationSection.isConfigurationSection(stringArray[n])) {
                bl = false;
                configurationSection = configurationSection.getConfigurationSection(stringArray[n]);
            }
            List list3 = new ArrayList();
            int n3 = 0;
            for (Map.Entry<List<String>, List<String>> entry22 : Residence.getInstance().getLocaleManager().CommandTab.entrySet()) {
                list2 = entry22.getKey();
                if (list2.size() > n3 && stringArray.length > n3 && list2.get(n3).equalsIgnoreCase(stringArray[n3])) {
                    list3 = (List)entry22.getValue();
                }
                ++n;
            }
            entry22 = null;
            if (n2 < list3.size() && n2 >= 0) {
                entry22 = (String)list3.get(n2);
            }
            Player player = null;
            if (commandSender instanceof Player) {
                player = (Player)commandSender;
            }
            if (entry22 == null) break block68;
            list2 = new ArrayList<String>();
            if (((String)((Object)entry22)).contains("%%")) {
                list2.addAll(Arrays.asList(((String)((Object)entry22)).split("%%")));
            } else {
                list2.add((String)((Object)entry22));
            }
            Iterator<String> iterator = list2.iterator();
            block28: while (iterator.hasNext()) {
                String string;
                switch (string = iterator.next()) {
                    case "[playername]": {
                        Object object22;
                        for (Object object22 : Bukkit.getOnlinePlayers()) {
                            if (player != null && !object22.canSee(player)) continue;
                            hashSet.add(object22.getName());
                        }
                        continue block28;
                    }
                    case "[residence]": {
                        Object object22;
                        if (commandSender instanceof Player) {
                            String string2;
                            object22 = Residence.getInstance().getResidenceManager().getByLoc(((Player)commandSender).getLocation());
                            if (object22 != null && (string2 = ((ClaimedResidence)object22).getName()) != null) {
                                hashSet.add(string2);
                            }
                            List<ClaimedResidence> list4 = Residence.getInstance().getPlayerManager().getResidencePlayer((Player)commandSender).getResList();
                            for (ClaimedResidence claimedResidence : list4) {
                                hashSet.add(claimedResidence.getName());
                            }
                            continue block28;
                        }
                        object22 = Residence.getInstance().getResidenceManager().getResidenceList(Residence.getInstance().getServerLandName(), true, false, false);
                        if (((ArrayList)object22).size() <= 0) continue block28;
                        hashSet.addAll((Collection<String>)object22);
                        break;
                    }
                    case "[cresidence]": {
                        String string3;
                        Object object22;
                        if (!(commandSender instanceof Player) || (object22 = Residence.getInstance().getResidenceManager().getByLoc(((Player)commandSender).getLocation())) == null || (string3 = ((ClaimedResidence)object22).getName()) == null) continue block28;
                        hashSet.add(string3);
                        break;
                    }
                    case "[enter]": {
                        String string4;
                        Object object22;
                        if (!(commandSender instanceof Player) || (object22 = Residence.getInstance().getResidenceManager().getByLoc(((Player)commandSender).getLocation())) == null || (string4 = ((ClaimedResidence)object22).getEnterMessage()) == null) continue block28;
                        hashSet.add(CMIChatColor.deColorize(string4));
                        break;
                    }
                    case "[leave]": {
                        String string5;
                        Object object22;
                        if (!(commandSender instanceof Player) || (object22 = Residence.getInstance().getResidenceManager().getByLoc(((Player)commandSender).getLocation())) == null || (string5 = ((ClaimedResidence)object22).getLeaveMessage()) == null) continue block28;
                        hashSet.add(CMIChatColor.deColorize(string5));
                        break;
                    }
                    case "[residenceshop]": {
                        Object object22;
                        for (Object object22 : Residence.getInstance().getResidenceManager().getShops()) {
                            hashSet.add(((ClaimedResidence)object22).getName());
                        }
                        continue block28;
                    }
                    case "[flag]": {
                        Object object22 = Flags.FlagMode.Both;
                        if (stringArray.length > 0) {
                            if (stringArray[0].equalsIgnoreCase(set.class.getSimpleName())) {
                                object22 = Flags.FlagMode.Residence;
                            } else if (stringArray[0].equalsIgnoreCase(pset.class.getSimpleName())) {
                                object22 = Flags.FlagMode.Player;
                            }
                        }
                        for (String string6 : FlagPermissions.getAllPosibleFlags()) {
                            Flags flags2 = Flags.getFlag(string6);
                            if (flags2 != null) {
                                if (flags2.getFlagMode() != Flags.FlagMode.Both && flags2.getFlagMode() != object22 || !flags2.isGlobalyEnabled()) continue;
                                hashSet.add(flags2.getName());
                            }
                            hashSet.add(string6);
                        }
                        for (String string7 : FlagPermissions.getPosibleAreaFlags()) {
                            Flags flags3 = Flags.getFlag(string7);
                            if (flags3 != null) {
                                if (flags3.getFlagMode() != Flags.FlagMode.Both && flags3.getFlagMode() != object22 || !flags3.isGlobalyEnabled()) continue;
                                hashSet.add(flags3.getName());
                            }
                            hashSet.add(string7);
                        }
                        continue block28;
                    }
                    case "[material]": {
                        Material[] materialArray = Material.values();
                        int n4 = materialArray.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            Material material2 = materialArray[n5];
                            hashSet.add(material2.name().toLowerCase());
                            ++n5;
                        }
                        continue block28;
                    }
                    case "[materialId]": {
                        if (!Version.isCurrentEqualOrLower(Version.v1_13_R2)) continue block28;
                        Material[] materialArray = Material.values();
                        int n6 = materialArray.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            Material material3 = materialArray[n7];
                            hashSet.add(String.valueOf(material3.getId()));
                            ++n7;
                        }
                        continue block28;
                    }
                    case "[worldname]": {
                        for (World world : Bukkit.getWorlds()) {
                            hashSet.add(world.getName());
                        }
                        continue block28;
                    }
                    default: {
                        hashSet.add(string);
                    }
                }
            }
        }
        if (!hashSet.isEmpty()) {
            return hashSet;
        }
        if (bl) {
            return configurationSection == null ? hashSet : configurationSection.getKeys(false);
        }
        return new HashSet<String>(Arrays.asList("?"));
    }
}

