/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.signsStuff;

import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.residence.CommentedYamlConfiguration;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.rent.RentedLand;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.signsStuff.SignInfo;
import com.bekvon.bukkit.residence.signsStuff.Signs;
import com.bekvon.bukkit.residence.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class SignUtil {
    private Residence plugin;
    public SignInfo Signs = new SignInfo();

    public SignUtil(Residence residence) {
        this.plugin = residence;
    }

    public SignInfo getSigns() {
        return this.Signs;
    }

    public int updateAllSigns() {
        ConcurrentHashMap<String, Signs> concurrentHashMap = new ConcurrentHashMap<String, Signs>();
        concurrentHashMap.putAll(this.Signs.GetAllSigns());
        for (Map.Entry entry : concurrentHashMap.entrySet()) {
            this.SignUpdate((Signs)entry.getValue());
        }
        this.saveSigns();
        return concurrentHashMap.size();
    }

    public void LoadSigns() {
        this.Signs.GetAllSigns().clear();
        File file = new File(this.plugin.getDataFolder(), "Signs.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        if (!yamlConfiguration.isConfigurationSection("Signs")) {
            return;
        }
        ConfigurationSection configurationSection = yamlConfiguration.getConfigurationSection("Signs");
        ArrayList arrayList = new ArrayList(configurationSection.getKeys(false));
        if (arrayList.size() == 0) {
            return;
        }
        for (String string : arrayList) {
            World world;
            ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string);
            Signs signs = new Signs();
            ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(configurationSection2.contains("Residence") ? configurationSection2.getString("Residence") : configurationSection2.getString("Res"));
            if (claimedResidence == null) continue;
            signs.setResidence(claimedResidence);
            if (configurationSection2.contains("World")) {
                world = Bukkit.getWorld((String)configurationSection2.getString("World"));
                if (world == null) continue;
                double d = configurationSection2.getDouble("X");
                double d2 = configurationSection2.getDouble("Y");
                double d3 = configurationSection2.getDouble("Z");
                Location location = new Location(world, d, d2, d3);
                signs.setLocation(location);
            } else {
                world = Utils.convertStringToLocation(configurationSection2.getString("Loc"));
                signs.setLocation((Location)world);
            }
            this.Signs.addSign(signs);
        }
    }

    public void saveSigns() {
        File file = new File(this.plugin.getDataFolder(), "Signs.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        CommentedYamlConfiguration commentedYamlConfiguration = new CommentedYamlConfiguration();
        yamlConfiguration.options().copyDefaults(true);
        commentedYamlConfiguration.addComment("Signs", "DO NOT EDIT THIS FILE BY HAND!");
        if (!yamlConfiguration.isConfigurationSection("Signs")) {
            yamlConfiguration.createSection("Signs");
        }
        int n = 0;
        for (Map.Entry<String, Signs> entry : new ConcurrentHashMap<String, Signs>(this.Signs.GetAllSigns()).entrySet()) {
            Signs signs = entry.getValue();
            String string = "Signs." + ++n;
            commentedYamlConfiguration.set(String.valueOf(string) + ".Res", signs.getResidence().getName());
            commentedYamlConfiguration.set(String.valueOf(string) + ".Loc", Utils.convertLocToStringTiny(signs.getLocation()));
        }
        try {
            commentedYamlConfiguration.save(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Signs getSignFromLoc(Location location) {
        return this.getSigns().getResSign(location);
    }

    public void CheckSign(final ClaimedResidence claimedResidence, int n) {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                SignUtil.this.CheckSign(claimedResidence);
            }
        }, (long)n * 1L);
    }

    public void CheckSign(ClaimedResidence claimedResidence) {
        for (Signs signs : claimedResidence.getSignsInResidence()) {
            if (claimedResidence != signs.GetResidence()) continue;
            this.SignUpdate(signs);
        }
        this.saveSigns();
    }

    @Deprecated
    public void removeSign(String string) {
        if (string != null) {
            this.removeSign(this.plugin.getResidenceManager().getByName(string));
        }
    }

    public void removeSign(ClaimedResidence claimedResidence) {
        for (Signs signs : claimedResidence.getSignsInResidence()) {
            if (claimedResidence != signs.getResidence()) continue;
            this.SignUpdate(signs);
        }
    }

    public void updateSignResName(ClaimedResidence claimedResidence) {
        for (Signs signs : claimedResidence.getSignsInResidence()) {
            if (claimedResidence != signs.getResidence()) continue;
            this.SignUpdate(signs);
            this.saveSigns();
            break;
        }
    }

    public boolean SignUpdate(Signs signs) {
        Object object;
        ClaimedResidence claimedResidence = signs.getResidence();
        if (claimedResidence == null) {
            return false;
        }
        boolean bl = claimedResidence.isForSell();
        boolean bl2 = claimedResidence.isForRent();
        Location location = signs.getLocation();
        if (location == null) {
            this.Signs.removeSign(signs);
            claimedResidence.getSignsInResidence().remove(signs);
            return false;
        }
        Block block = location.getBlock();
        if (!CMIMaterial.isSign(block.getType())) {
            this.Signs.removeSign(signs);
            claimedResidence.getSignsInResidence().remove(signs);
            return false;
        }
        Sign sign = (Sign)block.getState();
        String string = claimedResidence.getName();
        if (string == null) {
            return false;
        }
        if (!bl2 && !bl) {
            String string2 = this.fixResName(string);
            String string3 = null;
            if (string2.contains("~")) {
                String[] stringArray = this.fixDoubleResName(string);
                string2 = stringArray[0];
                string3 = stringArray[1];
            }
            sign.setLine(0, this.plugin.msg(lm.Sign_ResName, string2));
            if (string3 != null) {
                sign.setLine(1, this.plugin.msg(lm.Sign_ResName, string3));
            }
            sign.setLine(2, "");
            sign.setLine(3, "");
            sign.setLine(string3 == null ? 1 : 2, this.plugin.msg(lm.Sign_Owner, claimedResidence.getOwner()));
            sign.update();
            return true;
        }
        if (bl2) {
            String string4;
            boolean bl3 = claimedResidence.isRented();
            object = claimedResidence.getRentedLand();
            long l = 0L;
            if (object != null) {
                l = ((RentedLand)object).endTime;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.plugin.msg(lm.Sign_DateFormat, new Object[0]));
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.plugin.getConfigManager().getTimeZone()));
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l);
            String string5 = string4 = simpleDateFormat.format(calendar.getTime());
            if (l == 0L) {
                string5 = "Unknown";
            }
            string5 = this.plugin.getRentManager().getRentedAutoRepeats(claimedResidence) ? this.plugin.msg(lm.Sign_RentedAutorenewTrue, string5) : this.plugin.msg(lm.Sign_RentedAutorenewFalse, string5);
            String string6 = bl3 ? this.plugin.msg(lm.Sign_RentedTopLine, string5) : this.plugin.msg(lm.Sign_ForRentTopLine, new Object[0]);
            sign.setLine(0, string6);
            String string7 = this.plugin.msg(bl3 ? lm.Sign_RentedPriceLine : lm.Sign_ForRentPriceLine, this.plugin.getRentManager().getCostOfRent(claimedResidence), this.plugin.getRentManager().getRentDays(claimedResidence), this.plugin.getRentManager().getRentableRepeatable(claimedResidence));
            sign.setLine(1, string7);
            String string8 = this.fixResName(string);
            sign.setLine(2, bl3 ? this.plugin.msg(lm.Sign_RentedResName, string8) : this.plugin.msg(lm.Sign_RentedResName, string8));
            sign.setLine(3, bl3 ? this.plugin.msg(lm.Sign_RentedBottomLine, this.plugin.getRentManager().getRentingPlayer(string)) : this.plugin.msg(lm.Sign_ForRentBottomLine, new Object[0]));
            sign.update();
        }
        if (bl) {
            String string9 = this.fixResName(string);
            object = null;
            if (string9.contains("~")) {
                String[] stringArray = this.fixDoubleResName(string);
                string9 = stringArray[0];
                object = stringArray[1];
            }
            sign.setLine(0, this.plugin.msg(lm.Sign_ForSaleTopLine, new Object[0]));
            String string10 = this.plugin.msg(lm.Sign_ForSalePriceLine, claimedResidence.getSellPrice());
            sign.setLine(1, string10);
            sign.setLine(2, this.plugin.msg(lm.Sign_RentedResName, string9));
            if (object != null) {
                sign.setLine(3, this.plugin.msg(lm.Sign_RentedResName, object));
            } else {
                sign.setLine(3, this.plugin.msg(lm.Sign_ForSaleBottom, claimedResidence.getTotalSize()));
            }
            sign.update();
        }
        return true;
    }

    public void convertSigns(CommandSender commandSender) {
        File file = new File("plugins/ResidenceSigns/signs.yml");
        if (!file.exists()) {
            commandSender.sendMessage(ChatColor.GOLD + "Can't find ResidenceSign file");
            return;
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        if (!yamlConfiguration.contains("signs")) {
            commandSender.sendMessage(ChatColor.GOLD + "Incorrect format of signs file");
            return;
        }
        Set set2 = yamlConfiguration.getConfigurationSection("signs").getKeys(false);
        ConfigurationSection configurationSection = yamlConfiguration.getConfigurationSection("signs");
        long l = System.currentTimeMillis();
        int n = 0;
        for (String string : set2) {
            Location location;
            Block block;
            World world;
            Signs signs = new Signs();
            String string2 = configurationSection.getString(String.valueOf(string) + ".resName");
            ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string2);
            if (claimedResidence == null) continue;
            signs.setResidence(claimedResidence);
            List list2 = configurationSection.getStringList(String.valueOf(string) + ".loc");
            if (list2.size() != 4 || (world = Bukkit.getWorld((String)((String)list2.get(0)))) == null) continue;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            try {
                n2 = Integer.parseInt((String)list2.get(1));
                n3 = Integer.parseInt((String)list2.get(2));
                n4 = Integer.parseInt((String)list2.get(3));
            }
            catch (Exception exception) {
                continue;
            }
            signs.setLocation(new Location(world, (double)n2, (double)n3, (double)n4));
            Signs signs2 = this.getSigns().getResSign(signs.GetLocation());
            if (signs2 == null || !((block = (location = signs.GetLocation()).getBlock()).getState() instanceof Sign)) continue;
            this.getSigns().addSign(signs);
            this.SignUpdate(signs);
            ++n;
        }
        this.saveSigns();
        commandSender.sendMessage(ChatColor.GOLD + n + ChatColor.YELLOW + " signs have being converted to new format! It took " + ChatColor.GOLD + (System.currentTimeMillis() - l) + ChatColor.YELLOW + " ms!");
    }

    public String fixResName(String string) {
        if (string.length() > 15 && !string.contains(".")) {
            string = "~" + string.substring(string.length() - 14);
        } else if (string.length() > 15 && string.contains(".")) {
            String[] stringArray = string.split("\\.");
            string = "";
            int n = 0;
            while (n < stringArray.length) {
                String string2 = String.valueOf(string) + "." + stringArray[n];
                string = string2.length() < 15 ? string2 : "~" + string2.substring(string2.length() - 14);
                ++n;
            }
        }
        return string;
    }

    public String[] fixDoubleResName(String string) {
        String[] stringArray;
        String string2 = string.substring(string.length() - 15);
        String string3 = string.replace(string2, "");
        if (string3.length() > 15 && !string3.contains(".")) {
            string3 = "~" + string3.substring(string.length() - 14);
        } else if (string3.length() > 15 && string3.contains(".")) {
            stringArray = string3.split("\\.");
            string3 = "";
            int n = 0;
            while (n < stringArray.length) {
                String string4 = String.valueOf(string3) + "." + stringArray[n];
                string3 = string4.length() < 15 ? string4 : "~" + string4.substring(string4.length() - 14);
                ++n;
            }
        }
        stringArray = new String[]{string3, string2};
        return stringArray;
    }
}

