/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.shopStuff;

import com.bekvon.bukkit.residence.CommentedYamlConfiguration;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.shopStuff.Board;
import com.bekvon.bukkit.residence.shopStuff.ShopVote;
import com.bekvon.bukkit.residence.shopStuff.Vote;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ShopSignUtil {
    List<Board> AllBoards = new ArrayList<Board>();
    private Residence plugin;

    public ShopSignUtil(Residence residence) {
        this.plugin = residence;
    }

    public void setAllSigns(List<Board> list2) {
        this.AllBoards = list2;
    }

    public List<Board> GetAllBoards() {
        return this.AllBoards;
    }

    public void removeBoard(Board board) {
        this.AllBoards.remove(board);
    }

    public void addBoard(Board board) {
        this.AllBoards.add(board);
    }

    public boolean exist(Board board) {
        List<Location> list2 = board.GetLocations();
        for (Board board2 : this.AllBoards) {
            List<Location> list3 = board2.GetLocations();
            for (Location location : list3) {
                if (!list2.contains(location)) continue;
                return true;
            }
        }
        return false;
    }

    public void LoadShopVotes() {
        File file = new File(this.plugin.getDataFolder(), "ShopVotes.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
        if (!yamlConfiguration.isConfigurationSection("ShopVotes")) {
            return;
        }
        ConfigurationSection configurationSection = yamlConfiguration.getConfigurationSection("ShopVotes");
        ArrayList arrayList = new ArrayList(configurationSection.getKeys(false));
        if (arrayList.size() == 0) {
            return;
        }
        for (String string : arrayList) {
            Object object2;
            List list2 = configurationSection.getStringList(string);
            ArrayList<ShopVote> arrayList2 = new ArrayList<ShopVote>();
            for (Object object2 : list2) {
                if (!((String)object2).contains("%")) continue;
                String string2 = ((String)object2).split("%")[0];
                UUID uUID = null;
                if (string2.contains(":")) {
                    try {
                        uUID = UUID.fromString(string2.split(":")[1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    string2 = string2.split(":")[0];
                }
                int n = -1;
                try {
                    String string3 = ((String)object2).split("%")[1];
                    if (string3.contains("!")) {
                        string3 = ((String)object2).split("%")[1].split("!")[0];
                    }
                    n = Integer.parseInt(string3);
                }
                catch (Exception exception) {
                    continue;
                }
                if (n < 0) {
                    n = 0;
                } else if (n > 10) {
                    n = 10;
                }
                long l = 0L;
                if (((String)object2).contains("!")) {
                    try {
                        l = Long.parseLong(((String)object2).split("!")[1]);
                    }
                    catch (Exception exception) {
                        l = System.currentTimeMillis();
                    }
                }
                arrayList2.add(new ShopVote(string2, uUID, n, l));
            }
            object2 = this.plugin.getResidenceManager().getByName(string.replace("_", "."));
            if (object2 == null) continue;
            ((ClaimedResidence)object2).clearShopVotes();
            ((ClaimedResidence)object2).addShopVote(arrayList2);
        }
    }

    public void saveShopVotes() {
        File file = new File(this.plugin.getDataFolder(), "ShopVotes.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        CommentedYamlConfiguration commentedYamlConfiguration = new CommentedYamlConfiguration();
        yamlConfiguration.options().copyDefaults(true);
        commentedYamlConfiguration.addComment("ShopVotes", "DO NOT EDIT THIS FILE BY HAND!");
        if (!yamlConfiguration.isConfigurationSection("ShopVotes")) {
            yamlConfiguration.createSection("ShopVotes");
        }
        for (ClaimedResidence claimedResidence : this.plugin.getResidenceManager().getShops()) {
            if (claimedResidence == null || claimedResidence.GetShopVotes().isEmpty()) continue;
            String string = "ShopVotes." + claimedResidence.getName().replace(".", "_");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ShopVote shopVote : claimedResidence.GetShopVotes()) {
                arrayList.add(String.valueOf(shopVote.getName()) + ":" + shopVote.getUuid().toString() + "%" + shopVote.getVote() + "!" + shopVote.getTime());
            }
            commentedYamlConfiguration.set(string, arrayList);
        }
        try {
            commentedYamlConfiguration.save(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Vote getAverageVote(String string) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        return this.getAverageVote(claimedResidence);
    }

    public Vote getAverageVote(ClaimedResidence claimedResidence) {
        if (claimedResidence == null || claimedResidence.GetShopVotes().isEmpty()) {
            return new Vote(this.plugin.getConfigManager().getVoteRangeTo() / 2, 0);
        }
        List<ShopVote> list2 = claimedResidence.GetShopVotes();
        double d = 0.0;
        for (ShopVote shopVote : list2) {
            d += (double)shopVote.getVote();
        }
        double d2 = (double)((int)(d / (double)list2.size() * 100.0)) / 100.0;
        return new Vote(d2, list2.size());
    }

    public int getLikes(String string) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        return this.getLikes(claimedResidence);
    }

    public int getLikes(ClaimedResidence claimedResidence) {
        if (claimedResidence == null || claimedResidence.GetShopVotes().isEmpty()) {
            return 0;
        }
        List<ShopVote> list2 = claimedResidence.GetShopVotes();
        int n = 0;
        for (ShopVote shopVote : list2) {
            if (shopVote.getVote() < this.plugin.getConfigManager().getVoteRangeTo() / 2) continue;
            ++n;
        }
        return n;
    }

    public Map<String, Double> getSortedShopList() {
        Map<String, Double> map = new HashMap<String, Double>();
        List<ClaimedResidence> list2 = this.plugin.getResidenceManager().getShops();
        for (ClaimedResidence claimedResidence : list2) {
            if (this.plugin.getConfigManager().isOnlyLike()) {
                map.put(claimedResidence.getName(), Double.valueOf(this.getLikes(claimedResidence)));
                continue;
            }
            map.put(claimedResidence.getName(), this.getAverageVote(claimedResidence).getVote());
        }
        map = ShopSignUtil.sortByComparator(map);
        return map;
    }

    private static Map<String, Double> sortByComparator(Map<String, Double> map) {
        LinkedList<Map.Entry<String, Double>> linkedList = new LinkedList<Map.Entry<String, Double>>(map.entrySet());
        Collections.sort(linkedList, new Comparator<Map.Entry<String, Double>>(){

            @Override
            public int compare(Map.Entry<String, Double> entry, Map.Entry<String, Double> entry2) {
                return entry2.getValue().compareTo(entry.getValue());
            }
        });
        LinkedHashMap<String, Double> linkedHashMap = new LinkedHashMap<String, Double>();
        for (Map.Entry entry : linkedList) {
            linkedHashMap.put((String)entry.getKey(), (Double)entry.getValue());
        }
        return linkedHashMap;
    }

    public void LoadSigns() {
        this.GetAllBoards().clear();
        File file = new File(this.plugin.getDataFolder(), "ShopSigns.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        if (!yamlConfiguration.isConfigurationSection("ShopSigns")) {
            return;
        }
        ConfigurationSection configurationSection = yamlConfiguration.getConfigurationSection("ShopSigns");
        ArrayList arrayList = new ArrayList(configurationSection.getKeys(false));
        if (arrayList.size() == 0) {
            return;
        }
        for (String string : arrayList) {
            ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string);
            Board board = new Board();
            board.setStartPlace(configurationSection2.getInt("StartPlace"));
            World world = Bukkit.getWorld((String)configurationSection2.getString("World"));
            if (world == null) continue;
            Location location = new Location(world, (double)configurationSection2.getInt("TX"), (double)configurationSection2.getInt("TY"), (double)configurationSection2.getInt("TZ"));
            Location location2 = new Location(world, (double)configurationSection2.getInt("BX"), (double)configurationSection2.getInt("BY"), (double)configurationSection2.getInt("BZ"));
            board.setTopLoc(location);
            board.setBottomLoc(location2);
            this.addBoard(board);
        }
    }

    public void saveSigns() {
        File file = new File(this.plugin.getDataFolder(), "ShopSigns.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        CommentedYamlConfiguration commentedYamlConfiguration = new CommentedYamlConfiguration();
        yamlConfiguration.options().copyDefaults(true);
        commentedYamlConfiguration.addComment("ShopSigns", "DO NOT EDIT THIS FILE BY HAND!");
        if (!yamlConfiguration.isConfigurationSection("ShopSigns")) {
            yamlConfiguration.createSection("ShopSigns");
        }
        int n = 0;
        for (Board board : this.GetAllBoards()) {
            String string = "ShopSigns." + ++n;
            commentedYamlConfiguration.set(String.valueOf(string) + ".StartPlace", board.GetStartPlace());
            commentedYamlConfiguration.set(String.valueOf(string) + ".World", board.GetWorld());
            commentedYamlConfiguration.set(String.valueOf(string) + ".TX", board.getTopLoc().getBlockX());
            commentedYamlConfiguration.set(String.valueOf(string) + ".TY", board.getTopLoc().getBlockY());
            commentedYamlConfiguration.set(String.valueOf(string) + ".TZ", board.getTopLoc().getBlockZ());
            commentedYamlConfiguration.set(String.valueOf(string) + ".BX", board.getBottomLoc().getBlockX());
            commentedYamlConfiguration.set(String.valueOf(string) + ".BY", board.getBottomLoc().getBlockY());
            commentedYamlConfiguration.set(String.valueOf(string) + ".BZ", board.getBottomLoc().getBlockZ());
        }
        try {
            commentedYamlConfiguration.save(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean BoardUpdateDelayed() {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ShopSignUtil.this.BoardUpdate();
            }
        }, 20L);
        return true;
    }

    public boolean BoardUpdate() {
        for (Board board : this.GetAllBoards()) {
            board.clearSignLoc();
            List<Location> list2 = board.GetLocations();
            ArrayList<String> arrayList = new ArrayList<String>(this.getSortedShopList().keySet());
            int n = board.GetStartPlace();
            for (Location location : list2) {
                Block block = location.getBlock();
                if (!(block.getState() instanceof Sign)) continue;
                String string = "";
                if (arrayList.size() > n) {
                    string = arrayList.get(n);
                }
                ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
                Sign sign = (Sign)block.getState();
                if (claimedResidence == null || string == null || string.equalsIgnoreCase("")) {
                    sign.setLine(0, "");
                    sign.setLine(1, "");
                    sign.setLine(2, "");
                    sign.setLine(3, "");
                    sign.update();
                    continue;
                }
                Vote vote = null;
                String string2 = "";
                if (this.plugin.getResidenceManager().getShops().size() >= n) {
                    vote = this.getAverageVote(arrayList.get(n));
                    string2 = this.plugin.getConfigManager().isOnlyLike() ? (vote.getAmount() == 0 ? "" : this.plugin.msg(lm.Shop_ListLiked, this.getLikes(arrayList.get(n)))) : (vote.getAmount() == 0 ? "" : this.plugin.msg(lm.Shop_SignLines_4, vote.getVote(), vote.getAmount()));
                }
                sign.setLine(0, this.plugin.msg(lm.Shop_SignLines_1, n + 1));
                sign.setLine(1, this.plugin.msg(lm.Shop_SignLines_2, claimedResidence.getName()));
                sign.setLine(2, this.plugin.msg(lm.Shop_SignLines_3, claimedResidence.getOwner()));
                sign.setLine(3, string2);
                sign.update();
                board.addSignLoc(claimedResidence.getName(), sign.getLocation());
                ++n;
            }
        }
        return true;
    }
}

