/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.shopStuff;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.event.ResidenceCreationEvent;
import com.bekvon.bukkit.residence.event.ResidenceDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceFlagChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceRenameEvent;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.shopStuff.Board;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class ShopListener
implements Listener {
    public static List<String> Delete = new ArrayList<String>();
    private Residence plugin;

    public ShopListener(Residence residence) {
        this.plugin = residence;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignInteract(PlayerInteractEvent playerInteractEvent) {
        if (this.plugin.isDisabledWorldListener(playerInteractEvent.getPlayer().getWorld())) {
            return;
        }
        if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        if (block == null) {
            return;
        }
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        Location location = block.getLocation();
        if (Delete.contains(player.getName())) {
            Board board = null;
            for (Board board2 : this.plugin.getShopSignUtilManager().GetAllBoards()) {
                for (Location location2 : board2.GetLocations()) {
                    if (!location.getWorld().getName().equalsIgnoreCase(location2.getWorld().getName()) || location.getBlockX() != location2.getBlockX() || location.getBlockY() != location2.getBlockY() || location.getBlockZ() != location2.getBlockZ()) continue;
                    board = board2;
                    break;
                }
                if (board != null) break;
            }
            if (board != null) {
                this.plugin.getShopSignUtilManager().GetAllBoards().remove(board);
                this.plugin.getShopSignUtilManager().saveSigns();
                this.plugin.msg((CommandSender)player, lm.Shop_DeletedBoard, new Object[0]);
            } else {
                this.plugin.msg((CommandSender)player, lm.Shop_IncorrectBoard, new Object[0]);
            }
            Delete.remove(player.getName());
            return;
        }
        String string = null;
        for (Board board : this.plugin.getShopSignUtilManager().GetAllBoards()) {
            string = board.getResNameByLoc(location);
            if (string != null) break;
        }
        if (string != null) {
            Bukkit.dispatchCommand((CommandSender)playerInteractEvent.getPlayer(), (String)("res tp " + string));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeShop(ResidenceFlagChangeEvent residenceFlagChangeEvent) {
        if (residenceFlagChangeEvent.isCancelled()) {
            return;
        }
        if (!residenceFlagChangeEvent.getFlag().equalsIgnoreCase("shop")) {
            return;
        }
        switch (residenceFlagChangeEvent.getNewState()) {
            case FALSE: 
            case NEITHER: {
                this.plugin.getResidenceManager().removeShop(residenceFlagChangeEvent.getResidence());
                this.plugin.getShopSignUtilManager().BoardUpdate();
                this.plugin.getShopSignUtilManager().saveSigns();
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                this.plugin.getResidenceManager().addShop(residenceFlagChangeEvent.getResidence().getName());
                residenceFlagChangeEvent.getResidence().getPermissions().setFlag("tp", FlagPermissions.FlagState.TRUE);
                residenceFlagChangeEvent.getResidence().getPermissions().setFlag("move", FlagPermissions.FlagState.TRUE);
                residenceFlagChangeEvent.getResidence().getPermissions().setFlag("pvp", FlagPermissions.FlagState.FALSE);
                this.plugin.getShopSignUtilManager().BoardUpdate();
                this.plugin.getShopSignUtilManager().saveSigns();
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceRename(ResidenceRenameEvent residenceRenameEvent) {
        if (!residenceRenameEvent.getResidence().GetShopVotes().isEmpty()) {
            this.plugin.getResidenceManager().addShop(residenceRenameEvent.getResidence());
            this.plugin.getResidenceManager().removeShop(residenceRenameEvent.getOldResidenceName());
            this.plugin.getShopSignUtilManager().saveShopVotes();
            this.plugin.getShopSignUtilManager().BoardUpdateDelayed();
            this.plugin.getShopSignUtilManager().saveSigns();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onFlagChange(ResidenceFlagChangeEvent residenceFlagChangeEvent) {
        if (residenceFlagChangeEvent.isCancelled()) {
            return;
        }
        if (residenceFlagChangeEvent.getFlag().equalsIgnoreCase("tp") && residenceFlagChangeEvent.getNewState() == FlagPermissions.FlagState.TRUE) {
            return;
        }
        if (residenceFlagChangeEvent.getFlag().equalsIgnoreCase("move") && residenceFlagChangeEvent.getNewState() == FlagPermissions.FlagState.TRUE) {
            return;
        }
        if (residenceFlagChangeEvent.getFlag().equalsIgnoreCase("pvp") && residenceFlagChangeEvent.getNewState() == FlagPermissions.FlagState.FALSE) {
            return;
        }
        if (!(residenceFlagChangeEvent.getFlag().equalsIgnoreCase("move") || residenceFlagChangeEvent.getFlag().equalsIgnoreCase("tp") || residenceFlagChangeEvent.getFlag().equalsIgnoreCase("pvp"))) {
            return;
        }
        if (!residenceFlagChangeEvent.getResidence().getPermissions().has("shop", false)) {
            return;
        }
        residenceFlagChangeEvent.setCancelled(true);
        this.plugin.msg((CommandSender)residenceFlagChangeEvent.getPlayer(), lm.Shop_ChantChange, new Object[0]);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceCreate(ResidenceCreationEvent residenceCreationEvent) {
        if (residenceCreationEvent.isCancelled()) {
            return;
        }
        if (!residenceCreationEvent.getResidence().getPermissions().has("shop", false)) {
            return;
        }
        this.plugin.getResidenceManager().addShop(residenceCreationEvent.getResidence().getName());
        this.plugin.getShopSignUtilManager().BoardUpdate();
        this.plugin.getShopSignUtilManager().saveSigns();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceRemove(ResidenceDeleteEvent residenceDeleteEvent) {
        if (residenceDeleteEvent.isCancelled()) {
            return;
        }
        if (!residenceDeleteEvent.getResidence().getPermissions().has("shop", true)) {
            return;
        }
        this.plugin.getResidenceManager().removeShop(residenceDeleteEvent.getResidence());
        this.plugin.getShopSignUtilManager().BoardUpdate();
        this.plugin.getShopSignUtilManager().saveSigns();
    }
}

