/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.selection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.selection.WorldGuardInterface;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.lang.reflect.Method;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WorldGuardUtil
implements WorldGuardInterface {
    private Residence plugin;

    public WorldGuardUtil(Residence residence) {
        this.plugin = residence;
    }

    @Override
    public ProtectedRegion getRegion(Player player, CuboidArea cuboidArea) {
        if (cuboidArea == null) {
            return null;
        }
        if (this.plugin.getWorldGuard() == null) {
            return null;
        }
        if (this.plugin.getWorldEdit() == null) {
            return null;
        }
        Location location = cuboidArea.getLowLoc();
        Location location2 = cuboidArea.getHighLoc();
        String string = "icp__tempregion";
        try {
            BlockVector blockVector = new BlockVector(location.getX(), location.getY(), location.getZ());
            BlockVector blockVector2 = new BlockVector(location2.getX(), location2.getY(), location2.getZ());
            ProtectedRegion protectedRegion = (ProtectedRegion)ProtectedCuboidRegion.class.getConstructor(String.class, BlockVector.class, BlockVector.class).newInstance(string, blockVector, blockVector2);
            Method method = this.plugin.getWorldGuard().getClass().getMethod("getRegionManager", location.getWorld().getClass());
            RegionManager regionManager = (RegionManager)method.invoke((Object)this.plugin.getWorldGuard(), location.getWorld());
            ApplicableRegionSet applicableRegionSet = regionManager.getApplicableRegions(protectedRegion);
            for (ProtectedRegion protectedRegion2 : applicableRegionSet.getRegions()) {
                if (PermissionManager.ResPerm.worldguard_$1.hasPermission((CommandSender)player, protectedRegion2.getId())) continue;
                return protectedRegion2;
            }
        }
        catch (Exception | IncompatibleClassChangeError throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isSelectionInArea(Player player) {
        if (this.plugin.getWorldGuard() == null) {
            return false;
        }
        ProtectedRegion protectedRegion = this.getRegion(player, this.plugin.getSelectionManager().getSelectionCuboid(player));
        if (protectedRegion == null) {
            return false;
        }
        this.plugin.msg((CommandSender)player, lm.Select_WorldGuardOverlap, protectedRegion.getId());
        Location location = new Location(this.plugin.getSelectionManager().getPlayerLoc1(player.getName()).getWorld(), (double)protectedRegion.getMinimumPoint().getBlockX(), (double)protectedRegion.getMinimumPoint().getBlockY(), (double)protectedRegion.getMinimumPoint().getBlockZ());
        Location location2 = new Location(this.plugin.getSelectionManager().getPlayerLoc1(player.getName()).getWorld(), (double)protectedRegion.getMaximumPoint().getBlockX(), (double)protectedRegion.getMaximumPoint().getBlockY(), (double)protectedRegion.getMaximumPoint().getBlockZ());
        Visualizer visualizer = new Visualizer(player);
        visualizer.setAreas(this.plugin.getSelectionManager().getSelectionCuboid(player));
        visualizer.setErrorAreas(new CuboidArea(location, location2));
        this.plugin.getSelectionManager().showBounds(player, visualizer);
        return true;
    }
}

