/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.selection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.selection.WorldGuardInterface;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WorldGuard7Util
implements WorldGuardInterface {
    private Residence plugin;

    public WorldGuard7Util(Residence residence) {
        this.plugin = residence;
    }

    @Override
    public ProtectedRegion getRegion(Player player, CuboidArea cuboidArea) {
        if (cuboidArea == null) {
            return null;
        }
        if (this.plugin.getWorldGuard() == null) {
            return null;
        }
        if (this.plugin.getWorldEdit() == null) {
            return null;
        }
        Location location = cuboidArea.getLowLoc();
        Location location2 = cuboidArea.getHighLoc();
        String string = "icp__tempregion";
        try {
            BlockVector3 blockVector3 = BlockVector3.at((double)location.getX(), (double)location.getY(), (double)location.getZ());
            BlockVector3 blockVector32 = BlockVector3.at((double)location2.getX(), (double)location2.getY(), (double)location2.getZ());
            ProtectedCuboidRegion protectedCuboidRegion = new ProtectedCuboidRegion(string, blockVector3, blockVector32);
            RegionManager regionManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)location.getWorld()));
            ApplicableRegionSet applicableRegionSet = regionManager.getApplicableRegions((ProtectedRegion)protectedCuboidRegion);
            for (ProtectedRegion protectedRegion : applicableRegionSet.getRegions()) {
                if (PermissionManager.ResPerm.worldguard_$1.hasPermission((CommandSender)player, protectedRegion.getId())) continue;
                return protectedRegion;
            }
        }
        catch (Exception | IncompatibleClassChangeError throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isSelectionInArea(Player player) {
        if (this.plugin.getWorldGuard() == null) {
            return false;
        }
        ProtectedRegion protectedRegion = this.getRegion(player, this.plugin.getSelectionManager().getSelectionCuboid(player));
        if (protectedRegion == null) {
            return false;
        }
        this.plugin.msg((CommandSender)player, lm.Select_WorldGuardOverlap, protectedRegion.getId());
        Location location = new Location(this.plugin.getSelectionManager().getPlayerLoc1(player).getWorld(), (double)protectedRegion.getMinimumPoint().getBlockX(), (double)protectedRegion.getMinimumPoint().getBlockY(), (double)protectedRegion.getMinimumPoint().getBlockZ());
        Location location2 = new Location(this.plugin.getSelectionManager().getPlayerLoc1(player).getWorld(), (double)protectedRegion.getMaximumPoint().getBlockX(), (double)protectedRegion.getMaximumPoint().getBlockY(), (double)protectedRegion.getMaximumPoint().getBlockZ());
        Visualizer visualizer = new Visualizer(player);
        visualizer.setAreas(this.plugin.getSelectionManager().getSelectionCuboid(player));
        visualizer.setErrorAreas(new CuboidArea(location, location2));
        this.plugin.getSelectionManager().showBounds(player, visualizer);
        return true;
    }
}

