/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.selection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.selection.SelectionManager;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.selections.CuboidSelection;
import com.sk89q.worldedit.bukkit.selections.Selection;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class WorldEditSelectionManager
extends SelectionManager {
    public WorldEditSelectionManager(Server server2, Residence residence) {
        super(server2, residence);
    }

    @Override
    public boolean worldEdit(Player player) {
        block4: {
            WorldEditPlugin worldEditPlugin = (WorldEditPlugin)this.server.getPluginManager().getPlugin("WorldEdit");
            try {
                Selection selection = (Selection)worldEditPlugin.getClass().getMethod("getSelection", Player.class).invoke((Object)worldEditPlugin, player);
                if (selection == null) break block4;
                Location location = selection.getMinimumPoint();
                Location location2 = selection.getMaximumPoint();
                try {
                    CuboidRegion cuboidRegion = (CuboidRegion)selection.getRegionSelector().getRegion();
                    location = new Location(player.getWorld(), (double)cuboidRegion.getPos1().getX(), (double)cuboidRegion.getPos1().getY(), (double)cuboidRegion.getPos1().getZ());
                    location2 = new Location(player.getWorld(), (double)cuboidRegion.getPos2().getX(), (double)cuboidRegion.getPos2().getY(), (double)cuboidRegion.getPos2().getZ());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.updateLocations(player, location, location2);
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean worldEditUpdate(Player player) {
        if (!this.hasPlacedBoth(player)) {
            return false;
        }
        CuboidSelection cuboidSelection = new CuboidSelection(player.getWorld(), this.getPlayerLoc1(player), this.getPlayerLoc2(player));
        try {
            this.plugin.getWorldEdit().getClass().getMethod("setSelection", Player.class, Selection.class).invoke((Object)this.plugin.getWorldEdit(), player, cuboidSelection);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
        return true;
    }

    @Override
    public void placeLoc1(Player player, Location location, boolean bl) {
        super.placeLoc1(player, location, bl);
        this.worldEditUpdate(player);
    }

    @Override
    public void placeLoc2(Player player, Location location, boolean bl) {
        super.placeLoc2(player, location, bl);
        this.worldEditUpdate(player);
    }

    @Override
    public void sky(Player player, boolean bl) {
        super.sky(player, bl);
        this.worldEditUpdate(player);
    }

    @Override
    public void bedrock(Player player, boolean bl) {
        super.bedrock(player, bl);
        this.worldEditUpdate(player);
    }

    @Override
    public void modify(Player player, boolean bl, double d) {
        super.modify(player, bl, d);
        this.worldEditUpdate(player);
    }

    @Override
    public void selectChunk(Player player) {
        super.selectChunk(player);
        this.worldEditUpdate(player);
    }

    @Override
    public void showSelectionInfo(Player player) {
        super.showSelectionInfo(player);
        this.worldEditUpdate(player);
    }

    @Override
    public void regenerate(CuboidArea cuboidArea) {
        CuboidSelection cuboidSelection = new CuboidSelection(cuboidArea.getWorld(), cuboidArea.getLowLoc(), cuboidArea.getHighLoc());
        try {
            Region region = cuboidSelection.getRegionSelector().getRegion();
            region.getWorld().regenerate(region, WorldEdit.getInstance().getEditSessionFactory().getEditSession(region.getWorld(), -1));
        }
        catch (IncompleteRegionException incompleteRegionException) {
            // empty catch block
        }
    }
}

