/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.selection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.selection.SelectionManager;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.regions.selector.limit.PermissiveSelectorLimits;
import com.sk89q.worldedit.regions.selector.limit.SelectorLimits;
import com.sk89q.worldedit.world.World;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class WorldEdit7SelectionManager
extends SelectionManager {
    public WorldEdit7SelectionManager(Server server2, Residence residence) {
        super(server2, residence);
    }

    @Override
    public boolean worldEdit(Player player) {
        block5: {
            WorldEditPlugin worldEditPlugin = (WorldEditPlugin)this.server.getPluginManager().getPlugin("WorldEdit");
            Region region = null;
            try {
                World world = worldEditPlugin.getSession(player).getSelectionWorld();
                if (world != null) {
                    region = worldEditPlugin.getSession(player).getSelection(world);
                }
                if (region == null) break block5;
                try {
                    Location location = new Location(player.getWorld(), (double)region.getMinimumPoint().getX(), (double)region.getMinimumPoint().getY(), (double)region.getMinimumPoint().getZ());
                    Location location2 = new Location(player.getWorld(), (double)region.getMaximumPoint().getX(), (double)region.getMaximumPoint().getY(), (double)region.getMaximumPoint().getZ());
                    this.updateLocations(player, location, location2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            catch (IncompleteRegionException incompleteRegionException) {
                incompleteRegionException.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean worldEditUpdate(Player player) {
        if (!this.hasPlacedBoth(player)) {
            return false;
        }
        World world = BukkitAdapter.adapt((org.bukkit.World)player.getWorld());
        try {
            this.plugin.getWorldEdit().getSession(player).getRegionSelector(world).selectPrimary(BlockVector3.at((int)this.getPlayerLoc1(player).getBlockX(), (int)this.getPlayerLoc1(player).getBlockY(), (int)this.getPlayerLoc1(player).getBlockZ()), (SelectorLimits)PermissiveSelectorLimits.getInstance());
            this.plugin.getWorldEdit().getSession(player).getRegionSelector(world).selectSecondary(BlockVector3.at((int)this.getPlayerLoc2(player).getBlockX(), (int)this.getPlayerLoc2(player).getBlockY(), (int)this.getPlayerLoc2(player).getBlockZ()), (SelectorLimits)PermissiveSelectorLimits.getInstance());
        }
        catch (Error | Exception throwable) {
            return false;
        }
        return true;
    }

    @Override
    public void placeLoc1(Player player, Location location, boolean bl) {
        super.placeLoc1(player, location, bl);
        this.worldEditUpdate(player);
    }

    @Override
    public void placeLoc2(Player player, Location location, boolean bl) {
        super.placeLoc2(player, location, bl);
        this.worldEditUpdate(player);
    }

    @Override
    public void sky(Player player, boolean bl) {
        super.sky(player, bl);
        this.worldEditUpdate(player);
    }

    @Override
    public void bedrock(Player player, boolean bl) {
        super.bedrock(player, bl);
        this.worldEditUpdate(player);
    }

    @Override
    public void modify(Player player, boolean bl, double d) {
        super.modify(player, bl, d);
        this.worldEditUpdate(player);
    }

    @Override
    public void selectChunk(Player player) {
        super.selectChunk(player);
        this.worldEditUpdate(player);
    }

    @Override
    public void showSelectionInfo(Player player) {
        super.showSelectionInfo(player);
        this.worldEditUpdate(player);
    }

    @Override
    public void regenerate(CuboidArea cuboidArea) {
        CuboidRegionSelector cuboidRegionSelector = new CuboidRegionSelector(BukkitAdapter.adapt((org.bukkit.World)cuboidArea.getWorld()));
        try {
            cuboidRegionSelector.selectPrimary(BlockVector3.at((int)cuboidArea.getLowLoc().getBlockX(), (int)cuboidArea.getLowLoc().getBlockY(), (int)cuboidArea.getLowLoc().getBlockZ()), (SelectorLimits)PermissiveSelectorLimits.getInstance());
            cuboidRegionSelector.selectSecondary(BlockVector3.at((int)cuboidArea.getHighLoc().getBlockX(), (int)cuboidArea.getHighLoc().getBlockY(), (int)cuboidArea.getHighLoc().getBlockZ()), (SelectorLimits)PermissiveSelectorLimits.getInstance());
        }
        catch (Error | Exception throwable) {
            return;
        }
        CuboidRegion cuboidRegion = cuboidRegionSelector.getIncompleteRegion();
        cuboidRegion.getWorld().regenerate((Region)cuboidRegion, WorldEdit.getInstance().getEditSessionFactory().getEditSession(cuboidRegion.getWorld(), -1));
    }
}

