/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.selection;

import com.bekvon.bukkit.cmiLib.ActionBarManager;
import com.bekvon.bukkit.cmiLib.CMIEffect;
import com.bekvon.bukkit.cmiLib.CMIEffectManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.SelectionSides;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;

public class SelectionManager {
    protected Map<UUID, Selection> selections;
    protected Server server;
    protected Residence plugin;
    private HashMap<UUID, Visualizer> vMap = new HashMap();
    public static final int MIN_HEIGHT = 0;
    Permission ignoreyPermission = new Permission(PermissionManager.ResPerm.bypass_ignorey.getPermission(), PermissionDefault.FALSE);
    Permission ignoreyinsubzonePermission = new Permission(PermissionManager.ResPerm.bypass_ignoreyinsubzone.getPermission(), PermissionDefault.FALSE);

    private int getMaxWorldHeight(World world) {
        if (world == null) {
            return 255;
        }
        switch (world.getEnvironment()) {
            case NETHER: {
                return this.plugin.getConfigManager().getSelectionNetherHeight();
            }
            case NORMAL: 
            case THE_END: {
                return 255;
            }
        }
        return 255;
    }

    public SelectionManager(Server server2, Residence residence) {
        this.plugin = residence;
        this.server = server2;
        this.selections = Collections.synchronizedMap(new HashMap());
    }

    public Selection getSelection(Player player) {
        Selection selection = this.selections.get(player.getUniqueId());
        if (selection == null) {
            selection = new Selection(player);
            this.selections.put(player.getUniqueId(), selection);
        }
        return selection;
    }

    public void updateLocations(Player player) {
        Selection selection = this.selections.get(player.getUniqueId());
        if (selection != null) {
            this.updateLocations(player, this.getSelection(player).getBaseLoc1(), this.getSelection(player).getBaseLoc2(), true);
        }
    }

    public void updateLocations(Player player, Location location, Location location2) {
        this.updateLocations(player, location, location2, false);
    }

    public void updateLocations(Player player, Location location, Location location2, boolean bl) {
        Selection selection = this.getSelection(player);
        if (location != null) {
            selection.setBaseLoc1(location);
        }
        if (location2 != null) {
            selection.setBaseLoc2(location2);
        }
        this.afterSelectionUpdate(player, bl);
    }

    public void placeLoc1(Player player, Location location) {
        this.placeLoc1(player, location, false);
    }

    public void placeLoc1(Player player, Location location, boolean bl) {
        if (location != null) {
            this.getSelection(player).setBaseLoc1(location);
            if (bl) {
                this.afterSelectionUpdate(player);
            }
        }
    }

    public void placeLoc2(Player player, Location location) {
        this.placeLoc2(player, location, false);
    }

    public void placeLoc2(Player player, Location location, boolean bl) {
        if (location != null) {
            this.getSelection(player).setBaseLoc2(location);
            if (bl) {
                this.afterSelectionUpdate(player);
            }
        }
    }

    public void afterSelectionUpdate(Player player) {
        this.afterSelectionUpdate(player, false);
    }

    public void afterSelectionUpdate(Player player, boolean bl) {
        if (!this.hasPlacedBoth(player)) {
            return;
        }
        Visualizer visualizer = this.vMap.get(player.getUniqueId());
        if (visualizer == null) {
            visualizer = new Visualizer(player);
            this.vMap.put(player.getUniqueId(), visualizer);
        }
        visualizer.setStart(System.currentTimeMillis());
        visualizer.cancelAll();
        if (bl) {
            visualizer.setLoc(null);
        }
        visualizer.setAreas(this.getSelectionCuboid(player));
        visualizer.setOnce(false);
        this.showBounds(player, visualizer);
    }

    public Location getPlayerLoc1(Player player) {
        if (player == null) {
            return null;
        }
        Selection selection = this.getSelection(player);
        if (selection == null) {
            return null;
        }
        CuboidArea cuboidArea = selection.getResizedArea();
        if (cuboidArea == null) {
            return null;
        }
        return cuboidArea.getLowLoc();
    }

    @Deprecated
    public Location getPlayerLoc1(String string) {
        return this.getPlayerLoc1(Bukkit.getPlayer((String)string));
    }

    public Location getPlayerLoc2(Player player) {
        if (player == null) {
            return null;
        }
        Selection selection = this.getSelection(player);
        if (selection == null) {
            return null;
        }
        CuboidArea cuboidArea = selection.getResizedArea();
        if (cuboidArea == null) {
            return null;
        }
        return cuboidArea.getHighLoc();
    }

    @Deprecated
    public Location getPlayerLoc2(String string) {
        return this.getPlayerLoc2(Bukkit.getPlayer((String)string));
    }

    public CuboidArea getSelectionCuboid(Player player) {
        if (player == null) {
            return null;
        }
        return this.getSelection(player).getResizedArea();
    }

    @Deprecated
    public CuboidArea getSelectionCuboid(String string) {
        if (!this.hasPlacedBoth(string)) {
            return null;
        }
        return this.getSelectionCuboid(Bukkit.getPlayer((String)string));
    }

    public boolean hasPlacedBoth(Player player) {
        if (player == null) {
            return false;
        }
        return this.getSelection(player).hasPlacedBoth();
    }

    @Deprecated
    public boolean hasPlacedBoth(String string) {
        return this.hasPlacedBoth(Bukkit.getPlayer((String)string));
    }

    public void showSelectionInfoInActionBar(Player player) {
        if (!this.plugin.getConfigManager().useActionBarOnSelection()) {
            return;
        }
        CuboidArea cuboidArea = this.getSelectionCuboid(player);
        String string = this.plugin.msg(lm.Select_TotalSize, cuboidArea.getSize());
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup permissionGroup = residencePlayer.getGroup();
        if (this.plugin.getConfigManager().enableEconomy()) {
            string = String.valueOf(string) + " " + this.plugin.msg(lm.General_LandCost, cuboidArea.getCost(permissionGroup));
        }
        ActionBarManager.send(player, string);
    }

    public void showSelectionInfo(Player player) {
        if (this.hasPlacedBoth(player)) {
            this.plugin.msg((CommandSender)player, lm.General_Separator, new Object[0]);
            CuboidArea cuboidArea = this.getSelectionCuboid(player);
            this.plugin.msg((CommandSender)player, lm.Select_TotalSize, cuboidArea.getSize());
            ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
            PermissionGroup permissionGroup = residencePlayer.getGroup();
            if (this.plugin.getConfigManager().enableEconomy()) {
                this.plugin.msg((CommandSender)player, lm.General_LandCost, cuboidArea.getCost(permissionGroup));
            }
            player.sendMessage(ChatColor.YELLOW + "X" + this.plugin.msg(lm.General_Size, cuboidArea.getXSize()));
            player.sendMessage(ChatColor.YELLOW + "Y" + this.plugin.msg(lm.General_Size, cuboidArea.getYSize()));
            player.sendMessage(ChatColor.YELLOW + "Z" + this.plugin.msg(lm.General_Size, cuboidArea.getZSize()));
            this.plugin.msg((CommandSender)player, lm.General_Separator, new Object[0]);
            Visualizer visualizer = new Visualizer(player);
            visualizer.setAreas(this.getSelectionCuboid(player));
            this.showBounds(player, visualizer);
        } else {
            this.plugin.msg((CommandSender)player, lm.Select_Points, new Object[0]);
        }
    }

    public void showBounds(final Player player, final Visualizer visualizer) {
        if (!this.plugin.getConfigManager().useVisualizer()) {
            return;
        }
        Visualizer visualizer2 = this.vMap.get(player.getUniqueId());
        if (visualizer2 != null) {
            visualizer2.cancelAll();
        }
        this.vMap.put(player.getUniqueId(), visualizer);
        if (!this.plugin.isEnabled()) {
            return;
        }
        visualizer.setBaseShedId(Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!visualizer.getAreas().isEmpty()) {
                    SelectionManager.this.MakeBorders(player, false);
                }
                if (!visualizer.getErrorAreas().isEmpty()) {
                    SelectionManager.this.MakeBorders(player, true);
                }
            }
        }).getTaskId());
    }

    public List<Location> getLocations(Location location, Location location2, Double d, Double d2, Double d3, Double d4, boolean bl) {
        double d5 = this.plugin.getConfigManager().getVisualizerRowSpacing();
        double d6 = this.plugin.getConfigManager().getVisualizerCollumnSpacing();
        if (d == 0.0) {
            d = d5 + d5 * 0.1;
        }
        if (d2 == 0.0) {
            d2 = d6 + d6 * 0.1;
        }
        if (d3 == 0.0) {
            d3 = d5 + d5 * 0.1;
        }
        double d7 = d5;
        double d8 = d6;
        if (bl) {
            d7 = 0.0;
            d8 = 0.0;
        }
        ArrayList<Location> arrayList = new ArrayList<Location>();
        if (location.getWorld() != location2.getWorld()) {
            return arrayList;
        }
        double d9 = d7;
        while (d9 < d) {
            Location location3 = location.clone();
            if (d > d5 + d5 * 0.1) {
                location3.add(d9, 0.0, 0.0);
            }
            double d10 = d8;
            while (d10 < d2) {
                Location location4 = location3.clone();
                if (d2 > d6 + d6 * 0.1) {
                    location4.add(0.0, d10, 0.0);
                }
                double d11 = d7;
                while (d11 < d3) {
                    double d12;
                    Location location5 = location4.clone();
                    if (d3 > d5 + d5 * 0.1) {
                        location5.add(0.0, 0.0, d11);
                    }
                    if ((d12 = location2.distance(location5)) < d4) {
                        arrayList.add(location5.clone());
                    }
                    d11 += d5;
                }
                d10 += d6;
            }
            d9 += d5;
        }
        return arrayList;
    }

    public List<Location> GetLocationsWallsByData(Location location, Double d, Double d2, Double d3, Location location2, SelectionSides selectionSides, double d4) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        if (selectionSides.ShowNorthSide()) {
            arrayList.addAll(this.getLocations(location2.clone(), location.clone(), d, d2, 0.0, d4, false));
        }
        if (selectionSides.ShowSouthSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, 0.0, d3.doubleValue()), location.clone(), d, d2, 0.0, d4, false));
        }
        if (selectionSides.ShowWestSide()) {
            arrayList.addAll(this.getLocations(location2.clone(), location.clone(), 0.0, d2, d3, d4, false));
        }
        if (selectionSides.ShowEastSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(d.doubleValue(), 0.0, 0.0), location.clone(), 0.0, d2, d3, d4, false));
        }
        if (selectionSides.ShowTopSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, d2.doubleValue(), 0.0), location.clone(), d, 0.0, d3, d4, false));
        }
        if (selectionSides.ShowBottomSide()) {
            arrayList.addAll(this.getLocations(location2.clone(), location.clone(), d, 0.0, d3, d4, false));
        }
        return arrayList;
    }

    public List<Location> GetLocationsCornersByData(Location location, Double d, Double d2, Double d3, Location location2, SelectionSides selectionSides, double d4) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        if (selectionSides.ShowBottomSide() && selectionSides.ShowNorthSide()) {
            arrayList.addAll(this.getLocations(location2.clone(), location.clone(), d, 0.0, 0.0, d4, true));
        }
        if (selectionSides.ShowTopSide() && selectionSides.ShowNorthSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, d2.doubleValue(), 0.0), location.clone(), d, 0.0, 0.0, d4, true));
        }
        if (selectionSides.ShowBottomSide() && selectionSides.ShowSouthSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, 0.0, d3.doubleValue()), location.clone(), d, 0.0, 0.0, d4, true));
        }
        if (selectionSides.ShowTopSide() && selectionSides.ShowSouthSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, d2.doubleValue(), d3.doubleValue()), location.clone(), d, 0.0, 0.0, d4, true));
        }
        if (selectionSides.ShowWestSide() && selectionSides.ShowNorthSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, 0.0, 0.0), location.clone(), 0.0, d2, 0.0, d4, true));
        }
        if (selectionSides.ShowEastSide() && selectionSides.ShowNorthSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(d.doubleValue(), 0.0, 0.0), location.clone(), 0.0, d2, 0.0, d4, true));
        }
        if (selectionSides.ShowSouthSide() && selectionSides.ShowWestSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, 0.0, d3.doubleValue()), location.clone(), 0.0, d2, 0.0, d4, true));
        }
        if (selectionSides.ShowSouthSide() && selectionSides.ShowEastSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(d.doubleValue(), 0.0, d3.doubleValue()), location.clone(), 0.0, d2 + 1.0, 0.0, d4, true));
        }
        if (selectionSides.ShowWestSide() && selectionSides.ShowBottomSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, 0.0, 0.0), location.clone(), 0.0, 0.0, d3, d4, true));
        }
        if (selectionSides.ShowEastSide() && selectionSides.ShowBottomSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(d.doubleValue(), 0.0, 0.0), location.clone(), 0.0, 0.0, d3, d4, true));
        }
        if (selectionSides.ShowWestSide() && selectionSides.ShowTopSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(0.0, d2.doubleValue(), 0.0), location.clone(), 0.0, 0.0, d3, d4, true));
        }
        if (selectionSides.ShowEastSide() && selectionSides.ShowTopSide()) {
            arrayList.addAll(this.getLocations(location2.clone().add(d.doubleValue(), d2.doubleValue(), 0.0), location.clone(), 0.0, 0.0, d3, d4, true));
        }
        return arrayList;
    }

    public boolean MakeBorders(final Player player, final boolean bl) {
        final Visualizer visualizer = this.vMap.get(player.getUniqueId());
        if (visualizer == null) {
            return false;
        }
        List<CuboidArea> list2 = null;
        list2 = !bl ? visualizer.getAreas() : visualizer.getErrorAreas();
        Location location = player.getLocation();
        int n = this.plugin.getConfigManager().getVisualizerRange();
        final ArrayList<Location> arrayList = new ArrayList<Location>();
        final ArrayList<Location> arrayList2 = new ArrayList<Location>();
        boolean bl2 = visualizer.isSameLoc();
        if (!bl2) {
            for (CuboidArea cuboidArea : list2) {
                if (cuboidArea == null) continue;
                CuboidArea cuboidArea2 = new CuboidArea(cuboidArea.getLowLoc(), cuboidArea.getHighLoc());
                cuboidArea2.getHighLoc().add(1.0, 1.0, 1.0);
                SelectionSides selectionSides = new SelectionSides();
                double d = location.getBlockX() - n;
                double d2 = location.getBlockZ() - n;
                double d3 = location.getBlockY() - n;
                double d4 = location.getBlockX() + n;
                double d5 = location.getBlockZ() + n;
                double d6 = location.getBlockY() + n;
                if ((double)cuboidArea2.getLowLoc().getBlockX() < d) {
                    cuboidArea2.getLowLoc().setX(d);
                    selectionSides.setWestSide(false);
                }
                if ((double)cuboidArea2.getHighLoc().getBlockX() > d4) {
                    cuboidArea2.getHighLoc().setX(d4);
                    selectionSides.setEastSide(false);
                }
                if ((double)cuboidArea2.getLowLoc().getBlockZ() < d2) {
                    cuboidArea2.getLowLoc().setZ(d2);
                    selectionSides.setNorthSide(false);
                }
                if ((double)cuboidArea2.getHighLoc().getBlockZ() > d5) {
                    cuboidArea2.getHighLoc().setZ(d5);
                    selectionSides.setSouthSide(false);
                }
                if ((double)cuboidArea2.getLowLoc().getBlockY() < d3) {
                    cuboidArea2.getLowLoc().setY(d3);
                    selectionSides.setBottomSide(false);
                }
                if ((double)cuboidArea2.getHighLoc().getBlockY() > d6) {
                    cuboidArea2.getHighLoc().setY(d6);
                    selectionSides.setTopSide(false);
                }
                double d7 = cuboidArea2.getXSize() - 1;
                double d8 = cuboidArea2.getYSize() - 1;
                double d9 = cuboidArea2.getZSize() - 1;
                if (!bl && visualizer.getId() != -1) {
                    Bukkit.getScheduler().cancelTask(visualizer.getId());
                } else if (bl && visualizer.getErrorId() != -1) {
                    Bukkit.getScheduler().cancelTask(visualizer.getErrorId());
                }
                arrayList.addAll(this.GetLocationsWallsByData(location, d7, d8, d9, cuboidArea2.getLowLoc().clone(), selectionSides, n));
                arrayList2.addAll(this.GetLocationsCornersByData(location, d7, d8, d9, cuboidArea2.getLowLoc().clone(), selectionSides, n));
            }
            visualizer.setLoc(player.getLocation());
        } else if (bl) {
            arrayList.addAll(visualizer.getErrorLocations());
            arrayList2.addAll(visualizer.getErrorLocations2());
        } else {
            arrayList.addAll(visualizer.getLocations());
            arrayList2.addAll(visualizer.getLocations2());
        }
        if (!this.plugin.isEnabled()) {
            return false;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                int n = arrayList.size();
                int n2 = arrayList2.size();
                int n3 = 1;
                int n4 = 1;
                if (n > SelectionManager.this.plugin.getConfigManager().getVisualizerSidesCap()) {
                    n3 = n / SelectionManager.this.plugin.getConfigManager().getVisualizerSidesCap() + 1;
                }
                if (n2 > SelectionManager.this.plugin.getConfigManager().getVisualizerFrameCap()) {
                    n4 = n2 / SelectionManager.this.plugin.getConfigManager().getVisualizerFrameCap() + 1;
                }
                visualizer.addCurrentSkip();
                if (visualizer.getCurrentSkip() > SelectionManager.this.plugin.getConfigManager().getVisualizerSkipBy()) {
                    visualizer.setCurrentSkip(1);
                }
                try {
                    SelectionManager.this.showParticles(arrayList, player, n3, bl, true, visualizer.getCurrentSkip());
                    SelectionManager.this.showParticles(arrayList2, player, n4, bl, false, visualizer.getCurrentSkip());
                }
                catch (Exception exception) {
                    return;
                }
                if (bl) {
                    visualizer.setErrorLocations(arrayList);
                    visualizer.setErrorLocations2(arrayList2);
                } else {
                    visualizer.setLocations(arrayList);
                    visualizer.setLocations2(arrayList2);
                }
            }
        });
        if (visualizer.isOnce()) {
            return true;
        }
        if (visualizer.getStart() + (long)this.plugin.getConfigManager().getVisualizerShowFor() < System.currentTimeMillis()) {
            return false;
        }
        int n2 = Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (player.isOnline()) {
                    SelectionManager.this.MakeBorders(player, bl);
                }
            }
        }, (long)this.plugin.getConfigManager().getVisualizerUpdateInterval() * 1L);
        if (!bl) {
            visualizer.setId(n2);
        } else {
            visualizer.setErrorId(n2);
        }
        return true;
    }

    private void showParticles(List<Location> list2, Player player, int n, boolean bl, boolean bl2, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < list2.size()) {
            if (++n3 > this.plugin.getConfigManager().getVisualizerSkipBy()) {
                n3 = 1;
            }
            if (n3 == n2) {
                Location location = list2.get(n4);
                CMIEffectManager.CMIParticle cMIParticle = null;
                cMIParticle = bl2 ? (bl ? this.plugin.getConfigManager().getOverlapSides() : this.plugin.getConfigManager().getSelectedSides()) : (bl ? this.plugin.getConfigManager().getOverlapFrame() : this.plugin.getConfigManager().getSelectedFrame());
                CMIEffect cMIEffect = new CMIEffect(cMIParticle);
                Residence.getInstance().getNms().playEffect(player, location, cMIEffect);
            }
            n4 += n;
        }
    }

    public void vert(Player player, boolean bl) {
        if (this.hasPlacedBoth(player)) {
            this.sky(player, bl);
            this.bedrock(player, bl);
        } else {
            this.plugin.msg((CommandSender)player, lm.Select_Points, new Object[0]);
        }
    }

    public void sky(Player player, boolean bl) {
        Selection selection = this.getSelection(player);
        selection.sky(bl);
    }

    public void bedrock(Player player, boolean bl) {
        Selection selection = this.getSelection(player);
        selection.bedrock(bl);
    }

    public void clearSelection(Player player) {
        this.selections.remove(player.getUniqueId());
    }

    @Deprecated
    public void selectChunk(Player player) {
        Selection selection = this.getSelection(player);
        selection.selectChunk();
    }

    public boolean worldEdit(Player player) {
        this.plugin.msg((CommandSender)player, lm.General_WorldEditNotFound, new Object[0]);
        return false;
    }

    public boolean worldEditUpdate(Player player) {
        this.plugin.msg((CommandSender)player, lm.General_WorldEditNotFound, new Object[0]);
        return false;
    }

    public void selectBySize(Player player, int n, int n2, int n3) {
        Location location = player.getLocation();
        Location location2 = new Location(location.getWorld(), (double)(location.getBlockX() + n), (double)(location.getBlockY() + n2), (double)(location.getBlockZ() + n3));
        Location location3 = new Location(location.getWorld(), (double)(location.getBlockX() - n), (double)(location.getBlockY() - n2), (double)(location.getBlockZ() - n3));
        CuboidArea cuboidArea = new CuboidArea(location2, location3);
        this.placeLoc1(player, location2, false);
        this.placeLoc2(player, location3, false);
        Selection selection = this.getSelection(player);
        if (selection.getMaxYAllowed() < cuboidArea.getHighLoc().getBlockY()) {
            selection.getBaseLoc2().setY((double)selection.getMaxYAllowed());
        }
        if (selection.getMinYAllowed() > cuboidArea.getLowLoc().getBlockY()) {
            selection.getBaseLoc1().setY((double)selection.getMinYAllowed());
        }
        this.afterSelectionUpdate(player);
        this.plugin.msg((CommandSender)player, lm.Select_Success, new Object[0]);
        this.showSelectionInfo(player);
    }

    public void modify(Player player, boolean bl, double d) {
        if (!this.hasPlacedBoth(player)) {
            this.plugin.msg((CommandSender)player, lm.Select_Points, new Object[0]);
            return;
        }
        Direction direction2 = SelectionManager.getDirection(player);
        if (direction2 == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Direction, new Object[0]);
            return;
        }
        CuboidArea cuboidArea = this.getSelectionCuboid(player);
        switch (direction2) {
            case DOWN: {
                double d2 = cuboidArea.getLowLoc().getBlockY();
                d2 -= d;
                if (d2 < 0.0) {
                    this.plugin.msg((CommandSender)player, lm.Select_TooLow, new Object[0]);
                    d2 = 0.0;
                }
                cuboidArea.getLowLoc().setY(d2);
                if (bl) {
                    double d3 = cuboidArea.getHighLoc().getBlockY();
                    cuboidArea.getHighLoc().setY(d3 -= d);
                    this.plugin.msg((CommandSender)player, lm.Shifting_Down, d);
                    break;
                }
                this.plugin.msg((CommandSender)player, lm.Expanding_Down, d);
                break;
            }
            case MINUSX: {
                double d4 = cuboidArea.getLowLoc().getBlockX();
                cuboidArea.getLowLoc().setX(d4 -= d);
                if (bl) {
                    double d5 = cuboidArea.getHighLoc().getBlockX();
                    cuboidArea.getHighLoc().setX(d5 -= d);
                    this.plugin.msg((CommandSender)player, lm.Shifting_West, d);
                    break;
                }
                this.plugin.msg((CommandSender)player, lm.Expanding_West, d);
                break;
            }
            case MINUSZ: {
                double d6 = cuboidArea.getLowLoc().getBlockZ();
                cuboidArea.getLowLoc().setZ(d6 -= d);
                if (bl) {
                    double d7 = cuboidArea.getHighLoc().getBlockZ();
                    cuboidArea.getHighLoc().setZ(d7 -= d);
                    this.plugin.msg((CommandSender)player, lm.Shifting_North, d);
                    break;
                }
                this.plugin.msg((CommandSender)player, lm.Expanding_North, d);
                break;
            }
            case PLUSX: {
                double d8 = cuboidArea.getHighLoc().getBlockX();
                cuboidArea.getHighLoc().setX(d8 += d);
                if (bl) {
                    double d9 = cuboidArea.getLowLoc().getBlockX();
                    cuboidArea.getLowLoc().setX(d9 += d);
                    this.plugin.msg((CommandSender)player, lm.Shifting_East, d);
                    break;
                }
                this.plugin.msg((CommandSender)player, lm.Expanding_East, d);
                break;
            }
            case PLUSZ: {
                double d10 = cuboidArea.getHighLoc().getBlockZ();
                cuboidArea.getHighLoc().setZ(d10 += d);
                if (bl) {
                    double d11 = cuboidArea.getLowLoc().getBlockZ();
                    cuboidArea.getLowLoc().setZ(d11 += d);
                    this.plugin.msg((CommandSender)player, lm.Shifting_South, d);
                    break;
                }
                this.plugin.msg((CommandSender)player, lm.Expanding_South, d);
                break;
            }
            case UP: {
                double d12 = cuboidArea.getHighLoc().getBlockY();
                d12 += d;
                if (d12 > (double)(this.getMaxWorldHeight(player.getLocation().getWorld()) - 1)) {
                    this.plugin.msg((CommandSender)player, lm.Select_TooHigh, new Object[0]);
                    d12 = this.getMaxWorldHeight(player.getLocation().getWorld()) - 1;
                }
                cuboidArea.getHighLoc().setY(d12);
                if (bl) {
                    double d13 = cuboidArea.getLowLoc().getBlockY();
                    cuboidArea.getLowLoc().setY(d13 += d);
                    this.plugin.msg((CommandSender)player, lm.Shifting_Up, d);
                    break;
                }
                this.plugin.msg((CommandSender)player, lm.Expanding_Up, d);
                break;
            }
        }
        this.updateLocations(player, cuboidArea.getHighLoc(), cuboidArea.getLowLoc(), true);
    }

    public boolean contract(Player player, double d) {
        return this.contract(player, d, false);
    }

    public boolean contract(Player player, double d, boolean bl) {
        if (!this.hasPlacedBoth(player)) {
            this.plugin.msg((CommandSender)player, lm.Select_Points, new Object[0]);
            return false;
        }
        Direction direction2 = SelectionManager.getDirection(player);
        if (direction2 == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Direction, new Object[0]);
            return false;
        }
        CuboidArea cuboidArea = this.getSelectionCuboid(player);
        switch (direction2) {
            case UP: {
                double d2 = cuboidArea.getHighLoc().getBlockY();
                d2 -= d;
                if (d2 > (double)(this.getMaxWorldHeight(player.getLocation().getWorld()) - 1)) {
                    this.plugin.msg((CommandSender)player, lm.Select_TooHigh, new Object[0]);
                    d2 = this.getMaxWorldHeight(player.getLocation().getWorld()) - 1;
                }
                cuboidArea.getHighLoc().setY(d2);
                this.plugin.msg((CommandSender)player, lm.Contracting_Down, d);
                break;
            }
            case PLUSX: {
                double d3 = cuboidArea.getHighLoc().getBlockX();
                cuboidArea.getHighLoc().setX(d3 -= d);
                this.plugin.msg((CommandSender)player, lm.Contracting_West, d);
                break;
            }
            case PLUSZ: {
                double d4 = cuboidArea.getHighLoc().getBlockZ();
                cuboidArea.getHighLoc().setZ(d4 -= d);
                this.plugin.msg((CommandSender)player, lm.Contracting_North, d);
                break;
            }
            case MINUSX: {
                double d5 = cuboidArea.getLowLoc().getBlockX();
                cuboidArea.getLowLoc().setX(d5 += d);
                this.plugin.msg((CommandSender)player, lm.Contracting_East, d);
                break;
            }
            case MINUSZ: {
                double d6 = cuboidArea.getLowLoc().getBlockZ();
                cuboidArea.getLowLoc().setZ(d6 += d);
                this.plugin.msg((CommandSender)player, lm.Contracting_South, d);
                break;
            }
            case DOWN: {
                double d7 = cuboidArea.getLowLoc().getBlockY();
                d7 += d;
                if (d7 < 0.0) {
                    this.plugin.msg((CommandSender)player, lm.Select_TooLow, new Object[0]);
                    d7 = 0.0;
                }
                cuboidArea.getLowLoc().setY(d7);
                this.plugin.msg((CommandSender)player, lm.Contracting_Up, d);
                break;
            }
        }
        this.updateLocations(player, cuboidArea.getHighLoc(), cuboidArea.getLowLoc(), true);
        return true;
    }

    private static Direction getDirection(Player player) {
        int n = (int)player.getLocation().getYaw();
        if (n < 0) {
            n += 360;
        }
        n += 45;
        int n2 = (n %= 360) / 90;
        float f = player.getLocation().getPitch();
        if (f < -50.0f) {
            return Direction.UP;
        }
        if (f > 50.0f) {
            return Direction.DOWN;
        }
        if (n2 == 1) {
            return Direction.MINUSX;
        }
        if (n2 == 3) {
            return Direction.PLUSX;
        }
        if (n2 == 2) {
            return Direction.MINUSZ;
        }
        if (n2 == 0) {
            return Direction.PLUSZ;
        }
        return null;
    }

    public void regenerate(CuboidArea cuboidArea) {
    }

    public void onDisable() {
        for (Map.Entry<UUID, Visualizer> entry : this.vMap.entrySet()) {
            entry.getValue().cancelAll();
        }
        this.vMap.clear();
    }

    public static enum Direction {
        UP,
        DOWN,
        PLUSX,
        PLUSZ,
        MINUSX,
        MINUSZ;

    }

    public class Selection {
        private Player player;
        private Location loc1;
        private Location loc2;

        public Selection(Player player) {
            this.player = player;
        }

        public Location getBaseLoc1() {
            return this.loc1 == null ? null : this.loc1.clone();
        }

        public void setBaseLoc1(Location location) {
            this.loc1 = location.clone();
        }

        public World getWorld() {
            if (this.loc1 != null) {
                return this.loc1.getWorld();
            }
            if (this.loc2 != null) {
                return this.loc2.getWorld();
            }
            return this.player.getWorld();
        }

        public Location getBaseLoc2() {
            return this.loc2 == null ? null : this.loc2.clone();
        }

        public void setBaseLoc2(Location location) {
            this.loc2 = location.clone();
        }

        public selectionType getSelectionRestrictions() {
            if (this.inSameResidence()) {
                if (SelectionManager.this.plugin.getConfigManager().isSelectionIgnoreYInSubzone() && this.hasPlacedBoth() && !this.player.hasPermission(SelectionManager.this.ignoreyinsubzonePermission)) {
                    return selectionType.residenceBounds;
                }
            } else if (SelectionManager.this.plugin.getConfigManager().isSelectionIgnoreY() && this.hasPlacedBoth() && !this.player.hasPermission(SelectionManager.this.ignoreyPermission)) {
                return selectionType.ignoreY;
            }
            return selectionType.noLimits;
        }

        public int getMaxYAllowed() {
            CuboidArea cuboidArea;
            switch (this.getSelectionRestrictions()) {
                default: {
                    return SelectionManager.this.getMaxWorldHeight(this.getWorld());
                }
                case residenceBounds: 
            }
            ClaimedResidence claimedResidence = SelectionManager.this.plugin.getResidenceManager().getByLoc(this.getBaseLoc2());
            if (claimedResidence != null && (cuboidArea = claimedResidence.getAreaByLoc(this.getBaseLoc2())) != null) {
                return cuboidArea.getHighLoc().getBlockY();
            }
            return SelectionManager.this.getMaxWorldHeight(this.getWorld());
        }

        public int getMinYAllowed() {
            CuboidArea cuboidArea;
            switch (this.getSelectionRestrictions()) {
                default: {
                    return 0;
                }
                case residenceBounds: 
            }
            ClaimedResidence claimedResidence = SelectionManager.this.plugin.getResidenceManager().getByLoc(this.getBaseLoc1());
            if (claimedResidence != null && (cuboidArea = claimedResidence.getAreaByLoc(this.getBaseLoc1())) != null) {
                return cuboidArea.getLowLoc().getBlockY();
            }
            return 0;
        }

        private boolean inSameResidence() {
            if (!this.hasPlacedBoth()) {
                return false;
            }
            ClaimedResidence claimedResidence = SelectionManager.this.plugin.getResidenceManager().getByLoc(this.getBaseLoc1());
            if (claimedResidence == null) {
                return false;
            }
            ClaimedResidence claimedResidence2 = SelectionManager.this.plugin.getResidenceManager().getByLoc(this.getBaseLoc2());
            if (claimedResidence2 == null) {
                return false;
            }
            return claimedResidence.getName().equals(claimedResidence2.getName());
        }

        public void vert(boolean bl) {
            if (this.hasPlacedBoth()) {
                this.sky(bl);
                this.bedrock(bl);
            } else {
                SelectionManager.this.plugin.msg((CommandSender)this.player, lm.Select_Points, new Object[0]);
            }
        }

        private void shadowSky(CuboidArea cuboidArea) {
            if (!this.hasPlacedBoth()) {
                return;
            }
            cuboidArea.setHighLocation(this.getBaseArea().getHighLoc());
            cuboidArea.getHighLoc().setY((double)this.getMaxYAllowed());
        }

        private void shadowBedrock(CuboidArea cuboidArea) {
            if (!this.hasPlacedBoth()) {
                return;
            }
            cuboidArea.setLowLocation(this.getBaseArea().getLowLoc());
            cuboidArea.getLowLoc().setY((double)this.getMinYAllowed());
        }

        public void sky(boolean bl) {
            if (this.hasPlacedBoth()) {
                ResidencePlayer residencePlayer = SelectionManager.this.plugin.getPlayerManager().getResidencePlayer(this.getPlayer());
                PermissionGroup permissionGroup = residencePlayer.getGroup();
                CuboidArea cuboidArea = this.getBaseArea();
                int n = cuboidArea.getLowLoc().getBlockY();
                int n2 = this.getMaxYAllowed();
                if (!bl) {
                    if (permissionGroup.getMaxHeight() < n2) {
                        n2 = permissionGroup.getMaxHeight();
                    }
                    if (n2 - n > permissionGroup.getMaxY() - 1) {
                        n2 = n + (permissionGroup.getMaxY() - 1);
                    }
                }
                this.loc1 = cuboidArea.getLowLoc();
                this.loc2 = cuboidArea.getHighLoc();
                this.loc2.setY((double)n2);
                SelectionManager.this.plugin.msg((CommandSender)this.player, lm.Select_Sky, new Object[0]);
            } else {
                SelectionManager.this.plugin.msg((CommandSender)this.player, lm.Select_Points, new Object[0]);
            }
        }

        public void bedrock(boolean bl) {
            if (this.hasPlacedBoth()) {
                ResidencePlayer residencePlayer = SelectionManager.this.plugin.getPlayerManager().getResidencePlayer(this.getPlayer());
                PermissionGroup permissionGroup = residencePlayer.getGroup();
                CuboidArea cuboidArea = this.getBaseArea();
                int n = cuboidArea.getHighLoc().getBlockY();
                int n2 = this.getMinYAllowed();
                if (!bl) {
                    if (n2 < permissionGroup.getMinHeight()) {
                        n2 = permissionGroup.getMinHeight();
                    }
                    if (n - n2 > permissionGroup.getMaxY() - 1) {
                        n2 = n - (permissionGroup.getMaxY() - 1);
                    }
                }
                this.loc1 = cuboidArea.getLowLoc();
                this.loc2 = cuboidArea.getHighLoc();
                this.loc1.setY((double)n2);
                SelectionManager.this.plugin.msg((CommandSender)this.player, lm.Select_Bedrock, new Object[0]);
            } else {
                SelectionManager.this.plugin.msg((CommandSender)this.player, lm.Select_Points, new Object[0]);
            }
        }

        public void selectChunk() {
            Chunk chunk = this.player.getWorld().getChunkAt(this.player.getLocation());
            int n = chunk.getX() * 16;
            int n2 = chunk.getZ() * 16;
            int n3 = n + 15;
            int n4 = n2 + 15;
            this.setBaseLoc1(new Location(this.player.getWorld(), (double)n, (double)this.getMinYAllowed(), (double)n2));
            this.setBaseLoc2(new Location(this.player.getWorld(), (double)n3, (double)this.getMaxYAllowed(), (double)n4));
            SelectionManager.this.plugin.msg((CommandSender)this.player, lm.Select_Success, new Object[0]);
        }

        public boolean hasPlacedBoth() {
            return this.getBaseLoc1() != null && this.getBaseLoc2() != null;
        }

        public Player getPlayer() {
            return this.player;
        }

        public void setPlayer(Player player) {
            this.player = player;
        }

        public CuboidArea getBaseArea() {
            if (!this.hasPlacedBoth()) {
                return null;
            }
            return new CuboidArea(this.loc1, this.loc2);
        }

        public CuboidArea getResizedArea() {
            CuboidArea cuboidArea = this.getBaseArea();
            switch (this.getSelectionRestrictions()) {
                case noLimits: {
                    break;
                }
                case ignoreY: 
                case residenceBounds: {
                    this.shadowSky(cuboidArea);
                    this.shadowBedrock(cuboidArea);
                    break;
                }
            }
            return cuboidArea;
        }
    }

    public static enum selectionType {
        noLimits,
        ignoreY,
        residenceBounds;

    }
}

