/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.selection;

import com.bekvon.bukkit.cmiLib.Version;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.selection.WESchematicManager;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.schematic.SchematicFormat;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class SchematicsManager
implements WESchematicManager {
    private Residence plugin;

    public SchematicsManager(Residence residence) {
        this.plugin = residence;
    }

    @Override
    public boolean save(ClaimedResidence claimedResidence) {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            return false;
        }
        if (this.plugin.getWorldEdit() == null) {
            return false;
        }
        if (claimedResidence == null) {
            return false;
        }
        CuboidArea cuboidArea = claimedResidence.getAreaArray()[0];
        Vector vector = new Vector(cuboidArea.getLowLoc().getBlockX(), cuboidArea.getLowLoc().getBlockY(), cuboidArea.getLowLoc().getBlockZ());
        Vector vector2 = new Vector(cuboidArea.getHighLoc().getBlockX(), cuboidArea.getHighLoc().getBlockY(), cuboidArea.getHighLoc().getBlockZ());
        Vector vector3 = new Vector(cuboidArea.getLowLoc().getBlockX(), cuboidArea.getLowLoc().getBlockY(), cuboidArea.getLowLoc().getBlockZ());
        World world = Bukkit.getWorld((String)claimedResidence.getWorld());
        if (world == null) {
            return false;
        }
        EditSession editSession = (EditSession)EditSession.class.getConstructor(BukkitWorld.class, Integer.class).newInstance(new BukkitWorld(world), Integer.MAX_VALUE);
        editSession.enableQueue();
        CuboidClipboard cuboidClipboard = new CuboidClipboard(vector2.subtract(vector).add(new Vector(1, 1, 1)), vector3);
        cuboidClipboard.setOrigin(vector3);
        cuboidClipboard.copy(editSession);
        File file = new File(this.plugin.getDataLocation(), "Schematics");
        if (!file.exists()) {
            try {
                file.mkdir();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (!(file = new File(this.plugin.getDataLocation(), "Schematics" + File.separator + claimedResidence.getWorld())).exists()) {
            try {
                file.mkdir();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        File file2 = new File(this.plugin.getDataLocation(), "Schematics" + File.separator + claimedResidence.getWorld() + File.separator + claimedResidence.getName() + ".schematic");
        try {
            SchematicFormat.MCEDIT.save(cuboidClipboard, file2);
        }
        catch (Exception exception) {
            if (this.plugin.getWorldGuardVersion() >= 7) {
                editSession.flushSession();
            } else {
                editSession.getClass().getMethod("flushQueue", new Class[0]).invoke((Object)editSession, new Object[0]);
            }
            return false;
        }
        try {
            if (this.plugin.getWorldGuardVersion() >= 7) {
                editSession.flushSession();
            } else {
                editSession.getClass().getMethod("flushQueue", new Class[0]).invoke((Object)editSession, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
        return true;
    }

    @Override
    public boolean load(ClaimedResidence claimedResidence) {
        CuboidClipboard cuboidClipboard;
        EditSession editSession;
        block18: {
            ClaimedResidence claimedResidence2;
            ClaimedResidence claimedResidence3;
            block17: {
                World world;
                block16: {
                    File file;
                    block15: {
                        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                            return false;
                        }
                        if (this.plugin.getWorldEdit() == null) {
                            return false;
                        }
                        if (claimedResidence == null) {
                            return false;
                        }
                        world = Bukkit.getWorld((String)claimedResidence.getWorld());
                        if (world == null) {
                            return false;
                        }
                        editSession = (EditSession)EditSession.class.getConstructor(BukkitWorld.class, Integer.class).newInstance(new BukkitWorld(world), Integer.MAX_VALUE);
                        file = new File(this.plugin.getDataLocation(), "Schematics" + File.separator + claimedResidence.getWorld() + File.separator + claimedResidence.getName() + ".schematic");
                        if (file.exists()) break block15;
                        return false;
                    }
                    cuboidClipboard = null;
                    try {
                        cuboidClipboard = CuboidClipboard.loadSchematic((File)file);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return false;
                    }
                    if (cuboidClipboard != null) break block16;
                    return false;
                }
                Vector vector = cuboidClipboard.getOrigin();
                claimedResidence3 = this.plugin.getResidenceManager().getByLoc(new Location(world, (double)vector.getBlockX(), (double)vector.getBlockY(), (double)vector.getBlockZ()));
                claimedResidence2 = this.plugin.getResidenceManager().getByLoc(new Location(world, (double)(vector.getBlockX() + cuboidClipboard.getWidth() - 1), (double)(vector.getBlockY() + cuboidClipboard.getHeight() - 1), (double)(vector.getBlockZ() + cuboidClipboard.getLength() - 1)));
                if (claimedResidence3 != null && claimedResidence2 != null) break block17;
                return false;
            }
            if (claimedResidence3.getName().equalsIgnoreCase(claimedResidence2.getName())) break block18;
            return false;
        }
        try {
            try {
                cuboidClipboard.paste(editSession, cuboidClipboard.getOrigin(), false);
            }
            catch (MaxChangedBlocksException maxChangedBlocksException) {
                maxChangedBlocksException.printStackTrace();
                return false;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
        return true;
    }

    @Override
    public boolean delete(ClaimedResidence claimedResidence) {
        if (this.plugin.getWorldEdit() == null) {
            return false;
        }
        if (claimedResidence == null) {
            return false;
        }
        File file = new File(this.plugin.getDataLocation(), "Schematics" + File.separator + claimedResidence.getWorld() + File.separator + claimedResidence.getName() + ".schematic");
        if (!file.exists()) {
            return false;
        }
        return file.delete();
    }

    @Override
    public boolean rename(ClaimedResidence claimedResidence, String string) {
        if (this.plugin.getWorldEdit() == null) {
            return false;
        }
        if (claimedResidence == null) {
            return false;
        }
        File file = new File(this.plugin.getDataLocation(), "Schematics" + File.separator + claimedResidence.getWorld() + File.separator + claimedResidence.getName() + ".schematic");
        if (!file.exists()) {
            return false;
        }
        File file2 = new File(this.plugin.getDataLocation(), "Schematics" + File.separator + claimedResidence.getWorld() + File.separator + string + ".schematic");
        return file.renameTo(file2);
    }
}

