/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.selection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.manager.game.GameManagement;

public class KingdomsUtil {
    private Residence plugin;

    public KingdomsUtil(Residence residence) {
        this.plugin = residence;
    }

    public Land getRegion(CuboidArea cuboidArea) {
        if (this.plugin.getKingdomsManager() == null) {
            return null;
        }
        if (cuboidArea == null) {
            return null;
        }
        Chunk chunk = cuboidArea.getLowLoc().getChunk();
        Chunk chunk2 = cuboidArea.getHighLoc().getChunk();
        World world = chunk.getWorld();
        int n = chunk.getX();
        while (n <= chunk2.getX()) {
            int n2 = chunk.getZ();
            while (n2 <= chunk2.getZ()) {
                Chunk chunk3 = world.getChunkAt(n, n2);
                SimpleChunkLocation simpleChunkLocation = new SimpleChunkLocation(chunk3);
                Land land = GameManagement.getLandManager().getOrLoadLand(simpleChunkLocation);
                if (land != null && land.getOwner() != null) {
                    return land;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public boolean isSelectionInArea(Player player) {
        if (this.plugin.getKingdomsManager() == null) {
            return false;
        }
        Land land = this.getRegion(this.plugin.getSelectionManager().getSelectionCuboid(player));
        if (land == null) {
            return false;
        }
        this.plugin.msg((CommandSender)player, lm.Select_KingdomsOverlap, land.getOwner());
        SimpleChunkLocation simpleChunkLocation = land.getLoc();
        World world = Bukkit.getWorld((String)simpleChunkLocation.getWorld());
        Location location = new Location(this.plugin.getSelectionManager().getPlayerLoc1(player.getName()).getWorld(), (double)(simpleChunkLocation.getX() * 16), 0.0, (double)(simpleChunkLocation.getZ() * 16));
        Location location2 = new Location(this.plugin.getSelectionManager().getPlayerLoc1(player.getName()).getWorld(), (double)(simpleChunkLocation.getX() * 16 + 16), (double)world.getMaxHeight(), (double)(simpleChunkLocation.getZ() * 16 + 16));
        Visualizer visualizer = new Visualizer(player);
        visualizer.setAreas(this.plugin.getSelectionManager().getSelectionCuboid(player));
        visualizer.setErrorAreas(new CuboidArea(location, location2));
        this.plugin.getSelectionManager().showBounds(player, visualizer);
        return true;
    }
}

