/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.selection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.AutoSelector;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AutoSelection {
    private HashMap<UUID, AutoSelector> list = new HashMap();
    private Residence plugin;

    public AutoSelection(Residence residence) {
        this.plugin = residence;
    }

    public void switchAutoSelection(Player player) {
        if (!this.list.containsKey(player.getUniqueId())) {
            ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
            PermissionGroup permissionGroup = residencePlayer.getGroup(player.getWorld().getName());
            this.list.put(player.getUniqueId(), new AutoSelector(permissionGroup, System.currentTimeMillis()));
            this.plugin.msg((CommandSender)player, lm.Select_AutoEnabled, new Object[0]);
        } else {
            this.list.remove(player.getUniqueId());
            this.plugin.msg((CommandSender)player, lm.Select_AutoDisabled, new Object[0]);
        }
    }

    public void UpdateSelection(Player player) {
        this.UpdateSelection(player, player.getLocation());
    }

    public void UpdateSelection(Player player, Location location) {
        if (!this.list.containsKey(player.getUniqueId())) {
            return;
        }
        AutoSelector autoSelector = this.list.get(player.getUniqueId());
        int n = (int)(System.currentTimeMillis() - autoSelector.getTime()) / 1000;
        if (n > 270) {
            this.list.remove(player.getUniqueId());
            this.plugin.msg((CommandSender)player, lm.Select_AutoDisabled, new Object[0]);
            return;
        }
        Location location2 = location.clone();
        Location location3 = this.plugin.getSelectionManager().getPlayerLoc1(player);
        Location location4 = this.plugin.getSelectionManager().getPlayerLoc2(player);
        if (location3 == null) {
            this.plugin.getSelectionManager().placeLoc1(player, location2, false);
            location3 = player.getLocation();
        }
        if (location4 == null) {
            this.plugin.getSelectionManager().placeLoc2(player, location2, true);
            return;
        }
        boolean bl = false;
        CuboidArea cuboidArea = new CuboidArea(location3, location4);
        Location location5 = cuboidArea.getHighLoc();
        Location location6 = cuboidArea.getLowLoc();
        if (location2.getBlockX() < location6.getBlockX()) {
            location6.setX((double)location2.getBlockX());
            bl = true;
        }
        if (location2.getBlockY() <= location6.getBlockY()) {
            location6.setY((double)(location2.getBlockY() - 1));
            bl = true;
        }
        if (location2.getBlockZ() < location6.getBlockZ()) {
            location6.setZ((double)location2.getBlockZ());
            bl = true;
        }
        if (location2.getBlockX() > location5.getBlockX()) {
            location5.setX((double)location2.getBlockX());
            bl = true;
        }
        if (location2.getBlockY() >= location5.getBlockY()) {
            location5.setY((double)(location2.getBlockY() + 1));
            bl = true;
        }
        if (location2.getBlockZ() > location5.getBlockZ()) {
            location5.setZ((double)location2.getBlockZ());
            bl = true;
        }
        PermissionGroup permissionGroup = autoSelector.getGroup();
        if (cuboidArea.getXSize() > permissionGroup.getMaxX()) {
            return;
        }
        if (cuboidArea.getYSize() > permissionGroup.getMaxY() && !this.plugin.getConfigManager().isSelectionIgnoreY()) {
            return;
        }
        if (cuboidArea.getZSize() > permissionGroup.getMaxZ()) {
            return;
        }
        if (bl) {
            this.plugin.getSelectionManager().placeLoc1(player, location5, false);
            this.plugin.getSelectionManager().placeLoc2(player, location6, true);
            this.plugin.getSelectionManager().showSelectionInfoInActionBar(player);
        }
    }

    public HashMap<UUID, AutoSelector> getList() {
        return this.list;
    }
}

